/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.MessageSecurityConfig;
import com.sun.enterprise.config.serverbeans.ProviderConfig;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.cli.CLIUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-message-security-providers")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.message.security.provider")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=SecurityService.class, opType=RestEndpoint.OpType.GET, path="list-message-security-providers", description="list-message-security-providers")})
public class ListMessageSecurityProvider
implements AdminCommand,
AdminCommandSecurity.Preauthorization {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListMessageSecurityProvider.class);
    @Param(name="target", primary=true, optional=true, defaultValue="server")
    private String target;
    @Inject
    @Named(value="default-instance-name")
    private Config config;
    @Inject
    private Domain domain;
    @Param(name="layer", acceptableValues="SOAP,HttpServlet", optional=true)
    String authLayer;
    @AccessRequired.To(value={"read"})
    private SecurityService secService;

    public boolean preAuthorization(AdminCommandContext context) {
        this.config = CLIUtil.chooseConfig(this.domain, this.target, context.getActionReport());
        if (this.config == null) {
            return false;
        }
        this.secService = this.config.getSecurityService();
        return true;
    }

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        this.secService.getMessageSecurityConfig();
        report.getTopMessagePart().setMessage(localStrings.getLocalString("list.message.security.provider.success", "list-message-security-providers successful"));
        report.getTopMessagePart().setChildrenType("");
        for (MessageSecurityConfig msc : this.secService.getMessageSecurityConfig()) {
            ActionReport.MessagePart part;
            if (this.authLayer == null) {
                for (ProviderConfig pc : msc.getProviderConfig()) {
                    part = report.getTopMessagePart().addChild();
                    part.setMessage(pc.getProviderId());
                }
                continue;
            }
            if (!msc.getAuthLayer().equals(this.authLayer)) continue;
            for (ProviderConfig pc : msc.getProviderConfig()) {
                part = report.getTopMessagePart().addChild();
                part.setMessage(pc.getProviderId());
            }
        }
    }
}

