/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ssl.manager;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509KeyManager;

public class UnifiedX509KeyManager
implements X509KeyManager {
    private final X509KeyManager[] mgrs;
    private final String[] tokenNames;

    public UnifiedX509KeyManager(X509KeyManager[] mgrs, String[] tokenNames) {
        if (mgrs == null || tokenNames == null) {
            throw new IllegalArgumentException("Null array of X509KeyManagers or tokenNames");
        }
        if (mgrs.length != tokenNames.length) {
            throw new IllegalArgumentException("Size of X509KeyManagers array and tokenNames array do not match.");
        }
        this.mgrs = mgrs;
        this.tokenNames = tokenNames;
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        X509KeyManager mgr;
        String alias = null;
        X509KeyManager[] x509KeyManagerArray = this.mgrs;
        int n = x509KeyManagerArray.length;
        for (int i = 0; i < n && (alias = (mgr = x509KeyManagerArray[i]).chooseClientAlias(keyType, issuers, socket)) == null; ++i) {
        }
        return alias;
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        X509KeyManager mgr;
        String alias = null;
        X509KeyManager[] x509KeyManagerArray = this.mgrs;
        int n = x509KeyManagerArray.length;
        for (int i = 0; i < n && (alias = (mgr = x509KeyManagerArray[i]).chooseServerAlias(keyType, issuers, socket)) == null; ++i) {
        }
        return alias;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        X509KeyManager mgr;
        X509Certificate[] chain = null;
        X509KeyManager[] x509KeyManagerArray = this.mgrs;
        int n = x509KeyManagerArray.length;
        for (int i = 0; i < n && (chain = (mgr = x509KeyManagerArray[i]).getCertificateChain(alias)) == null; ++i) {
        }
        return chain;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        ArrayList<String> clientAliases = new ArrayList<String>();
        for (X509KeyManager mgr : this.mgrs) {
            String[] clAliases = mgr.getClientAliases(keyType, issuers);
            if (clAliases == null || clAliases.length <= 0) continue;
            for (String element : clAliases) {
                clientAliases.add(element);
            }
        }
        return clientAliases.size() == 0 ? null : clientAliases.toArray(new String[clientAliases.size()]);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        X509KeyManager mgr;
        PrivateKey privKey = null;
        X509KeyManager[] x509KeyManagerArray = this.mgrs;
        int n = x509KeyManagerArray.length;
        for (int i = 0; i < n && (privKey = (mgr = x509KeyManagerArray[i]).getPrivateKey(alias)) == null; ++i) {
        }
        return privKey;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        ArrayList<String> serverAliases = new ArrayList<String>();
        for (X509KeyManager mgr : this.mgrs) {
            String[] serAliases = mgr.getServerAliases(keyType, issuers);
            if (serAliases == null || serAliases.length <= 0) continue;
            for (String element : serAliases) {
                serverAliases.add(element);
            }
        }
        return serverAliases.size() == 0 ? null : serverAliases.toArray(new String[serverAliases.size()]);
    }

    public X509KeyManager[] getX509KeyManagers() {
        X509KeyManager[] kmgrs = new X509KeyManager[this.mgrs.length];
        System.arraycopy(this.mgrs, 0, kmgrs, 0, this.mgrs.length);
        return kmgrs;
    }

    public String[] getTokenNames() {
        String[] tokens = new String[this.tokenNames.length];
        System.arraycopy(this.tokenNames, 0, tokens, 0, this.tokenNames.length);
        return tokens;
    }

    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        return this.chooseClientAlias(keyType, issuers, null);
    }

    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return this.chooseServerAlias(keyType, issuers, null);
    }
}

