/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Button;
import com.sun.webui.jsf.component.DropDown;
import com.sun.webui.jsf.component.FileChooser;
import com.sun.webui.jsf.component.HelpInline;
import com.sun.webui.jsf.component.Icon;
import com.sun.webui.jsf.component.Label;
import com.sun.webui.jsf.component.StaticText;
import com.sun.webui.jsf.component.TextField;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.ClientSniffer;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.JsonUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIOutput;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.ConverterException;
import jakarta.json.JsonObject;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;

public class FileChooserRenderer
extends AbstractRenderer {
    private static final boolean DEBUG = false;
    public static final String HYFEN = "-";

    @Override
    public void decode(FacesContext context, UIComponent component) {
        if (this.isDisabled(component) || this.isReadOnly(component)) {
            return;
        }
        if (!(component instanceof FileChooser)) {
            throw new FacesException("FileChooserRenderer can only render FileChooser components.");
        }
        FileChooser chooser = (FileChooser)component;
        if (chooser.getSubmittedValue() == null) {
            this.decodeSubmittedValue(context, chooser);
        }
    }

    private void decodeSubmittedValue(FacesContext context, FileChooser chooser) {
        String selectionsId = chooser.getClientId(context) + ":" + chooser.getId() + "_selections";
        Map requestParameters = context.getExternalContext().getRequestParameterValuesMap();
        String[] selections = (String[])requestParameters.get(selectionsId);
        if (selections != null) {
            chooser.setSubmittedValue(selections);
        } else {
            chooser.setSubmittedValue(null);
        }
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        if (!(component instanceof FileChooser)) {
            String msg = "Can only convert values for FileChooser component.";
            throw new ConverterException(msg);
        }
        return ((FileChooser)component).getConvertedValue(context, (FileChooser)component, submittedValue);
    }

    @Override
    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (component == null) {
            return;
        }
        try {
            FileChooser chooser = null;
            if (!(component instanceof FileChooser)) {
                String message = "Component " + component.toString() + " has been associated with a FileChooser.  This renderer can only be used by components  that extend com.sun.webui.jsf.component.FileChooser.";
                throw new FacesException(message);
            }
            chooser = (FileChooser)component;
            if (!chooser.isRendered()) {
                return;
            }
            Theme theme = ThemeUtilities.getTheme(context);
            writer.startElement("div", component);
            writer.writeAttribute("id", (Object)component.getClientId(context), null);
            String style = chooser.getStyle();
            if (style != null) {
                writer.writeAttribute("style", (Object)style, null);
            }
            RenderingUtilities.renderStyleClass(context, writer, component, null);
            writer.writeText((Object)"\n", null);
            this.renderChooserTitle(context, chooser, writer, theme);
            writer.startElement("div", component);
            writer.writeAttribute("class", (Object)theme.getStyleClass("FILECHOOSER_CONMGN"), null);
            writer.writeText((Object)"\n", null);
            writer.startElement("table", (UIComponent)chooser);
            writer.writeAttribute("border", (Object)"0", "border");
            writer.writeAttribute("cellpadding", (Object)"0", "cellpadding");
            writer.writeAttribute("cellspacing", (Object)"0", "cellspacing");
            writer.writeAttribute("title", (Object)" ", "title");
            writer.writeText((Object)"\n", null);
            writer.startElement("tr", (UIComponent)chooser);
            writer.startElement("td", (UIComponent)chooser);
            this.renderServerName(context, chooser, writer, theme);
            this.renderClearDiv(context, chooser, writer, theme);
            this.renderLookinTextField(context, chooser, writer, theme);
            this.renderClearDiv(context, chooser, writer, theme);
            this.renderFilterField(context, chooser, writer, theme);
            this.renderClearDiv(context, chooser, writer, theme);
            String helpMessage = theme.getMessage("filechooser.enterKeyHelp");
            this.renderInlineHelp(context, chooser, writer, helpMessage, theme);
            this.renderClearDiv(context, chooser, writer, theme);
            writer.endElement("td");
            writer.endElement("tr");
            writer.writeText((Object)"\n", null);
            writer.startElement("tr", (UIComponent)chooser);
            writer.startElement("td", (UIComponent)chooser);
            writer.startElement("hr", (UIComponent)chooser);
            writer.writeAttribute("color", (Object)"#98a0a5", null);
            writer.writeAttribute("size", (Object)"1", null);
            writer.endElement("hr");
            writer.endElement("td");
            writer.endElement("tr");
            writer.writeText((Object)"\n", null);
            writer.startElement("tr", (UIComponent)chooser);
            writer.startElement("td", (UIComponent)chooser);
            this.renderButtons(context, chooser, writer, theme);
            this.renderSortFields(context, chooser, writer, theme);
            writer.endElement("td");
            writer.endElement("tr");
            writer.writeText((Object)"\n", null);
            writer.startElement("tr", (UIComponent)chooser);
            writer.startElement("td", (UIComponent)chooser);
            writer.startElement("div", (UIComponent)chooser);
            writer.writeAttribute("class", (Object)theme.getStyleClass("FILECHOOSER_LST_HDR"), null);
            writer.startElement("div", (UIComponent)chooser);
            writer.writeAttribute("class", (Object)theme.getStyleClass("FILECHOOSER_NAME_HDR"), null);
            writer.write(theme.getMessage("filechooser.name_column_header"));
            writer.endElement("div");
            writer.writeText((Object)"\n", null);
            writer.startElement("div", (UIComponent)chooser);
            writer.writeAttribute("class", (Object)theme.getStyleClass("FILECHOOSER_SIZE_HDR"), null);
            writer.write(theme.getMessage("filechooser.size_column_header"));
            writer.endElement("div");
            writer.writeText((Object)"\n", null);
            writer.startElement("div", (UIComponent)chooser);
            writer.writeAttribute("class", (Object)theme.getStyleClass("FILECHOOSER_DATE_TIME_HDR"), null);
            writer.write(theme.getMessage("filechooser.date_time_column_header"));
            writer.endElement("div");
            writer.writeText((Object)"\n", null);
            writer.endElement("div");
            writer.endElement("td");
            writer.endElement("tr");
            writer.writeText((Object)"\n", null);
            writer.startElement("tr", (UIComponent)chooser);
            writer.startElement("td", (UIComponent)chooser);
            this.renderFileList(context, chooser, writer, theme);
            writer.endElement("td");
            writer.endElement("tr");
            this.renderMultiSelectHelp(context, chooser, writer, theme);
            writer.startElement("tr", (UIComponent)chooser);
            writer.startElement("td", (UIComponent)chooser);
            writer.writeText((Object)"\n", null);
            this.renderSelectText(context, chooser, writer, theme);
            writer.endElement("td");
            writer.endElement("tr");
            writer.writeText((Object)"\n", null);
            writer.startElement("tr", (UIComponent)chooser);
            writer.startElement("td", (UIComponent)chooser);
            writer.startElement("hr", (UIComponent)chooser);
            writer.writeAttribute("color", (Object)"#98a0a5", null);
            writer.writeAttribute("size", (Object)"1", null);
            writer.endElement("hr");
            writer.endElement("td");
            writer.endElement("tr");
            writer.writeText((Object)"\n", null);
            writer.endElement("table");
            writer.endElement("div");
            writer.endElement("div");
            String hiddenID = chooser.getClientId(context) + ":" + chooser.getId() + "_hiddenField";
            writer.startElement("input", (UIComponent)chooser);
            writer.writeAttribute("id", (Object)hiddenID, null);
            writer.writeAttribute("name", (Object)hiddenID, null);
            writer.writeAttribute("type", (Object)"hidden", null);
            writer.writeAttribute("value", (Object)"NOACTION", null);
            writer.endElement("input");
            Button hiddenButton = (Button)chooser.getHiddenFCButton();
            hiddenButton.setStyleClass(theme.getStyleClass("HIDDEN"));
            RenderingUtilities.renderComponent((UIComponent)hiddenButton, context);
            this.renderJavaScript(chooser, context, writer, theme);
        }
        catch (Exception e) {
            throw new FacesException("Filechooser throws exception whilerendering: " + e.getMessage());
        }
    }

    private void renderSelectedSelections(FacesContext context, FileChooser chooser, ResponseWriter writer) throws Exception {
        writer.startElement("select", (UIComponent)chooser);
        String id = chooser.getClientId(context) + ":" + chooser.getId() + "_selections";
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("style", (Object)"{display:none}", null);
        writer.writeAttribute("multiple", (Object)"multiple", null);
        writer.endElement("select");
    }

    private void renderRoots(FacesContext context, FileChooser chooser, ResponseWriter writer) throws IOException {
        String[] roots = chooser.getRoots();
        writer.startElement("select", (UIComponent)chooser);
        String id = chooser.getClientId(context) + ":" + chooser.getId() + "_roots";
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("style", (Object)"{display:none}", null);
        writer.writeAttribute("multiple", (Object)"multiple", null);
        for (int i = 0; i < roots.length; ++i) {
            writer.startElement("option", (UIComponent)chooser);
            writer.writeAttribute("value", (Object)roots[i], null);
            writer.endElement("option");
        }
        writer.endElement("select");
    }

    protected void renderServerName(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws IOException {
        UIOutput uio = (UIOutput)chooser.getServerNameText();
        Label label = (Label)chooser.getServerNameLabel();
        if (!uio.isRendered() || !label.isRendered()) {
            return;
        }
        writer.startElement("div", (UIComponent)chooser);
        writer.writeAttribute("class", (Object)theme.getStyleClass("FILECHOOSER_SRV_DIV"), null);
        writer.startElement("div", (UIComponent)chooser);
        writer.writeAttribute("class", (Object)theme.getStyleClass("FILECHOOSER_LEV2_DIV"), null);
        RenderingUtilities.renderComponent((UIComponent)label, context);
        writer.endElement("div");
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent((UIComponent)uio, context);
        writer.endElement("div");
        writer.writeText((Object)"\n", null);
    }

    protected void renderChooserTitle(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws IOException {
        StaticText title = (StaticText)chooser.getFileChooserTitle();
        if (!title.isRendered()) {
            return;
        }
        writer.startElement("table", (UIComponent)chooser);
        writer.writeAttribute("width", (Object)"100%", "width");
        writer.writeAttribute("border", (Object)"0", "border");
        writer.writeAttribute("cellpadding", (Object)"0", "cellpadding");
        writer.writeAttribute("cellspacing", (Object)"0", "cellspacing");
        writer.writeAttribute("title", (Object)"", "title");
        writer.startElement("tr", (UIComponent)chooser);
        writer.writeAttribute("valign", (Object)"bottom", "valign");
        writer.startElement("td", (UIComponent)chooser);
        writer.writeAttribute("valign", (Object)"bottom", "valign");
        writer.startElement("div", (UIComponent)chooser);
        writer.writeAttribute("class", (Object)theme.getStyleClass("TITLE_TEXT_DIV"), "class");
        writer.startElement("h1", (UIComponent)chooser);
        writer.writeAttribute("class", (Object)theme.getStyleClass("TITLE_TEXT"), "class");
        RenderingUtilities.renderComponent((UIComponent)title, context);
        writer.endElement("h1");
        writer.endElement("div");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        writer.writeText((Object)"\n", null);
    }

    protected void renderInlineHelp(FacesContext context, FileChooser chooser, ResponseWriter writer, String messageKey, Theme theme) throws IOException {
        UIComponent help = chooser.getEnterInlineHelp();
        writer.startElement("div", (UIComponent)chooser);
        writer.writeAttribute("class", (Object)theme.getStyleClass("FILECHOOSER_FLT_HLP_DIV"), null);
        if (help.isRendered()) {
            RenderingUtilities.renderComponent(help, context);
        }
        writer.writeText((Object)"\n", null);
        writer.endElement("div");
        writer.writeText((Object)"\n", null);
    }

    protected void renderLookinTextField(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws IOException {
        TextField lookinField = (TextField)chooser.getLookInTextField();
        if (!lookinField.isRendered()) {
            return;
        }
        writer.startElement("div", (UIComponent)chooser);
        writer.writeAttribute("class", (Object)theme.getStyleClass("FILECHOOSER_LOOK_IN_DIV"), null);
        writer.writeText((Object)"\n", null);
        writer.startElement("div", (UIComponent)chooser);
        writer.writeAttribute("class", (Object)theme.getStyleClass("FILECHOOSER_LEV2_DIV"), null);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent(chooser.getLookInLabel(), context);
        writer.endElement("div");
        writer.writeText((Object)"\n", null);
        this.setEnterKeyPressHandler(context, chooser, (UIComponent)lookinField);
        RenderingUtilities.renderComponent((UIComponent)lookinField, context);
        writer.endElement("div");
        writer.writeText((Object)"\n", null);
    }

    protected void renderFilterField(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws Exception {
        TextField filterOnField = (TextField)chooser.getFilterTextField();
        if (!filterOnField.isRendered()) {
            return;
        }
        writer.startElement("div", (UIComponent)chooser);
        writer.writeAttribute("class", (Object)theme.getStyleClass("FILECHOOSER_FLT_DIV"), null);
        writer.writeText((Object)"\n", null);
        writer.startElement("div", (UIComponent)chooser);
        writer.writeAttribute("class", (Object)theme.getStyleClass("FILECHOOSER_LEV2_DIV"), null);
        RenderingUtilities.renderComponent(chooser.getFilterLabel(), context);
        writer.endElement("div");
        writer.writeText((Object)"\n", null);
        this.setEnterKeyPressHandler(context, chooser, (UIComponent)filterOnField);
        RenderingUtilities.renderComponent((UIComponent)filterOnField, context);
        writer.endElement("div");
        writer.writeText((Object)"\n", null);
    }

    protected void renderSortFields(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws IOException {
        writer.startElement("div", (UIComponent)chooser);
        writer.writeAttribute("class", (Object)theme.getStyleClass("FILECHOOSER_SORT_BY_DIV"), null);
        writer.writeText((Object)"\n", null);
        Label sortLabel = (Label)chooser.getSortComponentLabel();
        DropDown jdd = (DropDown)chooser.getSortComponent();
        if (!jdd.isRendered()) {
            return;
        }
        if (sortLabel.isRendered()) {
            RenderingUtilities.renderComponent((UIComponent)sortLabel, context);
        }
        RenderingUtilities.renderComponent((UIComponent)jdd, context);
        writer.writeText((Object)"\n", null);
        writer.endElement("div");
        writer.writeText((Object)"\n", null);
    }

    protected void renderFileList(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws Exception {
        writer.startElement("div", (UIComponent)chooser);
        writer.writeAttribute("class", (Object)theme.getStyleClass("FILECHOOSER_LST_DIV"), null);
        UIComponent fileList = chooser.getListComponent();
        this.createJavaScriptForFileList(chooser, context, fileList);
        this.setEnterKeyPressHandler(context, chooser, fileList);
        RenderingUtilities.renderComponent(fileList, context);
        writer.endElement("div");
        writer.writeText((Object)"\n", null);
    }

    protected void renderMultiSelectHelp(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws Exception {
        HelpInline help = (HelpInline)chooser.getMultiSelectHelp();
        if (help != null && help.isRendered()) {
            writer.startElement("tr", (UIComponent)chooser);
            writer.startElement("td", (UIComponent)chooser);
            writer.startElement("div", (UIComponent)chooser);
            writer.writeAttribute("class", (Object)theme.getStyleClass("FILECHOOSER_MULT_HLP_DIV"), null);
            RenderingUtilities.renderComponent((UIComponent)help, context);
            writer.endElement("div");
            this.renderClearDiv(context, chooser, writer, theme);
            writer.endElement("td");
            writer.endElement("tr");
        }
    }

    protected void renderButtons(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws IOException {
        writer.startElement("div", (UIComponent)chooser);
        writer.writeAttribute("class", (Object)theme.getStyleClass("FILECHOOSER_BTN_GRP_DIV"), null);
        this.renderUpLevelButton(context, chooser, writer, theme);
        this.renderOpenFolderButton(context, chooser, writer, theme);
        writer.endElement("div");
    }

    protected void renderUpLevelButton(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws IOException {
        writer.writeText((Object)"\n", null);
        Button child = (Button)chooser.getUpLevelButton(false);
        if (!child.isRendered()) {
            return;
        }
        StringBuilder jsBuffer = new StringBuilder();
        jsBuffer.append(JavaScriptUtilities.getDomNode(context, (UIComponent)chooser));
        jsBuffer.append(".moveUpButtonClicked();");
        child.setOnClick(jsBuffer.toString());
        RenderingUtilities.renderComponent((UIComponent)child, context);
        writer.writeText((Object)"\n", null);
    }

    protected void renderOpenFolderButton(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws IOException {
        writer.writeText((Object)"\n", null);
        Button child = (Button)chooser.getOpenFolderButton();
        if (!child.isRendered()) {
            return;
        }
        StringBuilder jsBuffer = new StringBuilder();
        jsBuffer.append(JavaScriptUtilities.getDomNode(context, (UIComponent)chooser));
        jsBuffer.append(".openFolderClicked();");
        child.setOnClick(jsBuffer.toString());
        RenderingUtilities.renderComponent((UIComponent)child, context);
        writer.writeText((Object)"\n", null);
    }

    protected void renderSelectText(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws IOException {
        TextField selectedTextField = (TextField)chooser.getSelectedTextField();
        if (!selectedTextField.isRendered()) {
            return;
        }
        writer.startElement("div", (UIComponent)chooser);
        writer.writeAttribute("class", (Object)theme.getStyleClass("FILECHOOSER_SEL_FILE_DIV"), null);
        writer.writeText((Object)"\n", null);
        writer.startElement("div", (UIComponent)chooser);
        writer.writeAttribute("class", (Object)theme.getStyleClass("FILECHOOSER_SEL_FILE_LEV2_DIV"), null);
        RenderingUtilities.renderComponent(chooser.getSelectLabel(), context);
        writer.endElement("div");
        this.setEnterKeyPressHandler(context, chooser, (UIComponent)selectedTextField);
        RenderingUtilities.renderComponent((UIComponent)selectedTextField, context);
        writer.endElement("div");
        this.renderClearDiv(context, chooser, writer, theme);
    }

    private void renderJavaScript(FileChooser chooser, FacesContext context, ResponseWriter writer, Theme theme) throws IOException {
        String chooserType = chooser.isFolderChooser() ? "folderChooser" : (chooser.isFileAndFolderChooser() ? "fileAndFolderChooser" : "fileChooser");
        String esc = chooser.getEscapeChar();
        if (esc.equals("\\")) {
            esc = "\\\\";
        }
        String parentDir = chooser.getParentFolder();
        String currentFolder = chooser.getCurrentFolder();
        if (parentDir == null) {
            parentDir = currentFolder;
        }
        Object sep = chooser.getSeparatorString();
        if (parentDir == null) {
            parentDir = "";
        } else if (((String)sep).equals("\\")) {
            sep = (String)sep + (String)sep;
            parentDir = parentDir.replaceAll((String)sep, (String)sep + (String)sep);
        }
        sep = chooser.getSeparatorString();
        if (currentFolder == null) {
            currentFolder = "";
        } else if (((String)sep).equals("\\")) {
            sep = (String)sep + (String)sep;
            currentFolder = currentFolder.replaceAll((String)sep, (String)sep + (String)sep);
        }
        String id = chooser.getClientId(context);
        StringWriter buff = new StringWriter();
        JsonObject initProps = JsonUtilities.JSON_BUILDER_FACTORY.createObjectBuilder().add("id", id).add("chooserType", chooserType).add("parentFolder", parentDir).add("separatorChar", (String)sep).add("escapeChar", esc).add("delimiter", chooser.getDelimiterChar()).add("currentFolder", currentFolder).build();
        JavaScriptUtilities.renderInitScriptTag(writer, "fileChooser", initProps);
    }

    private void createJavaScriptForFileList(FileChooser chooser, FacesContext context, UIComponent fileList) {
        String jsObject = JavaScriptUtilities.getDomNode(context, (UIComponent)chooser);
        StringBuilder dblClickBuffer = new StringBuilder();
        dblClickBuffer.append(jsObject);
        dblClickBuffer.append(".handleDblClick();");
        fileList.getAttributes().put("onDblClick", dblClickBuffer.toString());
        StringBuilder jsBuffer = new StringBuilder();
        jsBuffer.append(jsObject);
        jsBuffer.append(".handleOnChange();");
        fileList.getAttributes().put("onChange", jsBuffer.toString());
    }

    private void setEnterKeyPressHandler(FacesContext context, FileChooser chooser, UIComponent child) {
        StringBuilder scriptBuffer = new StringBuilder();
        scriptBuffer.append("return ");
        scriptBuffer.append(JavaScriptUtilities.getDomNode(context, (UIComponent)chooser));
        scriptBuffer.append(".enterKeyPressed(this);");
        String js = this.getReturnKeyJavascriptWrapper(scriptBuffer.toString());
        scriptBuffer.setLength(0);
        scriptBuffer.append(js);
        child.getAttributes().put("onKeyPress", scriptBuffer.toString());
    }

    private void renderEmptyLine(FacesContext context, FileChooser chooser, ResponseWriter writer, String colSpan, int wd, int ht, Theme theme) throws IOException {
        writer.startElement("tr", (UIComponent)chooser);
        this.renderDotImage(writer, chooser, context, colSpan, wd, ht, theme);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    private void renderClearDiv(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws IOException {
        writer.startElement("div", (UIComponent)chooser);
        writer.writeAttribute("class", (Object)theme.getStyleClass("CLEAR"), null);
        writer.endElement("div");
        writer.writeText((Object)"\n", null);
    }

    private void renderDotImage(ResponseWriter writer, FileChooser chooser, FacesContext context, String colSpan, int wd, int ht, Theme theme) throws IOException {
        writer.startElement("td", (UIComponent)chooser);
        if (colSpan != null) {
            writer.writeAttribute("colspan", (Object)colSpan, null);
        }
        Icon dot = ThemeUtilities.getIcon(theme, "DOT");
        dot.setWidth(wd);
        dot.setHeight(ht);
        dot.setBorder(0);
        dot.setAlt("");
        RenderingUtilities.renderComponent((UIComponent)dot, context);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
    }

    void log(String msg) {
        if (LogUtil.fineEnabled(FileChooserRenderer.class)) {
            LogUtil.fine(FileChooserRenderer.class, msg);
        }
    }

    private String getReturnKeyJavascriptWrapper(String body) {
        ClientSniffer cs = ClientSniffer.getInstance(this.getFacesContext());
        String keyCode = cs.isNav() ? "event.which" : "event.keyCode";
        StringBuffer buff = new StringBuffer().append("if (").append(keyCode).append("==13) {");
        if (cs.isNav6() || cs.isNav70()) {
            buff.append("event.cancelBubble = true;");
        }
        buff.append(body).append("} else { return true; }");
        return buff.toString();
    }
}

