/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.data.provider.FieldKey;
import com.sun.data.provider.SortCriteria;
import com.sun.data.provider.impl.FieldIdSortCriteria;
import com.sun.webui.jsf.component.Icon;
import com.sun.webui.jsf.component.Table;
import com.sun.webui.jsf.component.TableFooter;
import com.sun.webui.jsf.component.TableHeader;
import com.sun.webui.jsf.component.TableRowGroup;
import com.sun.webui.jsf.faces.ValueBindingSortCriteria;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.el.ValueExpression;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIComponentBase;
import jakarta.faces.context.FacesContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class TableColumn
extends UIComponentBase
implements NamingContainer {
    public static final String COLUMN_FOOTER_ID = "_columnFooter";
    public static final String COLUMN_FOOTER_FACET = "columnFooter";
    public static final String COLUMN_HEADER_ID = "_columnHeader";
    public static final String COLUMN_HEADER_FACET = "columnHeader";
    public static final String HEADER_FACET = "header";
    public static final String EMBEDDED_ACTION_SEPARATOR_ICON_ID = "_embeddedActionSeparatorIcon";
    public static final String EMBEDDED_ACTION_SEPARATOR_ICON_FACET = "embeddedActionSeparatorIcon";
    public static final String EMPTY_CELL_ICON_ID = "_emptyCellIcon";
    public static final String EMPTY_CELL_ICON_FACET = "emptyCellIcon";
    public static final String FOOTER_FACET = "footer";
    public static final String TABLE_COLUMN_FOOTER_ID = "_tableColumnFooter";
    public static final String TABLE_COLUMN_FOOTER_FACET = "tableColumnFooter";
    public static final String TABLE_FOOTER_FACET = "tableFooter";
    private Table tableAncestor = null;
    private TableColumn tableColumnAncestor = null;
    private List<TableColumn> tableColumnChildren = null;
    private TableRowGroup tableRowGroupAncestor = null;
    private int columnCount = -1;
    private int rowCount = -1;
    private String abbr = null;
    private String align = null;
    private Object alignKey = null;
    private String axis = null;
    private String bgColor = null;
    private String charFor = null;
    private String charOff = null;
    private int colSpan = Integer.MIN_VALUE;
    private boolean colSpanSet = false;
    private boolean descending = false;
    private boolean descendingSet = false;
    private boolean embeddedActions = false;
    private boolean embeddedActionsSet = false;
    private boolean emptyCell = false;
    private boolean emptyCellSet = false;
    private String extraFooterHtml = null;
    private String extraHeaderHtml = null;
    private String extraTableFooterHtml = null;
    private String footerText = null;
    private String headerText = null;
    private String headers = null;
    private String height = null;
    private boolean noWrap = false;
    private boolean noWrapSet = false;
    private String onClick = null;
    private String onDblClick = null;
    private String onKeyDown = null;
    private String onKeyPress = null;
    private String onKeyUp = null;
    private String onMouseDown = null;
    private String onMouseMove = null;
    private String onMouseOut = null;
    private String onMouseOver = null;
    private String onMouseUp = null;
    private boolean rowHeader = false;
    private boolean rowHeaderSet = false;
    private int rowSpan = Integer.MIN_VALUE;
    private boolean rowSpanSet = false;
    private String scope = null;
    private String selectId = null;
    private String severity = null;
    private Object sort = null;
    private String sortIcon = null;
    private String sortImageURL = null;
    private boolean spacerColumn = false;
    private boolean spacerColumnSet = false;
    private String style = null;
    private String styleClass = null;
    private String tableFooterText = null;
    private String toolTip = null;
    private String valign = null;
    private boolean visible = false;
    private boolean visibleSet = false;
    private String width = null;

    public TableColumn() {
        this.setRendererType("com.sun.webui.jsf.TableColumn");
    }

    public String getFamily() {
        return "com.sun.webui.jsf.TableColumn";
    }

    public void clear() {
        this.tableAncestor = null;
        this.tableColumnAncestor = null;
        this.tableColumnChildren = null;
        this.tableRowGroupAncestor = null;
        this.columnCount = -1;
        this.rowCount = -1;
        Iterator<TableColumn> kids = this.getTableColumnChildren();
        while (kids.hasNext()) {
            TableColumn kid = kids.next();
            kid.clear();
        }
    }

    public Table getTableAncestor() {
        if (this.tableAncestor == null) {
            TableColumn component = this;
            while (component != null) {
                if (!((component = component.getParent()) instanceof Table)) continue;
                this.tableAncestor = (Table)((Object)component);
                break;
            }
        }
        return this.tableAncestor;
    }

    public TableColumn getTableColumnAncestor() {
        if (this.tableColumnAncestor == null) {
            TableColumn component = this;
            while (component != null) {
                if (!((component = component.getParent()) instanceof TableColumn)) continue;
                this.tableColumnAncestor = component;
                break;
            }
        }
        return this.tableColumnAncestor;
    }

    public Iterator<TableColumn> getTableColumnChildren() {
        if (this.tableColumnChildren == null) {
            this.tableColumnChildren = new ArrayList<TableColumn>();
            for (UIComponent kid : this.getChildren()) {
                if (!(kid instanceof TableColumn)) continue;
                this.tableColumnChildren.add((TableColumn)kid);
            }
        }
        return this.tableColumnChildren.iterator();
    }

    public int getColumnCount() {
        if (this.columnCount == -1) {
            this.columnCount = this.getColumnCount(this);
        }
        return this.columnCount;
    }

    public TableRowGroup getTableRowGroupAncestor() {
        if (this.tableRowGroupAncestor == null) {
            TableColumn component = this;
            while (component != null) {
                if (!((component = component.getParent()) instanceof TableRowGroup)) continue;
                this.tableRowGroupAncestor = (TableRowGroup)((Object)component);
                break;
            }
        }
        return this.tableRowGroupAncestor;
    }

    public String getAlign() {
        String result;
        if (this.align != null) {
            return this.align;
        }
        ValueExpression vb = this.getValueExpression("align");
        if (vb != null && (result = (String)vb.getValue(this.getFacesContext().getELContext())) != null) {
            return result;
        }
        Class type = this.getType();
        result = type != null && (Character.class.isAssignableFrom(type) || String.class.isAssignableFrom(type)) ? "left" : (type != null && (Date.class.isAssignableFrom(type) || Number.class.isAssignableFrom(type)) ? "right" : (type != null && Boolean.class.isAssignableFrom(type) ? "center" : "left"));
        return result;
    }

    public UIComponent getColumnFooter() {
        UIComponent facet = this.getFacet(COLUMN_FOOTER_FACET);
        if (facet != null) {
            return facet;
        }
        TableFooter child = new TableFooter();
        child.setId(COLUMN_FOOTER_ID);
        child.setAlign(this.getAlign());
        child.setExtraHtml(this.getExtraFooterHtml());
        child.setVisible(this.isVisible());
        if (!(facet != null && facet.isRendered() || this.isColumnFooterRendered())) {
            child.setRendered(false);
        } else {
            this.log("getColumnFooter", "Column footer not rendered, nothing to display");
        }
        TableRowGroup group = this.getTableRowGroupAncestor();
        if (group != null && group.isMultipleColumnFooters()) {
            Iterator<TableColumn> kids = this.getTableColumnChildren();
            if (kids.hasNext()) {
                int colspan = this.getColumnCount();
                if (colspan > 1) {
                    child.setColSpan(colspan);
                }
            } else {
                int rowspan = this.getRowCount();
                if (rowspan > 1) {
                    child.setRowSpan(rowspan);
                }
            }
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getColumnHeader() {
        Iterator<TableColumn> kids;
        UIComponent facet = this.getFacet(COLUMN_HEADER_FACET);
        if (facet != null) {
            return facet;
        }
        TableHeader child = new TableHeader();
        child.setId(COLUMN_HEADER_ID);
        child.setScope("col");
        child.setAlign(this.getAlign());
        if (this.getSelectId() != null) {
            child.setWidth("3%");
        } else {
            child.setWidth(null);
        }
        if (this.getSelectId() != null) {
            child.setNoWrap(true);
        } else {
            child.setNoWrap(false);
        }
        child.setExtraHtml(this.getExtraHeaderHtml());
        child.setVisible(this.isVisible());
        boolean emptyTable = this.isEmptyTable();
        SortCriteria criteria = this.getSortCriteria();
        if (criteria != null && this.getSelectId() != null && !emptyTable) {
            child.setSelectHeader(true);
        } else if (criteria != null && this.getHeaderText() != null && !emptyTable) {
            child.setSortHeader(true);
        } else {
            this.log("getColumnHeader", "Render default column header, no SortCriteria or selectId");
        }
        if (!(facet != null && facet.isRendered() || this.isColumnHeaderRendered())) {
            this.log("getColumnHeader", "Column header not rendered, nothing to display");
            child.setRendered(false);
        }
        if ((kids = this.getTableColumnChildren()).hasNext()) {
            int colspan = this.getColumnCount();
            if (colspan > 1) {
                child.setColSpan(colspan);
            }
        } else {
            int rowspan = this.getRowCount();
            if (rowspan > 1) {
                child.setRowSpan(rowspan);
            }
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getTableColumnFooter() {
        UIComponent facet = this.getFacet(TABLE_COLUMN_FOOTER_FACET);
        if (facet != null) {
            return facet;
        }
        TableFooter child = new TableFooter();
        child.setId(TABLE_COLUMN_FOOTER_ID);
        child.setAlign(this.getAlign());
        child.setExtraHtml(this.getExtraTableFooterHtml());
        child.setTableColumnFooter(true);
        child.setVisible(this.isVisible());
        if (!(facet != null && facet.isRendered() || this.isTableColumnFooterRendered())) {
            child.setRendered(false);
        } else {
            this.log("getTableColumnFooter", "Table column footer not rendered, nothing to display");
        }
        TableRowGroup group = this.getTableRowGroupAncestor();
        if (group != null && group.isMultipleTableColumnFooters()) {
            Iterator<TableColumn> kids = this.getTableColumnChildren();
            if (kids.hasNext()) {
                int colspan = this.getColumnCount();
                if (colspan > 1) {
                    child.setColSpan(colspan);
                }
            } else {
                int rowspan = this.getRowCount();
                if (rowspan > 1) {
                    child.setRowSpan(rowspan);
                }
            }
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getEmptyCellIcon() {
        UIComponent facet = this.getFacet(EMPTY_CELL_ICON_FACET);
        if (facet != null) {
            return facet;
        }
        Theme theme = this.getTheme();
        Icon child = ThemeUtilities.getIcon(theme, "TABLE_EMPTY_CELL");
        child.setId(EMPTY_CELL_ICON_ID);
        child.setBorder(0);
        String zToolTip = theme.getMessage("table.emptyTableCell");
        child.setToolTip(zToolTip);
        child.setAlt(zToolTip);
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getEmbeddedActionSeparatorIcon() {
        UIComponent facet = this.getFacet(EMBEDDED_ACTION_SEPARATOR_ICON_FACET);
        if (facet != null) {
            return facet;
        }
        Icon child = ThemeUtilities.getIcon(this.getTheme(), "TABLE_EMBEDDED_ACTIONS_SEPARATOR");
        child.setId(EMBEDDED_ACTION_SEPARATOR_ICON_ID);
        child.setBorder(0);
        child.setAlign("top");
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public SortCriteria getSortCriteria() {
        Object key = this.getSort();
        if (key instanceof SortCriteria) {
            return (SortCriteria)key;
        }
        Object result = null;
        ValueExpression vb = this.getValueExpression("sort");
        if (vb != null) {
            ValueBindingSortCriteria vbsc = new ValueBindingSortCriteria(vb, !this.isDescending());
            TableRowGroup group = this.getTableRowGroupAncestor();
            if (group != null) {
                vbsc.setRequestMapKey(group.getSourceVar());
            }
            result = vbsc;
        } else if (key != null) {
            result = new FieldIdSortCriteria(key.toString(), !this.isDescending());
        }
        return result;
    }

    public String getSortToolTipAugment(boolean desc) {
        Class type = this.getType();
        ValueExpression vb = this.getValueExpression("severity");
        String result = this.getSeverity() != null || vb != null ? (desc ? "table.sort.augment.alarmDescending" : "table.sort.augment.alarmAscending") : (this.getSelectId() != null || type != null && type.equals(Boolean.class) ? (desc ? "table.sort.augment.booleanDescending" : "table.sort.augment.booleanAscending") : (type != null && type.equals(String.class) ? (desc ? "table.sort.augment.stringDescending" : "table.sort.augment.stringAscending") : (type != null && type.equals(Character.class) ? (desc ? "table.sort.augment.charDescending" : "table.sort.augment.charAscending") : (type != null && type.equals(Date.class) ? (desc ? "table.sort.augment.dateDescending" : "table.sort.augment.dateAscending") : (type != null && type.equals(Number.class) ? (desc ? "table.sort.augment.numericDescending" : "table.sort.augment.numericAscending") : (desc ? "table.sort.augment.undeterminedDescending" : "table.sort.augment.undeterminedAscending"))))));
        return this.getTheme().getMessage(result);
    }

    public void setId(String id) {
        super.setId(id);
    }

    public void setRendered(boolean rendered) {
        super.setRendered(rendered);
    }

    public String getAbbr() {
        if (this.abbr != null) {
            return this.abbr;
        }
        ValueExpression vb = this.getValueExpression("abbr");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setAbbr(String newAbbr) {
        this.abbr = newAbbr;
    }

    public void setAlign(String newAlign) {
        this.align = newAlign;
    }

    public Object getAlignKey() {
        if (this.alignKey != null) {
            return this.alignKey;
        }
        ValueExpression vb = this.getValueExpression("alignKey");
        if (vb != null) {
            return vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setAlignKey(Object newAlignKey) {
        this.alignKey = newAlignKey;
    }

    public String getAxis() {
        if (this.axis != null) {
            return this.axis;
        }
        ValueExpression vb = this.getValueExpression("axis");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setAxis(String newAxis) {
        this.axis = newAxis;
    }

    public String getBgColor() {
        if (this.bgColor != null) {
            return this.bgColor;
        }
        ValueExpression vb = this.getValueExpression("bgColor");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setBgColor(String newBgColor) {
        this.bgColor = newBgColor;
    }

    public String getChar() {
        if (this.charFor != null) {
            return this.charFor;
        }
        ValueExpression vb = this.getValueExpression("char");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setChar(String newCharFor) {
        this.charFor = newCharFor;
    }

    public String getCharOff() {
        if (this.charOff != null) {
            return this.charOff;
        }
        ValueExpression vb = this.getValueExpression("charOff");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setCharOff(String newCharOff) {
        this.charOff = newCharOff;
    }

    public int getColSpan() {
        if (this.colSpanSet) {
            return this.colSpan;
        }
        ValueExpression vb = this.getValueExpression("colSpan");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)result;
        }
        return Integer.MIN_VALUE;
    }

    public void setColSpan(int newColSpan) {
        this.colSpan = newColSpan;
        this.colSpanSet = true;
    }

    public boolean isDescending() {
        if (this.descendingSet) {
            return this.descending;
        }
        ValueExpression vb = this.getValueExpression("descending");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setDescending(boolean newDescending) {
        this.descending = newDescending;
        this.descendingSet = true;
    }

    public boolean isEmbeddedActions() {
        if (this.embeddedActionsSet) {
            return this.embeddedActions;
        }
        ValueExpression vb = this.getValueExpression("embeddedActions");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setEmbeddedActions(boolean newEmbeddedActions) {
        this.embeddedActions = newEmbeddedActions;
        this.embeddedActionsSet = true;
    }

    public boolean isEmptyCell() {
        if (this.emptyCellSet) {
            return this.emptyCell;
        }
        ValueExpression vb = this.getValueExpression("emptyCell");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setEmptyCell(boolean newEmptyCell) {
        this.emptyCell = newEmptyCell;
        this.emptyCellSet = true;
    }

    public String getExtraFooterHtml() {
        if (this.extraFooterHtml != null) {
            return this.extraFooterHtml;
        }
        ValueExpression vb = this.getValueExpression("extraFooterHtml");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setExtraFooterHtml(String newExtraFooterHtml) {
        this.extraFooterHtml = newExtraFooterHtml;
    }

    public String getExtraHeaderHtml() {
        if (this.extraHeaderHtml != null) {
            return this.extraHeaderHtml;
        }
        ValueExpression vb = this.getValueExpression("extraHeaderHtml");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setExtraHeaderHtml(String newExtraHeaderHtml) {
        this.extraHeaderHtml = newExtraHeaderHtml;
    }

    public String getExtraTableFooterHtml() {
        if (this.extraTableFooterHtml != null) {
            return this.extraTableFooterHtml;
        }
        ValueExpression vb = this.getValueExpression("extraTableFooterHtml");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setExtraTableFooterHtml(String newExtraTableFooterHtml) {
        this.extraTableFooterHtml = newExtraTableFooterHtml;
    }

    public String getFooterText() {
        if (this.footerText != null) {
            return this.footerText;
        }
        ValueExpression vb = this.getValueExpression("footerText");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setFooterText(String newFooterText) {
        this.footerText = newFooterText;
    }

    public String getHeaderText() {
        if (this.headerText != null) {
            return this.headerText;
        }
        ValueExpression vb = this.getValueExpression("headerText");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setHeaderText(String newHeaderText) {
        this.headerText = newHeaderText;
    }

    public String getHeaders() {
        if (this.headers != null) {
            return this.headers;
        }
        ValueExpression vb = this.getValueExpression("headers");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setHeaders(String newHeaders) {
        this.headers = newHeaders;
    }

    public String getHeight() {
        if (this.height != null) {
            return this.height;
        }
        ValueExpression vb = this.getValueExpression("height");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setHeight(String newHeight) {
        this.height = newHeight;
    }

    public boolean isNoWrap() {
        if (this.noWrapSet) {
            return this.noWrap;
        }
        ValueExpression vb = this.getValueExpression("noWrap");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setNoWrap(boolean newNoWrap) {
        this.noWrap = newNoWrap;
        this.noWrapSet = true;
    }

    public String getOnClick() {
        if (this.onClick != null) {
            return this.onClick;
        }
        ValueExpression vb = this.getValueExpression("onClick");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnClick(String newOnClick) {
        this.onClick = newOnClick;
    }

    public String getOnDblClick() {
        if (this.onDblClick != null) {
            return this.onDblClick;
        }
        ValueExpression vb = this.getValueExpression("onDblClick");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnDblClick(String newOnDblClick) {
        this.onDblClick = newOnDblClick;
    }

    public String getOnKeyDown() {
        if (this.onKeyDown != null) {
            return this.onKeyDown;
        }
        ValueExpression vb = this.getValueExpression("onKeyDown");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnKeyDown(String newOnKeyDown) {
        this.onKeyDown = newOnKeyDown;
    }

    public String getOnKeyPress() {
        if (this.onKeyPress != null) {
            return this.onKeyPress;
        }
        ValueExpression vb = this.getValueExpression("onKeyPress");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnKeyPress(String newOnKeyPress) {
        this.onKeyPress = newOnKeyPress;
    }

    public String getOnKeyUp() {
        if (this.onKeyUp != null) {
            return this.onKeyUp;
        }
        ValueExpression vb = this.getValueExpression("onKeyUp");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnKeyUp(String newOnKeyUp) {
        this.onKeyUp = newOnKeyUp;
    }

    public String getOnMouseDown() {
        if (this.onMouseDown != null) {
            return this.onMouseDown;
        }
        ValueExpression vb = this.getValueExpression("onMouseDown");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseDown(String newOnMouseDown) {
        this.onMouseDown = newOnMouseDown;
    }

    public String getOnMouseMove() {
        if (this.onMouseMove != null) {
            return this.onMouseMove;
        }
        ValueExpression vb = this.getValueExpression("onMouseMove");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseMove(String newOnMouseMove) {
        this.onMouseMove = newOnMouseMove;
    }

    public String getOnMouseOut() {
        if (this.onMouseOut != null) {
            return this.onMouseOut;
        }
        ValueExpression vb = this.getValueExpression("onMouseOut");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseOut(String newOnMouseOut) {
        this.onMouseOut = newOnMouseOut;
    }

    public String getOnMouseOver() {
        if (this.onMouseOver != null) {
            return this.onMouseOver;
        }
        ValueExpression vb = this.getValueExpression("onMouseOver");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseOver(String newOnMouseOver) {
        this.onMouseOver = newOnMouseOver;
    }

    public String getOnMouseUp() {
        if (this.onMouseUp != null) {
            return this.onMouseUp;
        }
        ValueExpression vb = this.getValueExpression("onMouseUp");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseUp(String newOnMouseUp) {
        this.onMouseUp = newOnMouseUp;
    }

    public boolean isRowHeader() {
        if (this.rowHeaderSet) {
            return this.rowHeader;
        }
        ValueExpression vb = this.getValueExpression("rowHeader");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setRowHeader(boolean newRowHeader) {
        this.rowHeader = newRowHeader;
        this.rowHeaderSet = true;
    }

    public int getRowSpan() {
        if (this.rowSpanSet) {
            return this.rowSpan;
        }
        ValueExpression vb = this.getValueExpression("rowSpan");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)result;
        }
        return Integer.MIN_VALUE;
    }

    public void setRowSpan(int newRowSpan) {
        this.rowSpan = newRowSpan;
        this.rowSpanSet = true;
    }

    public String getScope() {
        if (this.scope != null) {
            return this.scope;
        }
        ValueExpression vb = this.getValueExpression("scope");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setScope(String newScope) {
        this.scope = newScope;
    }

    public String getSelectId() {
        if (this.selectId != null) {
            return this.selectId;
        }
        ValueExpression vb = this.getValueExpression("selectId");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setSelectId(String newSelectId) {
        this.selectId = newSelectId;
    }

    public String getSeverity() {
        if (this.severity != null) {
            return this.severity;
        }
        ValueExpression vb = this.getValueExpression("severity");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setSeverity(String newSeverity) {
        this.severity = newSeverity;
    }

    public Object getSort() {
        if (this.sort != null) {
            return this.sort;
        }
        ValueExpression vb = this.getValueExpression("sort");
        if (vb != null) {
            return vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setSort(Object newSort) {
        this.sort = newSort;
    }

    public String getSortIcon() {
        if (this.sortIcon != null) {
            return this.sortIcon;
        }
        ValueExpression vb = this.getValueExpression("sortIcon");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setSortIcon(String newSortIcon) {
        this.sortIcon = newSortIcon;
    }

    public String getSortImageURL() {
        if (this.sortImageURL != null) {
            return this.sortImageURL;
        }
        ValueExpression vb = this.getValueExpression("sortImageURL");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setSortImageURL(String newSortImageURL) {
        this.sortImageURL = newSortImageURL;
    }

    public boolean isSpacerColumn() {
        if (this.spacerColumnSet) {
            return this.spacerColumn;
        }
        ValueExpression vb = this.getValueExpression("spacerColumn");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setSpacerColumn(boolean newSpacerColumn) {
        this.spacerColumn = newSpacerColumn;
        this.spacerColumnSet = true;
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueExpression vb = this.getValueExpression("style");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyle(String newStyle) {
        this.style = newStyle;
    }

    public String getStyleClass() {
        if (this.styleClass != null) {
            return this.styleClass;
        }
        ValueExpression vb = this.getValueExpression("styleClass");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyleClass(String newStyleClass) {
        this.styleClass = newStyleClass;
    }

    public String getTableFooterText() {
        if (this.tableFooterText != null) {
            return this.tableFooterText;
        }
        ValueExpression vb = this.getValueExpression("tableFooterText");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setTableFooterText(String newTableFooterText) {
        this.tableFooterText = newTableFooterText;
    }

    public String getToolTip() {
        if (this.toolTip != null) {
            return this.toolTip;
        }
        ValueExpression vb = this.getValueExpression("toolTip");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setToolTip(String newToolTip) {
        this.toolTip = newToolTip;
    }

    public String getValign() {
        if (this.valign != null) {
            return this.valign;
        }
        ValueExpression vb = this.getValueExpression("valign");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setValign(String newValign) {
        this.valign = newValign;
    }

    public boolean isVisible() {
        if (this.visibleSet) {
            return this.visible;
        }
        ValueExpression vb = this.getValueExpression("visible");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    public void setVisible(boolean newVisible) {
        this.visible = newVisible;
        this.visibleSet = true;
    }

    public String getWidth() {
        if (this.width != null) {
            return this.width;
        }
        ValueExpression vb = this.getValueExpression("width");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setWidth(String newWidth) {
        this.width = newWidth;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.abbr = (String)values[1];
        this.align = (String)values[2];
        this.alignKey = values[3];
        this.axis = (String)values[4];
        this.bgColor = (String)values[5];
        this.charFor = (String)values[6];
        this.charOff = (String)values[7];
        this.colSpan = (Integer)values[8];
        this.colSpanSet = (Boolean)values[9];
        this.descending = (Boolean)values[10];
        this.descendingSet = (Boolean)values[11];
        this.embeddedActions = (Boolean)values[12];
        this.embeddedActionsSet = (Boolean)values[13];
        this.emptyCell = (Boolean)values[14];
        this.emptyCellSet = (Boolean)values[15];
        this.extraFooterHtml = (String)values[16];
        this.extraHeaderHtml = (String)values[17];
        this.extraTableFooterHtml = (String)values[18];
        this.footerText = (String)values[19];
        this.headerText = (String)values[20];
        this.headers = (String)values[21];
        this.height = (String)values[22];
        this.noWrap = (Boolean)values[23];
        this.noWrapSet = (Boolean)values[24];
        this.onClick = (String)values[25];
        this.onDblClick = (String)values[26];
        this.onKeyDown = (String)values[27];
        this.onKeyPress = (String)values[28];
        this.onKeyUp = (String)values[29];
        this.onMouseDown = (String)values[30];
        this.onMouseMove = (String)values[31];
        this.onMouseOut = (String)values[32];
        this.onMouseOver = (String)values[33];
        this.onMouseUp = (String)values[34];
        this.rowHeader = (Boolean)values[35];
        this.rowHeaderSet = (Boolean)values[36];
        this.rowSpan = (Integer)values[37];
        this.rowSpanSet = (Boolean)values[38];
        this.scope = (String)values[39];
        this.selectId = (String)values[40];
        this.severity = (String)values[41];
        this.sort = values[42];
        this.sortIcon = (String)values[43];
        this.sortImageURL = (String)values[44];
        this.spacerColumn = (Boolean)values[45];
        this.spacerColumnSet = (Boolean)values[46];
        this.style = (String)values[47];
        this.styleClass = (String)values[48];
        this.tableFooterText = (String)values[49];
        this.toolTip = (String)values[50];
        this.valign = (String)values[51];
        this.visible = (Boolean)values[52];
        this.visibleSet = (Boolean)values[53];
        this.width = (String)values[54];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.abbr, this.align, this.alignKey, this.axis, this.bgColor, this.charFor, this.charOff, this.colSpan, this.colSpanSet ? Boolean.TRUE : Boolean.FALSE, this.descending ? Boolean.TRUE : Boolean.FALSE, this.descendingSet ? Boolean.TRUE : Boolean.FALSE, this.embeddedActions ? Boolean.TRUE : Boolean.FALSE, this.embeddedActionsSet ? Boolean.TRUE : Boolean.FALSE, this.emptyCell ? Boolean.TRUE : Boolean.FALSE, this.emptyCellSet ? Boolean.TRUE : Boolean.FALSE, this.extraFooterHtml, this.extraHeaderHtml, this.extraTableFooterHtml, this.footerText, this.headerText, this.headers, this.height, this.noWrap ? Boolean.TRUE : Boolean.FALSE, this.noWrapSet ? Boolean.TRUE : Boolean.FALSE, this.onClick, this.onDblClick, this.onKeyDown, this.onKeyPress, this.onKeyUp, this.onMouseDown, this.onMouseMove, this.onMouseOut, this.onMouseOver, this.onMouseUp, this.rowHeader ? Boolean.TRUE : Boolean.FALSE, this.rowHeaderSet ? Boolean.TRUE : Boolean.FALSE, this.rowSpan, this.rowSpanSet ? Boolean.TRUE : Boolean.FALSE, this.scope, this.selectId, this.severity, this.sort, this.sortIcon, this.sortImageURL, this.spacerColumn ? Boolean.TRUE : Boolean.FALSE, this.spacerColumnSet ? Boolean.TRUE : Boolean.FALSE, this.style, this.styleClass, this.tableFooterText, this.toolTip, this.valign, this.visible ? Boolean.TRUE : Boolean.FALSE, this.visibleSet ? Boolean.TRUE : Boolean.FALSE, this.width};
        return values;
    }

    private int getColumnCount(TableColumn component) {
        int count = 0;
        if (component == null) {
            this.log("getColumnCount", "Cannot obtain column count, TableColumn is null");
            return count;
        }
        Iterator<TableColumn> kids = component.getTableColumnChildren();
        if (kids.hasNext()) {
            while (kids.hasNext()) {
                TableColumn col = kids.next();
                if (!col.isRendered()) continue;
                count += this.getColumnCount(col);
            }
        } else if (component.isRendered()) {
            ++count;
        }
        return count;
    }

    private int getRowCount() {
        if (this.rowCount == -1) {
            TableRowGroup group;
            this.rowCount = 0;
            TableColumn col = this.getTableColumnAncestor();
            Iterator<TableColumn> kids = col != null ? col.getTableColumnChildren() : ((group = this.getTableRowGroupAncestor()) != null ? group.getTableColumnChildren() : null);
            if (kids != null) {
                while (kids.hasNext()) {
                    int result = this.getRowCount(kids.next());
                    if (this.rowCount >= result) continue;
                    this.rowCount = result;
                }
            }
        }
        return this.rowCount;
    }

    private int getRowCount(TableColumn component) {
        int count = 0;
        if (component == null) {
            this.log("getRowCount", "Cannot obtain row count, TableColumn is null");
            return count;
        }
        Iterator<TableColumn> kids = component.getTableColumnChildren();
        if (kids.hasNext()) {
            while (kids.hasNext()) {
                int result;
                TableColumn col = kids.next();
                if (!col.isRendered() || count >= (result = this.getRowCount(col))) continue;
                count = result;
            }
        }
        return ++count;
    }

    private Class getType() {
        TableRowGroup group = this.getTableRowGroupAncestor();
        if (group == null) {
            this.log("getType", "Cannot obtain data type, TableRowGroup is null");
            return null;
        }
        FieldKey key = null;
        if (this.getAlignKey() instanceof FieldKey) {
            key = (FieldKey)this.getAlignKey();
        } else if (this.getAlignKey() != null) {
            try {
                key = group.getFieldKey(this.getAlignKey().toString());
            }
            catch (IllegalArgumentException e) {
                this.log("getType", "Cannot obtain data type, object type may not be set");
            }
        }
        if (key != null) {
            group.getType(key);
        }
        return String.class;
    }

    private Theme getTheme() {
        return ThemeUtilities.getTheme(this.getFacesContext());
    }

    private boolean isColumnFooterRendered() {
        boolean result = false;
        TableRowGroup group = this.getTableRowGroupAncestor();
        if (group == null) {
            this.log("isColumnFooterRendered", "Cannot determine if column footer is rendered, TableRowGroup is null");
            return result;
        }
        Iterator<TableColumn> kids = group.getTableColumnChildren();
        while (kids.hasNext()) {
            TableColumn col = kids.next();
            if (!this.isColumnFooterRendered(col)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isColumnFooterRendered(TableColumn component) {
        UIComponent facet;
        boolean rendered = false;
        if (component == null) {
            this.log("isColumnFooterRendered", "Cannot determine if column footer is rendered, TableColumn is null");
            return rendered;
        }
        Iterator<TableColumn> kids = component.getTableColumnChildren();
        if (kids.hasNext()) {
            while (kids.hasNext()) {
                TableColumn col = kids.next();
                if (!this.isColumnFooterRendered(col)) continue;
                return true;
            }
        }
        if ((facet = component.getFacet(COLUMN_FOOTER_FACET)) != null && facet.isRendered() || component.getFooterText() != null) {
            rendered = true;
        }
        return rendered;
    }

    private boolean isColumnHeaderRendered() {
        boolean result = false;
        TableRowGroup group = this.getTableRowGroupAncestor();
        if (group == null) {
            this.log("isColumnHeaderRendered", "Cannot determine if column header is rendered, TableRowGroup is null");
            return result;
        }
        Iterator<TableColumn> kids = group.getTableColumnChildren();
        while (kids.hasNext()) {
            TableColumn col = kids.next();
            if (!this.isColumnHeaderRendered(col)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isColumnHeaderRendered(TableColumn component) {
        UIComponent facet;
        boolean rendered = false;
        if (component == null) {
            this.log("isColumnHeaderRendered", "Cannot determine if column header is rendered, TableColumn is null");
            return rendered;
        }
        Iterator<TableColumn> kids = component.getTableColumnChildren();
        if (kids.hasNext()) {
            while (kids.hasNext()) {
                TableColumn col = kids.next();
                if (!this.isColumnHeaderRendered(col)) continue;
                return true;
            }
        }
        if ((facet = component.getFacet(COLUMN_HEADER_FACET)) != null && facet.isRendered() || component.getHeaderText() != null) {
            rendered = true;
        }
        return rendered;
    }

    private boolean isEmptyTable() {
        boolean result = false;
        Table table = this.getTableAncestor();
        TableRowGroup group = this.getTableRowGroupAncestor();
        if (table != null && group != null) {
            int rows = table.getRowCount();
            int tableHeaders = table.getColumnHeadersCount();
            result = tableHeaders > 1 ? group.getRowCount() <= 1 : rows == 0 || rows == 1;
        }
        return result;
    }

    private boolean isTableColumnFooterRendered() {
        boolean result = false;
        TableRowGroup group = this.getTableRowGroupAncestor();
        if (group == null) {
            this.log("isTableColumnFooterRendered", "Cannot determine if table column footer is rendered, TableRowGroup is null");
            return result;
        }
        Iterator<TableColumn> kids = group.getTableColumnChildren();
        while (kids.hasNext()) {
            TableColumn col = kids.next();
            if (!this.isTableColumnFooterRendered(col)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isTableColumnFooterRendered(TableColumn component) {
        UIComponent facet;
        boolean rendered = false;
        if (component == null) {
            this.log("isTableColumnFooterRendered", "Cannot determine if table column footer is rendered, TableColumn is null");
            return rendered;
        }
        Iterator<TableColumn> kids = component.getTableColumnChildren();
        if (kids.hasNext()) {
            while (kids.hasNext()) {
                TableColumn col = kids.next();
                if (!this.isTableColumnFooterRendered(col)) continue;
                return true;
            }
        }
        if ((facet = component.getFacet(TABLE_FOOTER_FACET)) != null && facet.isRendered() || component.getTableFooterText() != null) {
            rendered = true;
        }
        return rendered;
    }

    private void log(String method, String msg) {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        if (LogUtil.fineEnabled(clazz)) {
            LogUtil.fine(clazz, clazz.getName() + "." + method + ": " + msg);
        }
    }
}

