/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.java;

import java.io.File;
import org.glassfish.rmic.tools.java.ClassFile;
import org.glassfish.rmic.tools.java.ClassPath;
import org.glassfish.rmic.tools.java.Identifier;
import org.glassfish.rmic.tools.java.Type;

public class Package {
    private final ClassPath sourcePath = new ClassPath("");
    private ClassPath binaryPath;
    private String pkg;

    public Package(ClassPath binaryPath, Identifier pkg) {
        if (pkg.isInner()) {
            pkg = Identifier.lookup(pkg.getQualifier(), pkg.getFlatName());
        }
        this.binaryPath = binaryPath;
        this.pkg = pkg.toString().replace('.', File.separatorChar);
    }

    public boolean classExists(Identifier className) {
        return this.getBinaryFile(className) != null || !className.isInner() && this.getSourceFile(className) != null;
    }

    public boolean exists() {
        ClassFile dir = this.binaryPath.getDirectory(this.pkg);
        if (dir != null && dir.isDirectory()) {
            return true;
        }
        String prefix = this.pkg + File.separator;
        return this.binaryPath.getFiles(prefix, ".class").hasMoreElements();
    }

    private String makeName(String fileName) {
        return this.pkg.equals("") ? fileName : this.pkg + File.separator + fileName;
    }

    public ClassFile getBinaryFile(Identifier className) {
        className = Type.mangleInnerType(className);
        String fileName = className.toString() + ".class";
        return this.binaryPath.getFile(this.makeName(fileName));
    }

    public ClassFile getSourceFile(Identifier className) {
        className = className.getTopName();
        String fileName = className.toString() + ".java";
        return this.sourcePath.getFile(this.makeName(fileName));
    }

    public ClassFile getSourceFile(String fileName) {
        if (fileName.endsWith(".java")) {
            return this.sourcePath.getFile(this.makeName(fileName));
        }
        return null;
    }

    public String toString() {
        if (this.pkg.equals("")) {
            return "unnamed package";
        }
        return "package " + this.pkg;
    }
}

