/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.binaryclass;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.glassfish.rmic.tools.binaryclass.BinaryConstantPool;
import org.glassfish.rmic.tools.java.Constants;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.Identifier;

public final class BinaryAttribute
implements Constants {
    Identifier name;
    byte[] data;
    BinaryAttribute next;

    BinaryAttribute(Identifier name, byte[] data, BinaryAttribute next) {
        this.name = name;
        this.data = data;
        this.next = next;
    }

    public static BinaryAttribute load(DataInputStream in, BinaryConstantPool cpool, int mask) throws IOException {
        BinaryAttribute atts = null;
        int natt = in.readUnsignedShort();
        for (int i = 0; i < natt; ++i) {
            Identifier id = cpool.getIdentifier(in.readUnsignedShort());
            int len = in.readInt();
            if (id.equals(idCode) && (mask & 2) == 0) {
                in.skipBytes(len);
                continue;
            }
            byte[] data = new byte[len];
            in.readFully(data);
            atts = new BinaryAttribute(id, data, atts);
        }
        return atts;
    }

    static void write(BinaryAttribute attributes, DataOutputStream out, BinaryConstantPool cpool, Environment env) throws IOException {
        int attributeCount = 0;
        BinaryAttribute att = attributes;
        while (att != null) {
            ++attributeCount;
            att = att.next;
        }
        out.writeShort(attributeCount);
        att = attributes;
        while (att != null) {
            Identifier name = att.name;
            byte[] data = att.data;
            out.writeShort(cpool.indexString(name.toString(), env));
            out.writeInt(data.length);
            out.write(data, 0, data.length);
            att = att.next;
        }
    }

    public Identifier getName() {
        return this.name;
    }

    public byte[] getData() {
        return this.data;
    }

    public BinaryAttribute getNextAttribute() {
        return this.next;
    }
}

