/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util.copier;

import com.sun.faces.util.ReflectionUtils;
import com.sun.faces.util.copier.Copier;
import com.sun.faces.util.copier.MultiStrategyCopier;
import jakarta.faces.context.FacesContext;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class CopierUtils {
    private static final String ERROR_COPIER_NAME = "The copier name should be a Java valid simple/qualified name.";
    private static final String COPIER_PREFIX = "com.sun.faces.util.copier.";
    private static final Set<String> keywords;

    public static Copier getCopier(FacesContext context, String copierType) {
        Copier copier = null;
        if (!CopierUtils.isEmpty(copierType)) {
            if (CopierUtils.isCopierTypeSimpleName(copierType)) {
                copierType = COPIER_PREFIX.concat(copierType);
            } else if (!CopierUtils.isName(copierType)) {
                throw new IllegalArgumentException(ERROR_COPIER_NAME);
            }
            Object expressionResult = CopierUtils.evaluateExpressionGet(context, copierType);
            if (expressionResult instanceof Copier) {
                copier = (Copier)expressionResult;
            } else if (expressionResult instanceof String) {
                copier = (Copier)ReflectionUtils.instance((String)expressionResult);
            }
        }
        if (copier == null) {
            copier = new MultiStrategyCopier();
        }
        return copier;
    }

    private static <T> T evaluateExpressionGet(FacesContext context, String expression) {
        if (expression == null) {
            return null;
        }
        return (T)context.getApplication().evaluateExpressionGet(context, expression, Object.class);
    }

    private static boolean isCopierTypeSimpleName(String copierType) {
        return CopierUtils.isIdentifier(copierType) && !CopierUtils.isKeyword(copierType);
    }

    private static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    private static boolean isName(CharSequence name) {
        String id = name.toString();
        for (String s : id.split("\\.", -1)) {
            if (CopierUtils.isIdentifier(s) && !CopierUtils.isKeyword(s)) continue;
            return false;
        }
        return true;
    }

    private static boolean isIdentifier(CharSequence name) {
        String id = name.toString();
        if (id.length() == 0) {
            return false;
        }
        int cp = id.codePointAt(0);
        if (!Character.isJavaIdentifierStart(cp)) {
            return false;
        }
        for (int i = Character.charCount(cp); i < id.length(); i += Character.charCount(cp)) {
            cp = id.codePointAt(i);
            if (Character.isJavaIdentifierPart(cp)) continue;
            return false;
        }
        return true;
    }

    private static boolean isKeyword(CharSequence s) {
        String keywordOrLiteral = s.toString();
        return keywords.contains(keywordOrLiteral);
    }

    static {
        String[] kws;
        HashSet<String> s = new HashSet<String>();
        for (String kw : kws = new String[]{"abstract", "continue", "for", "new", "switch", "assert", "default", "if", "package", "synchronized", "boolean", "do", "goto", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while", "null", "true", "false"}) {
            s.add(kw);
        }
        keywords = Collections.unmodifiableSet(s);
    }
}

