/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.shared.common.util.ArrayUtil;

public class FormatableArrayHolder
implements Formatable {
    private Object[] array;

    public FormatableArrayHolder() {
    }

    public FormatableArrayHolder(Object[] objectArray) {
        this.setArray(objectArray);
    }

    public void setArray(Object[] objectArray) {
        this.array = ArrayUtil.copy(objectArray);
    }

    public <E> E[] getArray(Class<E[]> clazz) {
        return Arrays.copyOf(this.array, this.array.length, clazz);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        ArrayUtil.writeArrayLength(objectOutput, this.array);
        ArrayUtil.writeArrayItems(objectOutput, this.array);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.array = new Object[ArrayUtil.readArrayLength(objectInput)];
        ArrayUtil.readArrayItems(objectInput, this.array);
    }

    @Override
    public int getTypeFormatId() {
        return 270;
    }
}

