/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.domain;

import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.MasterPasswordFileManager;
import com.sun.enterprise.admin.servermgmt.RepositoryException;
import com.sun.enterprise.security.store.PasswordAdapter;
import java.io.File;
import java.io.IOException;
import org.glassfish.security.common.FileRealmHelper;

public class DomainSecurity
extends MasterPasswordFileManager {
    void processAdminKeyFile(File keyFile, String user, String password, String[] adminUserGroups) throws IOException {
        FileRealmHelper fileRealm = new FileRealmHelper(keyFile.getAbsoluteFile());
        String[] group = adminUserGroups;
        fileRealm.addUser(user, password.toCharArray(), group);
        fileRealm.persist();
    }

    void createPasswordAliasKeystore(File pwFile, String password) throws RepositoryException {
        try {
            PasswordAdapter p = new PasswordAdapter(pwFile.getAbsolutePath(), password.toCharArray());
            p.writeStore();
        }
        catch (Exception ex) {
            throw new RepositoryException("Could not create password alias keystore " + String.valueOf(pwFile), ex);
        }
    }

    void createSSLCertificateDatabase(File configDir, DomainConfig config, String masterPassword) throws RepositoryException {
        this.createKeyStore(new File(configDir, "keystore.p12"), config, masterPassword);
        this.changeKeystorePassword("changeit", masterPassword, new File(configDir, "cacerts.p12"));
        this.copyCertificatesToTrustStore(configDir, masterPassword);
    }

    void changeMode(String args, File file) throws IOException {
        super.chmod(args, file);
    }
}

