/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.mgmt.transport.grizzly.grizzly2;

import com.sun.enterprise.mgmt.transport.Message;
import com.sun.enterprise.mgmt.transport.MessageImpl;
import com.sun.enterprise.mgmt.transport.grizzly.grizzly2.GMSBufferWrapper;
import com.sun.enterprise.mgmt.transport.grizzly.grizzly2.Grizzly2ExpandableBufferWriter;
import java.io.IOException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.memory.MemoryManager;

public class MessageFilter
extends BaseFilter {
    private final Attribute<MessageParsingState> preparsedMessageAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(MessageFilter.class + ".preparsedMessageAttr", MessageParsingState::new);

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        Buffer buffer = (Buffer)ctx.getMessage();
        MessageParsingState parsingState = (MessageParsingState)this.preparsedMessageAttr.get((AttributeStorage)connection);
        if (!parsingState.isHeaderParsed) {
            if (buffer.remaining() < 16) {
                return ctx.getStopAction((Object)buffer);
            }
            MessageImpl message = new MessageImpl();
            GMSBufferWrapper gmsBuffer = parsingState.gmsBufferWrapper.wrap(buffer);
            int messageLength = message.parseHeader(gmsBuffer, gmsBuffer.position());
            gmsBuffer.recycle();
            if (messageLength + 16 > MessageImpl.getMaxMessageLength()) {
                throw new IllegalStateException("too large message. request-size=" + (messageLength + 16) + " max-size=" + MessageImpl.getMaxMessageLength());
            }
            parsingState.isHeaderParsed = true;
            parsingState.message = message;
            parsingState.messageLength = messageLength;
        }
        int totalMsgLength = 16 + parsingState.messageLength;
        if (buffer.remaining() < totalMsgLength) {
            return ctx.getStopAction((Object)buffer);
        }
        int pos = buffer.position();
        GMSBufferWrapper gmsBuffer = parsingState.gmsBufferWrapper.wrap(buffer);
        parsingState.message.parseMessage(gmsBuffer, pos + 16, parsingState.messageLength);
        ctx.setMessage((Object)parsingState.message);
        gmsBuffer.recycle();
        Buffer remainder = buffer.split(pos + totalMsgLength);
        parsingState.reset();
        return ctx.getInvokeAction(remainder.hasRemaining() ? remainder : null);
    }

    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        Message message = (Message)ctx.getMessage();
        MemoryManager mm = ctx.getConnection().getTransport().getMemoryManager();
        com.sun.enterprise.mgmt.transport.buffers.Buffer buffer = message.getPlainBuffer(Grizzly2ExpandableBufferWriter.createFactory(mm));
        ctx.setMessage(buffer.underlying());
        return ctx.getInvokeAction();
    }

    static final class MessageParsingState {
        final GMSBufferWrapper gmsBufferWrapper = new GMSBufferWrapper();
        boolean isHeaderParsed;
        int messageLength;
        MessageImpl message;

        MessageParsingState() {
        }

        void reset() {
            this.isHeaderParsed = false;
            this.message = null;
            this.messageLength = 0;
            this.gmsBufferWrapper.recycle();
        }
    }
}

