/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import jakarta.servlet.ReadListener;
import jakarta.servlet.http.WebConnection;
import java.io.IOException;
import java.io.Reader;
import java.nio.channels.InterruptedByTimeoutException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.LogFacade;
import org.apache.catalina.connector.AsyncContextImpl;
import org.apache.catalina.connector.Request;
import org.glassfish.grizzly.ReadHandler;
import org.glassfish.grizzly.http.util.ByteChunk;
import org.glassfish.grizzly.http.util.CharChunk;

public class InputBuffer
extends Reader
implements ByteChunk.ByteInputChannel,
CharChunk.CharInputChannel,
CharChunk.CharOutputChannel {
    private static final Logger log = LogFacade.getLogger();
    private static final ResourceBundle rb = log.getResourceBundle();
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private org.glassfish.grizzly.http.server.Request grizzlyRequest;
    private org.glassfish.grizzly.http.io.InputBuffer grizzlyInputBuffer;
    private Request request;
    private ReadHandler readHandler = null;
    private boolean prevIsReady = true;
    private static final ThreadLocal<Boolean> IS_READY_SCOPE = new ThreadLocal();

    public InputBuffer() {
        this(8192);
    }

    public InputBuffer(int size) {
    }

    public void setRequest(org.glassfish.grizzly.http.server.Request grizzlyRequest) {
        this.grizzlyRequest = grizzlyRequest;
        this.grizzlyInputBuffer = grizzlyRequest.getInputBuffer();
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public org.glassfish.grizzly.http.server.Request getRequest() {
        return this.grizzlyRequest;
    }

    public void recycle() {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "recycle()");
        }
        this.grizzlyInputBuffer = null;
        this.grizzlyRequest = null;
        this.readHandler = null;
        this.prevIsReady = true;
    }

    @Override
    public void close() throws IOException {
        this.grizzlyInputBuffer.close();
    }

    public int available() throws IOException {
        return this.grizzlyInputBuffer.readyData();
    }

    public int realReadBytes(byte[] cbuf, int off, int len) throws IOException {
        return this.grizzlyInputBuffer.read(cbuf, off, len);
    }

    public int readByte() throws IOException {
        if (this.grizzlyInputBuffer.isClosed()) {
            throw new IOException(rb.getString("AS-WEB-CORE-00045"));
        }
        return this.grizzlyInputBuffer.readByte();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.grizzlyInputBuffer.isClosed()) {
            throw new IOException(rb.getString("AS-WEB-CORE-00045"));
        }
        return this.grizzlyInputBuffer.read(b, off, len);
    }

    public boolean isFinished() {
        return this.grizzlyInputBuffer.isFinished();
    }

    public boolean isReady() {
        boolean result;
        if (!this.prevIsReady) {
            return false;
        }
        boolean bl = result = this.grizzlyInputBuffer.available() > 0;
        if (!result) {
            if (this.readHandler != null) {
                this.prevIsReady = false;
                IS_READY_SCOPE.set(Boolean.TRUE);
                try {
                    this.grizzlyInputBuffer.notifyAvailable(this.readHandler);
                }
                finally {
                    IS_READY_SCOPE.remove();
                }
            } else {
                this.prevIsReady = true;
            }
        }
        return result;
    }

    public void setReadListener(ReadListener readListener) {
        if (this.readHandler != null) {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00046"));
        }
        if (!this.request.isAsyncStarted() && !this.request.isUpgrade()) {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00047"));
        }
        this.readHandler = new ReadHandlerImpl(readListener);
        if (this.isReady()) {
            try {
                this.readHandler.onDataAvailable();
            }
            catch (Throwable t) {
                log.log(Level.WARNING, "AS-WEB-CORE-00048", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disableReadHandler() {
        if (this.readHandler != null) {
            ReadHandler readHandler = this.readHandler;
            synchronized (readHandler) {
                this.readHandler.onError((Throwable)new InterruptedByTimeoutException());
            }
        }
    }

    public void realWriteChars(char[] c, int off, int len) throws IOException {
    }

    public void setEncoding(String encoding) {
        this.grizzlyInputBuffer.setDefaultEncoding(encoding);
    }

    public int realReadChars(char[] cbuf, int off, int len) throws IOException {
        return this.grizzlyInputBuffer.read(cbuf, off, len);
    }

    @Override
    public int read() throws IOException {
        if (this.grizzlyInputBuffer.isClosed()) {
            throw new IOException(rb.getString("AS-WEB-CORE-00045"));
        }
        return this.grizzlyInputBuffer.readChar();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.grizzlyInputBuffer.isClosed()) {
            throw new IOException(rb.getString("AS-WEB-CORE-00045"));
        }
        return this.grizzlyInputBuffer.read(cbuf, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.grizzlyInputBuffer.isClosed()) {
            throw new IOException(rb.getString("AS-WEB-CORE-00045"));
        }
        if (n < 0L) {
            throw new IllegalArgumentException();
        }
        return this.grizzlyInputBuffer.skip(n, true);
    }

    @Override
    public boolean ready() throws IOException {
        if (this.grizzlyInputBuffer.isClosed()) {
            throw new IOException(rb.getString("AS-WEB-CORE-00045"));
        }
        return this.grizzlyInputBuffer.ready();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.grizzlyInputBuffer.mark(readAheadLimit);
    }

    @Override
    public void reset() throws IOException {
        if (this.grizzlyInputBuffer.isClosed()) {
            throw new IOException(rb.getString("AS-WEB-CORE-00045"));
        }
        this.grizzlyInputBuffer.reset();
    }

    public void checkConverter() throws IOException {
        this.grizzlyInputBuffer.processingChars();
    }

    class ReadHandlerImpl
    implements ReadHandler {
        private ReadListener readListener = null;
        private volatile boolean disable = false;

        private ReadHandlerImpl(ReadListener listener) {
            this.readListener = listener;
        }

        public void onDataAvailable() {
            if (this.disable) {
                return;
            }
            if (!Boolean.TRUE.equals(IS_READY_SCOPE.get())) {
                this.processDataAvailable();
            } else {
                AsyncContextImpl.getExecutorService().execute(new Runnable(){

                    @Override
                    public void run() {
                        ReadHandlerImpl.this.processDataAvailable();
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processDataAvailable() {
            ClassLoader oldCL;
            PrivilegedAction<ClassLoader> pa;
            if (Globals.IS_SECURITY_ENABLED) {
                pa = new PrivilegedGetTccl();
                oldCL = AccessController.doPrivileged(pa);
            } else {
                oldCL = Thread.currentThread().getContextClassLoader();
            }
            try {
                Context context = InputBuffer.this.request.getContext();
                ClassLoader newCL = context.getLoader().getClassLoader();
                if (Globals.IS_SECURITY_ENABLED) {
                    PrivilegedSetTccl pa2 = new PrivilegedSetTccl(newCL);
                    AccessController.doPrivileged(pa2);
                } else {
                    Thread.currentThread().setContextClassLoader(newCL);
                }
                ReadHandlerImpl readHandlerImpl = this;
                synchronized (readHandlerImpl) {
                    InputBuffer.this.prevIsReady = true;
                    try {
                        context.fireContainerEvent("beforeReadListenerOnDataAvailable", this.readListener);
                        this.readListener.onDataAvailable();
                    }
                    catch (Throwable t) {
                        this.disable = true;
                        this.readListener.onError(t);
                    }
                    finally {
                        context.fireContainerEvent("afterReadListenerOnDataAvailable", this.readListener);
                    }
                }
            }
            finally {
                if (Globals.IS_SECURITY_ENABLED) {
                    pa = new PrivilegedSetTccl(oldCL);
                    AccessController.doPrivileged(pa);
                } else {
                    Thread.currentThread().setContextClassLoader(oldCL);
                }
            }
        }

        public void onAllDataRead() {
            if (this.disable) {
                return;
            }
            if (!Boolean.TRUE.equals(IS_READY_SCOPE.get())) {
                this.processAllDataRead();
            } else {
                AsyncContextImpl.getExecutorService().execute(new Runnable(){

                    @Override
                    public void run() {
                        ReadHandlerImpl.this.processAllDataRead();
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processAllDataRead() {
            ClassLoader oldCL;
            PrivilegedAction<ClassLoader> pa;
            if (Globals.IS_SECURITY_ENABLED) {
                pa = new PrivilegedGetTccl();
                oldCL = AccessController.doPrivileged(pa);
            } else {
                oldCL = Thread.currentThread().getContextClassLoader();
            }
            try {
                Context context = InputBuffer.this.request.getContext();
                ClassLoader newCL = context.getLoader().getClassLoader();
                if (Globals.IS_SECURITY_ENABLED) {
                    PrivilegedSetTccl pa2 = new PrivilegedSetTccl(newCL);
                    AccessController.doPrivileged(pa2);
                } else {
                    Thread.currentThread().setContextClassLoader(newCL);
                }
                ReadHandlerImpl readHandlerImpl = this;
                synchronized (readHandlerImpl) {
                    InputBuffer.this.prevIsReady = true;
                    try {
                        context.fireContainerEvent("beforeReadListenerOnAllDataRead", this.readListener);
                        this.readListener.onAllDataRead();
                    }
                    catch (Throwable t) {
                        this.disable = true;
                        this.readListener.onError(t);
                    }
                    finally {
                        context.fireContainerEvent("afterReadListenerOnAllDataRead", this.readListener);
                    }
                }
            }
            finally {
                if (Globals.IS_SECURITY_ENABLED) {
                    pa = new PrivilegedSetTccl(oldCL);
                    AccessController.doPrivileged(pa);
                } else {
                    Thread.currentThread().setContextClassLoader(oldCL);
                }
            }
        }

        public void onError(final Throwable t) {
            if (this.disable) {
                return;
            }
            this.disable = true;
            if (!Boolean.TRUE.equals(IS_READY_SCOPE.get())) {
                this.processError(t);
            } else {
                AsyncContextImpl.getExecutorService().execute(new Runnable(){

                    @Override
                    public void run() {
                        ReadHandlerImpl.this.processError(t);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processError(Throwable t) {
            ClassLoader oldCL;
            PrivilegedAction<ClassLoader> pa;
            if (Globals.IS_SECURITY_ENABLED) {
                pa = new PrivilegedGetTccl();
                oldCL = AccessController.doPrivileged(pa);
            } else {
                oldCL = Thread.currentThread().getContextClassLoader();
            }
            try {
                Context context = InputBuffer.this.request.getContext();
                ClassLoader newCL = context.getLoader().getClassLoader();
                if (Globals.IS_SECURITY_ENABLED) {
                    PrivilegedSetTccl pa2 = new PrivilegedSetTccl(newCL);
                    AccessController.doPrivileged(pa2);
                } else {
                    Thread.currentThread().setContextClassLoader(newCL);
                }
                ReadHandlerImpl readHandlerImpl = this;
                synchronized (readHandlerImpl) {
                    boolean isUpgrade = InputBuffer.this.request.isUpgrade();
                    WebConnection wc = InputBuffer.this.request.getWebConnection();
                    try {
                        context.fireContainerEvent("beforeReadListenerOnError", this.readListener);
                        this.readListener.onError(t);
                    }
                    finally {
                        if (isUpgrade && wc != null) {
                            try {
                                wc.close();
                            }
                            catch (Exception exception) {}
                        }
                        context.fireContainerEvent("afterReadListenerOnError", this.readListener);
                    }
                }
            }
            finally {
                if (Globals.IS_SECURITY_ENABLED) {
                    pa = new PrivilegedSetTccl(oldCL);
                    AccessController.doPrivileged(pa);
                } else {
                    Thread.currentThread().setContextClassLoader(oldCL);
                }
            }
        }
    }

    private static class PrivilegedGetTccl
    implements PrivilegedAction<ClassLoader> {
        private PrivilegedGetTccl() {
        }

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }

    private static class PrivilegedSetTccl
    implements PrivilegedAction<Void> {
        private ClassLoader cl;

        PrivilegedSetTccl(ClassLoader cl) {
            this.cl = cl;
        }

        @Override
        public Void run() {
            Thread.currentThread().setContextClassLoader(this.cl);
            return null;
        }
    }
}

