/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.util;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.ResourceEnvReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.types.MessageDestinationReferencer;
import com.sun.enterprise.deployment.util.EjbBundleVisitor;
import com.sun.enterprise.deployment.util.TracerVisitor;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.ejb.deployment.descriptor.ContainerTransaction;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.ejb.deployment.descriptor.EjbCMPEntityDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.FieldDescriptor;
import org.glassfish.ejb.deployment.descriptor.PersistenceDescriptor;
import org.glassfish.ejb.deployment.descriptor.QueryDescriptor;
import org.glassfish.ejb.deployment.descriptor.RelationshipDescriptor;

public class EjbBundleTracerVisitor
extends TracerVisitor
implements EjbBundleVisitor {
    private static final System.Logger LOG = System.getLogger(EjbBundleTracerVisitor.class.getName());

    public void accept(BundleDescriptor bundle) {
        LOG.log(System.Logger.Level.INFO, "accept(bundle.name={0})", bundle.getName());
        if (bundle instanceof EjbBundleDescriptorImpl) {
            EjbBundleDescriptorImpl ejbBundle = (EjbBundleDescriptorImpl)bundle;
            this.accept(ejbBundle);
            for (EjbDescriptor anEjb : ejbBundle.getEjbs()) {
                anEjb.visit(this.getSubDescriptorVisitor((Descriptor)anEjb));
            }
            if (ejbBundle.hasRelationships()) {
                for (RelationshipDescriptor rd : ejbBundle.getRelationships()) {
                    this.accept(rd);
                }
            }
            for (WebService ws : ejbBundle.getWebServices().getWebServices()) {
                this.accept(ws);
            }
        }
        super.accept(bundle);
    }

    public void accept(EjbBundleDescriptor bundle) {
        LOG.log(System.Logger.Level.INFO, "accept(bundle.name={0})", bundle.getName());
    }

    protected void accept(EjbDescriptor ejb) {
        Object msgDestReferencer;
        LOG.log(System.Logger.Level.INFO, "accept ejb:\n{0}", new Object[]{ejb});
        for (EjbReference aRef : ejb.getEjbReferenceDescriptors()) {
            this.accept(aRef);
        }
        for (Object mp : ejb.getPermissionedMethodsByPermission().keySet()) {
            Set set = (Set)ejb.getPermissionedMethodsByPermission().get(mp);
            this.accept((MethodPermission)mp, set);
        }
        Map methodPerms = ejb.getStyledPermissionedMethodsByPermission();
        if (methodPerms != null) {
            for (Map.Entry entry : methodPerms.entrySet()) {
                this.accept((MethodPermission)entry.getKey(), (Collection)entry.getValue());
            }
        }
        for (RoleReference roleRef : ejb.getRoleReferences()) {
            this.accept(roleRef);
        }
        for (Map.Entry<MethodDescriptor, ContainerTransaction> md : ejb.getMethodContainerTransactions().entrySet()) {
            this.accept(md.getKey(), md.getValue());
        }
        for (EnvironmentProperty envProp : ejb.getEnvironmentProperties()) {
            this.accept(envProp);
        }
        for (ResourceReferenceDescriptor next : ejb.getResourceReferenceDescriptors()) {
            this.accept(next);
        }
        for (ResourceReferenceDescriptor next : ejb.getResourceEnvReferenceDescriptors()) {
            this.accept((ResourceEnvReferenceDescriptor)next);
        }
        for (ResourceReferenceDescriptor next : ejb.getMessageDestinationReferenceDescriptors()) {
            this.accept((MessageDestinationReferencer)next);
        }
        if ("Message-driven".equals(ejb.getType()) && (msgDestReferencer = (MessageDestinationReferencer)ejb).getMessageDestinationLinkName() != null) {
            this.accept((MessageDestinationReferencer)msgDestReferencer);
        }
        for (ServiceReferenceDescriptor sref : ejb.getServiceReferenceDescriptors()) {
            this.accept(sref);
        }
        if (ejb instanceof EjbCMPEntityDescriptor) {
            EjbCMPEntityDescriptor cmp = (EjbCMPEntityDescriptor)ejb;
            PersistenceDescriptor persistenceDesc = cmp.getPersistenceDescriptor();
            for (FieldDescriptor field : persistenceDesc.getCMPFields()) {
                this.accept(field);
            }
            for (MethodDescriptor method : persistenceDesc.getQueriedMethods()) {
                QueryDescriptor qd = persistenceDesc.getQueryFor(method);
                this.accept(qd);
            }
        }
    }

    protected void accept(MethodPermission methodPermission, Collection<MethodDescriptor> methodDescriptors) {
        LOG.log(System.Logger.Level.INFO, "accept(methodPermission={0}, methods)", methodPermission);
    }

    protected void accept(RoleReference reference) {
        LOG.log(System.Logger.Level.INFO, "accept(reference={0})", reference);
    }

    protected void accept(MethodDescriptor method, ContainerTransaction transaction) {
        LOG.log(System.Logger.Level.INFO, "accept(method={0}, transaction={1})", new Object[]{method, transaction});
    }

    protected void accept(FieldDescriptor field) {
        LOG.log(System.Logger.Level.INFO, "accept(field={0})", new Object[]{field});
    }

    protected void accept(QueryDescriptor query) {
        LOG.log(System.Logger.Level.INFO, "accept(query={0})", new Object[]{query});
    }

    protected void accept(RelationshipDescriptor rd) {
        LOG.log(System.Logger.Level.INFO, () -> "accept relationship:\nFrom EJB " + rd.getSource().getName() + " cmr field: " + rd.getSource().getCMRField() + "(" + rd.getSource().getCMRFieldType() + ")  to EJB " + rd.getSink().getName() + " isMany " + rd.getSource().getIsMany() + " cascade-delete " + rd.getSource().getCascadeDelete() + "\nTo  EJB " + rd.getSink().getName() + " isMany " + rd.getSink().getIsMany() + " cascade-delete " + rd.getSink().getCascadeDelete() + "\nBidirectional cmr field: " + (String)(rd.getIsBidirectional() ? rd.getSink().getCMRField() + "(" + rd.getSink().getCMRFieldType() + ")" : "false"));
    }
}

