/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import jakarta.servlet.ServletContext;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LogFacade;
import org.apache.catalina.Session;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.session.StoreBase;

public final class FileStore
extends StoreBase {
    private static final Logger log = LogFacade.getLogger();
    private static final ResourceBundle rb = log.getResourceBundle();
    private static final String FILE_EXT = ".session";
    private String directory = ".";
    private File directoryFile = null;
    private static final String info = "FileStore/1.0";
    private static final String storeName = "fileStore";
    private static final String threadName = "FileStore";
    private Hashtable<String, Session> sessions = new Hashtable();

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String path) {
        String oldDirectory = this.directory;
        this.directory = path;
        this.directoryFile = null;
        this.support.firePropertyChange("directory", oldDirectory, this.directory);
    }

    @Override
    public String getInfo() {
        return info;
    }

    public String getThreadName() {
        return threadName;
    }

    @Override
    public String getStoreName() {
        return storeName;
    }

    @Override
    public int getSize() throws IOException {
        File file = this.directory();
        if (file == null) {
            return 0;
        }
        String[] files = file.list();
        int keycount = 0;
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].endsWith(FILE_EXT)) continue;
            ++keycount;
        }
        return keycount;
    }

    @Override
    public void clear() throws IOException {
        String[] keys = this.keys();
        for (int i = 0; i < keys.length; ++i) {
            this.remove(keys[i]);
        }
    }

    @Override
    public String[] keys() throws IOException {
        File file = this.directory();
        if (file == null) {
            return new String[0];
        }
        String[] files = file.list();
        ArrayList<String> list = new ArrayList<String>();
        int n = FILE_EXT.length();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].endsWith(FILE_EXT)) continue;
            list.add(files[i].substring(0, files[i].length() - n));
        }
        return list.toArray(new String[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session load(String id) throws ClassNotFoundException, IOException {
        Session sess = this.sessions.get(id);
        if (sess != null) {
            return sess;
        }
        File file = this.file(id);
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        if (this.debug >= 1) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00338"), id, file.getAbsolutePath());
            this.log(msg);
        }
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        ObjectInputStream ois = null;
        Object loader = null;
        Object classLoader = null;
        try {
            fis = new FileInputStream(file.getAbsolutePath());
            bis = new BufferedInputStream(fis);
            Container container = this.manager.getContainer();
            ois = container != null ? ((StandardContext)container).createObjectInputStream(bis) : new ObjectInputStream(bis);
        }
        catch (FileNotFoundException e) {
            if (this.debug >= 1) {
                this.log("No persisted data file found");
            }
            return null;
        }
        catch (IOException e) {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw e;
        }
        try {
            StandardSession session = StandardSession.deserialize(ois, this.manager);
            session.setManager(this.manager);
            this.sessions.put(session.getIdInternal(), session);
            StandardSession standardSession = session;
            return standardSession;
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void remove(String id) throws IOException {
        File file = this.file(id);
        if (file == null) {
            return;
        }
        if (this.debug >= 1) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00339"), id, file.getAbsolutePath());
            this.log(msg);
        }
        this.sessions.remove(id);
        if (!file.delete() && log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Cannot delete file: " + String.valueOf(file));
        }
    }

    @Override
    public void save(Session session) throws IOException {
        File file = this.file(session.getIdInternal());
        if (file == null) {
            return;
        }
        if (this.debug >= 1) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00340"), session.getIdInternal(), file.getAbsolutePath());
            this.log(msg);
        }
        ObjectOutputStream oos = null;
        try (FileOutputStream fos = new FileOutputStream(file.getAbsolutePath());
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            Container container = this.manager.getContainer();
            oos = container != null ? ((StandardContext)container).createObjectOutputStream(bos) : new ObjectOutputStream(bos);
            oos.writeObject(session);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private File directory() throws IOException {
        if (this.directory == null) {
            return null;
        }
        if (this.directoryFile != null) {
            return this.directoryFile;
        }
        File file = new File(this.directory);
        if (!file.isAbsolute()) {
            Container container = this.manager.getContainer();
            if (container instanceof Context) {
                ServletContext servletContext = ((Context)container).getServletContext();
                File work = (File)servletContext.getAttribute("jakarta.servlet.context.tempdir");
                file = new File(work, this.directory);
            } else {
                throw new IllegalArgumentException("Parent Container is not a Context");
            }
        }
        if (!file.exists() || !file.isDirectory()) {
            String msg;
            if (!file.delete() && file.exists()) {
                msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00341"), file);
                throw new IOException(msg);
            }
            if (!file.mkdirs() && !file.isDirectory()) {
                msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00342"), file);
                throw new IOException(msg);
            }
        }
        this.directoryFile = file;
        return file;
    }

    private File file(String id) throws IOException {
        if (this.directory == null) {
            return null;
        }
        String filename = id + FILE_EXT;
        File file = new File(this.directory(), filename);
        return file;
    }
}

