/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.interceptionFactory;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InterceptionFactory;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.interceptionFactory.Custom;
import org.jboss.cdi.tck.tests.extensions.interceptionFactory.FinalProduct;
import org.jboss.cdi.tck.tests.extensions.interceptionFactory.Product;
import org.jboss.cdi.tck.tests.extensions.interceptionFactory.ProductInterceptor1;
import org.jboss.cdi.tck.tests.extensions.interceptionFactory.ProductInterceptor2;
import org.jboss.cdi.tck.tests.extensions.interceptionFactory.ProductInterceptor3;
import org.jboss.cdi.tck.util.ActionSequence;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class InterceptionFactoryTest
extends AbstractTest {
    @Inject
    @Custom
    FinalProduct finalProduct;
    @Inject
    Product product;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(InterceptionFactoryTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="binding_interceptor_to_bean", id="c"), @SpecAssertion(section="interception_factory", id="b"), @SpecAssertion(section="interception_factory", id="ca")})
    public void producedInstanceIsIntercepted() {
        ActionSequence.reset();
        Assert.assertEquals((int)this.product.ping(), (int)4);
        ActionSequence.assertSequenceDataEquals(ProductInterceptor1.class, ProductInterceptor2.class, ProductInterceptor3.class);
    }

    @Test
    @SpecAssertion(section="interception_factory", id="g")
    public void interceptionFactoryBeanIsAvailable() {
        Bean interceptionFactoryBean = this.getCurrentManager().resolve(this.getCurrentManager().getBeans(InterceptionFactory.class, new Annotation[0]));
        Assert.assertEquals(Dependent.class, (Object)interceptionFactoryBean.getScope());
        Assert.assertEquals(Stream.of(Default.Literal.INSTANCE, Any.Literal.INSTANCE).collect(Collectors.toSet()), (Set)interceptionFactoryBean.getQualifiers());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="binding_interceptor_to_bean", id="c"), @SpecAssertion(section="interception_factory", id="a"), @SpecAssertion(section="interception_factory", id="b"), @SpecAssertion(section="interception_factory", id="ca")})
    public void producedWithFinalMethodIsIntercepted() {
        ActionSequence.reset();
        Assert.assertEquals((int)this.finalProduct.ping(), (int)3);
        ActionSequence.assertSequenceDataEquals(ProductInterceptor1.class, ProductInterceptor2.class);
    }
}

