/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.configurators.beanAttributes;

import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanAttributes;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessBeanAttributes;
import jakarta.enterprise.inject.spi.configurator.BeanAttributesConfigurator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import org.jboss.cdi.tck.tests.extensions.configurators.beanAttributes.Axe;
import org.jboss.cdi.tck.tests.extensions.configurators.beanAttributes.Equipment;
import org.jboss.cdi.tck.tests.extensions.configurators.beanAttributes.Hoe;
import org.jboss.cdi.tck.tests.extensions.configurators.beanAttributes.Mace;
import org.jboss.cdi.tck.tests.extensions.configurators.beanAttributes.Melee;
import org.jboss.cdi.tck.tests.extensions.configurators.beanAttributes.Reforged;
import org.jboss.cdi.tck.tests.extensions.configurators.beanAttributes.Sword;
import org.jboss.cdi.tck.tests.extensions.configurators.beanAttributes.Tool;
import org.jboss.cdi.tck.tests.extensions.configurators.beanAttributes.TwoHanded;
import org.jboss.cdi.tck.tests.extensions.configurators.beanAttributes.Weapon;

public class ProcessBeanAttributesObserver
implements Extension {
    public static AnnotatedType<Axe> annotatedType;
    private BeanAttributes<Mace> originalBA;

    public void observeSword(@Observes ProcessBeanAttributes<Sword> pba) {
        BeanAttributesConfigurator configurator = pba.configureBeanAttributes();
        configurator.addQualifier((Annotation)TwoHanded.TwoHandedLiteral.INSTANCE);
        configurator.addType(Weapon.class);
        configurator.name("Frostmourne");
        configurator.addStereotype(Equipment.class);
    }

    public void observeAxe(@Observes ProcessBeanAttributes<Axe> pba) {
        BeanAttributesConfigurator configurator = pba.configureBeanAttributes();
        configurator.alternative(true);
        configurator.addQualifiers(this.getAxeQualifiers());
        configurator.addStereotypes(this.getStereotypes());
        configurator.types(this.getAxeTypes());
        configurator.scope(RequestScoped.class);
    }

    public void observeHoe(@Observes ProcessBeanAttributes<Hoe> pba) {
        BeanAttributesConfigurator configurator = pba.configureBeanAttributes();
        configurator.addTransitiveTypeClosure(Tool.class);
        Set<Class<? extends Annotation>> stereotypes = this.getStereotypes();
        stereotypes.remove(Melee.class);
        configurator.stereotypes(stereotypes);
        configurator.qualifiers(new Annotation[]{Reforged.ReforgedLiteral.INSTANCE});
    }

    public void observesMacePBA(@Observes ProcessBeanAttributes<Mace> event) {
        this.originalBA = event.getBeanAttributes();
        event.configureBeanAttributes().name("test");
    }

    private Set<Annotation> getAxeQualifiers() {
        HashSet<Annotation> result = new HashSet<Annotation>();
        result.add(TwoHanded.TwoHandedLiteral.INSTANCE);
        result.add(Reforged.ReforgedLiteral.INSTANCE);
        return result;
    }

    private Set<Class<? extends Annotation>> getStereotypes() {
        HashSet<Class<? extends Annotation>> result = new HashSet<Class<? extends Annotation>>();
        result.add(Equipment.class);
        result.add(Melee.class);
        return result;
    }

    private Set<Type> getAxeTypes() {
        HashSet<Type> result = new HashSet<Type>();
        result.add((Type)((Object)Weapon.class));
        result.add((Type)((Object)Tool.class));
        result.add((Type)((Object)Axe.class));
        return result;
    }

    public BeanAttributes<Mace> getOriginalBA() {
        return this.originalBA;
    }
}

