/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.alternative.metadata.annotated;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.annotated.Android;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.annotated.Human;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.annotated.Kryten;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.annotated.Rimmer;

public class ObservingExtension
implements Extension {
    private AnnotatedType<Kryten> kryten;
    private AnnotatedType<Rimmer> rimmer;
    private AnnotatedType<Android> android;
    private List<AnnotatedType<Android>> allAndroids = new ArrayList<AnnotatedType<Android>>();
    private List<AnnotatedType<Human>> allHumans = new ArrayList<AnnotatedType<Human>>();

    public void observeAndroid(@Observes ProcessAnnotatedType<Kryten> event) {
        this.kryten = event.getAnnotatedType();
    }

    public void observeRimmer(@Observes ProcessAnnotatedType<Rimmer> event) {
        this.rimmer = event.getAnnotatedType();
    }

    public void observeAfterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        for (AnnotatedType annotatedType : event.getAnnotatedTypes(Human.class)) {
            this.allHumans.add((AnnotatedType<Human>)annotatedType);
        }
        for (AnnotatedType annotatedType : event.getAnnotatedTypes(Android.class)) {
            this.allAndroids.add((AnnotatedType<Android>)annotatedType);
        }
        this.android = event.getAnnotatedType(Android.class, null);
    }

    public AnnotatedType<Kryten> getKryten() {
        return this.kryten;
    }

    public AnnotatedType<Rimmer> getRimmer() {
        return this.rimmer;
    }

    public AnnotatedType<Android> getAndroid() {
        return this.android;
    }

    public List<AnnotatedType<Human>> getAllHumans() {
        return this.allHumans;
    }

    public List<AnnotatedType<Android>> getAllAndroids() {
        return this.allAndroids;
    }
}

