/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.creation;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.common.MetamodelUtils;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.migration.Instance;
import org.eclipse.emf.edapt.migration.Metamodel;
import org.eclipse.emf.edapt.migration.Model;

@EdaptOperation(identifier="copyFeature", label="Copy Feature", description="In the metamodel, a feature is copied, giving it a new name. In the model, the values are copied, accordingly.")
public class CopyFeature
extends OperationImplementation {
    @EdaptParameter(main=true, description="The feature to be copied")
    public EStructuralFeature feature;
    @EdaptParameter(description="The name of the copy")
    public String name;

    public void execute(Metamodel metamodel, Model model) {
        EReference copiedReference;
        EClass contextClass = this.feature.getEContainingClass();
        EStructuralFeature copiedFeature = (EStructuralFeature)MetamodelUtils.copy((EModelElement)this.feature);
        copiedFeature.setName(this.name);
        contextClass.getEStructuralFeatures().add((Object)copiedFeature);
        if (copiedFeature instanceof EReference && (copiedReference = (EReference)copiedFeature).isContainment()) {
            copiedReference.setContainment(false);
        }
        for (Instance instance : model.getAllInstances(contextClass)) {
            instance.set(copiedFeature, instance.get(this.feature));
        }
    }
}

