/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.jvm.compiled;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ease.AbstractScriptEngine;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Script;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.core.project.IBundleProjectDescription;
import org.eclipse.pde.core.project.IBundleProjectService;
import org.eclipse.pde.core.project.IRequiredBundleDescription;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class JVMCompiledScriptEngine
extends AbstractScriptEngine
implements IScriptEngine {
    private final Map<String, Object> fVariables = new HashMap<String, Object>();

    public JVMCompiledScriptEngine() {
        super("JVMCompiled");
    }

    public void terminateCurrent() {
    }

    protected Object internalGetVariable(String name) {
        return this.fVariables.get(name);
    }

    protected Map<String, Object> internalGetVariables() {
        return this.fVariables;
    }

    protected boolean internalHasVariable(String name) {
        return this.fVariables.containsKey(name);
    }

    protected void internalSetVariable(String name, Object content) {
        this.fVariables.put(name, content);
    }

    public void registerJar(URL url) {
        throw new RuntimeException("Functionality not supported by this engine");
    }

    protected void setupEngine() {
    }

    protected void teardownEngine() {
    }

    protected Object execute(Script script, String fileName, boolean uiThread) throws Exception {
        Method mainMethod;
        Class<?> clazz = JVMCompiledScriptEngine.loadClass(script.getFile());
        if (clazz != null && (mainMethod = clazz.getMethod("main", String[].class)) != null) {
            ClassLoader localClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(clazz.getClassLoader());
            try {
                try {
                    Method initialize = clazz.getMethod("initialize", InputStream.class, PrintStream.class, PrintStream.class);
                    initialize.invoke(null, this.getInputStream(), this.getOutputStream(), this.getErrorStream());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                Object object = mainMethod.invoke(null, this.internalGetVariable("argv"));
                return object;
            }
            finally {
                Thread.currentThread().setContextClassLoader(localClassLoader);
            }
        }
        throw new ClassNotFoundException();
    }

    public static Class<?> loadClass(Object reference) throws JavaModelException, MalformedURLException, ClassNotFoundException {
        Object file = ResourceTools.resolve((Object)reference);
        AbstractMap.SimpleEntry<IFile, IBundleProjectDescription> pair = JVMCompiledScriptEngine.getBundleProjectDescription(file);
        if (pair != null) {
            IFile sourceFile = pair.getKey();
            IBundleProjectDescription scriptBundleProject = pair.getValue();
            ArrayList<URL> urls = new ArrayList<URL>();
            IProject project = scriptBundleProject.getProject();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IClasspathEntry[] cpEntries = javaProject.getRawClasspath();
            if (cpEntries != null) {
                IClasspathEntry[] iClasspathEntryArray = cpEntries;
                int n = cpEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry cpEntry = iClasspathEntryArray[n2];
                    if (cpEntry.getEntryKind() == 2 && cpEntry.getContentKind() == 1) {
                        IPath cpPath = cpEntry.getPath();
                        IProject cpProject = root.getProject(cpPath.toString());
                        if (cpProject != null) {
                            IJavaProject jcpProject = JavaCore.create((IProject)cpProject);
                            IPath output = jcpProject.getOutputLocation();
                            IResource bin = root.findMember(output);
                            IPath binPath2 = bin.getRawLocation();
                            URL url2 = binPath2.toFile().toURI().toURL();
                            urls.add(url2);
                        }
                    } else if (cpEntry.getEntryKind() == 1 && cpEntry.getContentKind() == 2) {
                        IPath path = cpEntry.getPath();
                        urls.add(path.toFile().toURL());
                    }
                    ++n2;
                }
            }
            IPath output = javaProject.getOutputLocation();
            IResource bin = root.findMember(output);
            IPath binPath = bin.getRawLocation();
            URL url = binPath.toFile().toURI().toURL();
            urls.add(url);
            IPath wsPath = sourceFile.getProjectRelativePath();
            IPath wsSource = wsPath.removeFirstSegments(1);
            if (wsSource.getFileExtension().equals("xtend")) {
                wsSource = wsSource.removeFileExtension();
                wsSource = wsSource.addFileExtension("java");
            }
            IRequiredBundleDescription[] requiredBundles = scriptBundleProject.getRequiredBundles();
            ArrayList<Bundle> bundles = new ArrayList<Bundle>();
            if (requiredBundles != null) {
                IRequiredBundleDescription[] iRequiredBundleDescriptionArray = requiredBundles;
                int url2 = requiredBundles.length;
                int binPath2 = 0;
                while (binPath2 < url2) {
                    IRequiredBundleDescription requiredBundle = iRequiredBundleDescriptionArray[binPath2];
                    String id = requiredBundle.getName();
                    Bundle b = Platform.getBundle((String)id);
                    if (b != null) {
                        bundles.add(b);
                    } else {
                        IProject bProject = root.getProject("/" + id);
                        if (bProject != null) {
                            IJavaProject bjProject = JavaCore.create((IProject)bProject);
                            IPath bOutput = bjProject.getOutputLocation();
                            IResource bBin = root.findMember(bOutput);
                            IPath bBinPath = bBin.getRawLocation();
                            URL bUrl = bBinPath.toFile().toURI().toURL();
                            urls.add(bUrl);
                        }
                    }
                    ++binPath2;
                }
            }
            URLClassLoader cl = new URLClassLoader(urls.toArray(new URL[urls.size()]), JVMCompiledScriptEngine.class.getClassLoader());
            IJavaElement wsElement = javaProject.findElement(wsSource);
            if (wsElement instanceof ICompilationUnit) {
                ICompilationUnit u = (ICompilationUnit)wsElement;
                String uName = u.getElementName();
                int dot = uName.indexOf(46);
                String qName = uName.substring(0, dot);
                IJavaElement uParent = u.getParent();
                while (uParent instanceof IPackageFragment) {
                    IPackageFragment uPkg = (IPackageFragment)uParent;
                    String pkgName = uPkg.getElementName();
                    if (pkgName != null && !pkgName.isEmpty()) {
                        qName = String.valueOf(pkgName) + "." + qName;
                    }
                    uParent = uParent.getParent();
                }
                return cl.loadClass(qName);
            }
        }
        return null;
    }

    private static AbstractMap.SimpleEntry<IFile, IBundleProjectDescription> getBundleProjectDescription(Object reference) {
        IFile sourceFile = null;
        if (reference instanceof IFile) {
            sourceFile = (IFile)reference;
        } else if (reference instanceof File) {
            URI scriptURI = ((File)reference).toURI();
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IFile[] files = workspaceRoot.findFilesForLocationURI(scriptURI);
            if (files != null && files.length == 1) {
                sourceFile = files[0];
            }
        }
        if (sourceFile != null) {
            Bundle bundle = FrameworkUtil.getBundle(IBundleProjectService.class);
            BundleContext context = bundle.getBundleContext();
            ServiceReference ref = context.getServiceReference(IBundleProjectService.class);
            IBundleProjectService service = (IBundleProjectService)context.getService(ref);
            try {
                IBundleProjectDescription projectDescription = service.getDescription(sourceFile.getProject());
                if (projectDescription != null) {
                    return new AbstractMap.SimpleEntry<IFile, IBundleProjectDescription>(sourceFile, projectDescription);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }
}

