/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.tools;

import org.eclipse.ease.ui.Activator;
import org.eclipse.ease.ui.tools.AbstractPopupItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;

public abstract class AbstractPopupMenu
extends AbstractPopupItem
implements IMenuListener {
    private final MenuManager fMenuManager;
    private IServiceLocator fServiceLocator;
    private boolean fSeparatorRequested = false;

    public AbstractPopupMenu(String name) {
        this.fMenuManager = new MenuManager(name, this.getImageDescriptor(), null);
        this.fMenuManager.setRemoveAllWhenShown(true);
        this.fMenuManager.addMenuListener((IMenuListener)this);
    }

    @Override
    public final IContributionItem getContribution(IServiceLocator serviceLocator) {
        this.fServiceLocator = serviceLocator;
        return this.fMenuManager;
    }

    public final void menuAboutToShow(IMenuManager manager) {
        this.fSeparatorRequested = false;
        this.populate();
    }

    protected final void addPopup(AbstractPopupItem item) {
        if (item == null) {
            this.fSeparatorRequested = true;
        } else if (item.isVisible()) {
            if (this.fSeparatorRequested) {
                this.fMenuManager.add((IContributionItem)new Separator());
                this.fSeparatorRequested = false;
            }
            this.fMenuManager.add(item.getContribution(this.fServiceLocator));
        }
    }

    protected final void addSeparator() {
        this.addPopup(null);
    }

    @Override
    public CommandContributionItemParameter getContributionParameter() {
        return null;
    }

    @Override
    public String getDisplayName() {
        return this.fMenuManager.getMenuText();
    }

    @Override
    protected ImageDescriptor getImageDescriptor() {
        return Activator.getImageDescriptor("/icons/eobj16/folder.png");
    }

    protected abstract void populate();
}

