/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.modeling.ui.matchers;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.ease.modules.modeling.ui.Messages;
import org.eclipse.ease.modules.modeling.ui.exceptions.MatcherException;
import org.eclipse.ease.modules.modeling.ui.matchers.IMatcher;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;

public class AttributeMatcher
implements IMatcher {
    private static Pattern ATTRIBUTE_SEARCH = Pattern.compile("(.*)=(.*)", 32);

    @Override
    public Collection<EObject> getElements(String string, IEditingDomainProvider currentEditor) throws MatcherException {
        Matcher matcherAtt = ATTRIBUTE_SEARCH.matcher(string);
        if (matcherAtt.matches()) {
            final String name = matcherAtt.group(1);
            String regex = matcherAtt.group(2);
            try {
                final Pattern reg = Pattern.compile(regex, 34);
                Object filter = Iterators.emptyIterator();
                for (Resource r : currentEditor.getEditingDomain().getResourceSet().getResources()) {
                    if (r == null) continue;
                    filter = Iterators.concat((Iterator)filter, (Iterator)Iterators.filter((Iterator)r.getAllContents(), (Predicate)new Predicate<EObject>(){

                        public boolean apply(EObject input) {
                            for (EAttribute a : input.eClass().getEAllAttributes()) {
                                if (!a.getName().equalsIgnoreCase(name)) continue;
                                Object val = input.eGet((EStructuralFeature)a);
                                if (val == null) {
                                    val = "";
                                }
                                if (!reg.matcher(val.toString()).matches()) continue;
                                return true;
                            }
                            return false;
                        }
                    }));
                }
                return Lists.newArrayList((Iterator)filter);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new MatcherException(String.valueOf(regex) + Messages.AttributeMatcher_INCORRECT_PATTERN);
            }
        }
        throw new MatcherException(Messages.AttributeMatcher_UNRECOGNIZED_PATTERN);
    }

    @Override
    public String getText() {
        return Messages.AttributeMatcher_TEXT_COMBO_ATTRIBUTE;
    }

    @Override
    public String getHelp() {
        return Messages.AttributeMatcher_HELP_ATTRIBUTE;
    }
}

