/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.internal.core;

import org.eclipse.e4.xwt.IDataProvider;
import org.eclipse.e4.xwt.IXWTLoader;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.core.IDynamicBinding;
import org.eclipse.e4.xwt.databinding.BindingMode;
import org.eclipse.e4.xwt.databinding.IBindingContext;
import org.eclipse.e4.xwt.internal.utils.UserData;
import org.eclipse.swt.widgets.Control;

public abstract class DynamicBinding
implements IDynamicBinding {
    private Object control;
    private Object host;
    private BindingMode mode = BindingMode.TwoWay;
    private IXWTLoader xwtLoader;
    private IBindingContext bindingContext;
    private String type;

    public IBindingContext getBindingContext() {
        if (this.bindingContext == null) {
            Object element = this.control == null ? this.host : this.control;
            this.bindingContext = XWT.getBindingContext(element);
        }
        return this.bindingContext;
    }

    public Object getHost() {
        return this.host;
    }

    public void setHost(Object host) {
        this.host = host;
    }

    public void setBindingContext(IBindingContext bindingContext) {
        this.bindingContext = bindingContext;
    }

    public void setControl(Object control) {
        this.control = control;
    }

    public Object getControl() {
        return this.control;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public BindingMode getMode() {
        return this.mode;
    }

    public void setMode(BindingMode mode) {
        this.mode = mode;
    }

    public void setXWTLoader(IXWTLoader xwtLoader) {
        this.xwtLoader = xwtLoader;
    }

    protected Object getDataContextHost() {
        Object control = this.getControl();
        if (control == null) {
            return null;
        }
        Object data = UserData.getLocalDataContext(control);
        if (data == null || data == this) {
            if (data == null && UserData.hasLocalData(control, "DataContext")) {
                return control;
            }
            Control parent = UserData.getParent(control);
            if (parent != null) {
                return UserData.getDataContextHost(parent);
            }
            return null;
        }
        return control;
    }

    protected Object getDataContext() {
        if (this.control != null) {
            return UserData.getDataContext(this.control);
        }
        return null;
    }

    protected IDataProvider getDataProvider(Object dataContext) {
        if (dataContext != null) {
            if (dataContext instanceof IDataProvider) {
                return (IDataProvider)dataContext;
            }
            return this.xwtLoader.findDataProvider(dataContext);
        }
        return null;
    }

    public IDataProvider getDataProvider() {
        return this.getDataProvider(this.getDataContext());
    }
}

