/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.conversion.NumberToStringConverter;
import org.eclipse.core.databinding.conversion.StringToNumberConverter;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.xwt.DefaultLoadingContext;
import org.eclipse.e4.xwt.IDataProvider;
import org.eclipse.e4.xwt.IDataProviderFactory;
import org.eclipse.e4.xwt.IEventConstants;
import org.eclipse.e4.xwt.IEventGroup;
import org.eclipse.e4.xwt.ILanguageSupport;
import org.eclipse.e4.xwt.ILoadingContext;
import org.eclipse.e4.xwt.ILogger;
import org.eclipse.e4.xwt.IMetaclassFactory;
import org.eclipse.e4.xwt.INamespaceHandler;
import org.eclipse.e4.xwt.IStyle;
import org.eclipse.e4.xwt.IXWTLoader;
import org.eclipse.e4.xwt.ResourceDictionary;
import org.eclipse.e4.xwt.Tracking;
import org.eclipse.e4.xwt.XWTException;
import org.eclipse.e4.xwt.animation.BeginStoryboard;
import org.eclipse.e4.xwt.animation.ColorAnimation;
import org.eclipse.e4.xwt.animation.DoubleAnimation;
import org.eclipse.e4.xwt.animation.IntAnimation;
import org.eclipse.e4.xwt.animation.PauseStoryboard;
import org.eclipse.e4.xwt.animation.PointAnimation;
import org.eclipse.e4.xwt.animation.RectangleAnimation;
import org.eclipse.e4.xwt.animation.ResumeStoryboard;
import org.eclipse.e4.xwt.animation.SizeAnimation;
import org.eclipse.e4.xwt.animation.StopStoryboard;
import org.eclipse.e4.xwt.animation.Storyboard;
import org.eclipse.e4.xwt.collection.CollectionViewSource;
import org.eclipse.e4.xwt.converters.BindingToObject;
import org.eclipse.e4.xwt.converters.CollectionToBoolean;
import org.eclipse.e4.xwt.converters.CollectionToInteger;
import org.eclipse.e4.xwt.converters.DateToString;
import org.eclipse.e4.xwt.converters.EnumToString;
import org.eclipse.e4.xwt.converters.IStatusToBoolean;
import org.eclipse.e4.xwt.converters.IStatusToString;
import org.eclipse.e4.xwt.converters.ListToIObservableCollection;
import org.eclipse.e4.xwt.converters.ListToSet;
import org.eclipse.e4.xwt.converters.ObjectToBoolean;
import org.eclipse.e4.xwt.converters.ObjectToISelection;
import org.eclipse.e4.xwt.converters.ObjectToString;
import org.eclipse.e4.xwt.converters.SelectionToBoolean;
import org.eclipse.e4.xwt.converters.SetToIObservableCollection;
import org.eclipse.e4.xwt.converters.StringToBoolean;
import org.eclipse.e4.xwt.converters.StringToColor;
import org.eclipse.e4.xwt.converters.StringToDoubleArray;
import org.eclipse.e4.xwt.converters.StringToDuration;
import org.eclipse.e4.xwt.converters.StringToFont;
import org.eclipse.e4.xwt.converters.StringToFormAttachment;
import org.eclipse.e4.xwt.converters.StringToIValidationRule;
import org.eclipse.e4.xwt.converters.StringToIValueConverter;
import org.eclipse.e4.xwt.converters.StringToImage;
import org.eclipse.e4.xwt.converters.StringToIntArray;
import org.eclipse.e4.xwt.converters.StringToInteger;
import org.eclipse.e4.xwt.converters.StringToPoint;
import org.eclipse.e4.xwt.converters.StringToRectangle;
import org.eclipse.e4.xwt.converters.StringToRepeatBehavior;
import org.eclipse.e4.xwt.converters.StringToType;
import org.eclipse.e4.xwt.converters.StringToURL;
import org.eclipse.e4.xwt.core.Condition;
import org.eclipse.e4.xwt.core.DataTrigger;
import org.eclipse.e4.xwt.core.EventTrigger;
import org.eclipse.e4.xwt.core.IBinding;
import org.eclipse.e4.xwt.core.MultiDataTrigger;
import org.eclipse.e4.xwt.core.MultiTrigger;
import org.eclipse.e4.xwt.core.RadioEventGroup;
import org.eclipse.e4.xwt.core.Setter;
import org.eclipse.e4.xwt.core.Style;
import org.eclipse.e4.xwt.core.Trigger;
import org.eclipse.e4.xwt.core.TriggerBase;
import org.eclipse.e4.xwt.databinding.BindingContext;
import org.eclipse.e4.xwt.databinding.IBindingContext;
import org.eclipse.e4.xwt.dataproviders.ObjectDataProvider;
import org.eclipse.e4.xwt.input.ICommand;
import org.eclipse.e4.xwt.internal.core.BindingExpressionPath;
import org.eclipse.e4.xwt.internal.core.Core;
import org.eclipse.e4.xwt.internal.core.MetaclassManager;
import org.eclipse.e4.xwt.internal.core.MultiBinding;
import org.eclipse.e4.xwt.internal.core.ScopeKeeper;
import org.eclipse.e4.xwt.internal.core.ScopeManager;
import org.eclipse.e4.xwt.internal.core.UpdateSourceTrigger;
import org.eclipse.e4.xwt.internal.utils.ObjectUtil;
import org.eclipse.e4.xwt.internal.utils.UserData;
import org.eclipse.e4.xwt.javabean.ResourceLoaderFactory;
import org.eclipse.e4.xwt.javabean.ValueConvertorRegister;
import org.eclipse.e4.xwt.javabean.metadata.BindingMetaclass;
import org.eclipse.e4.xwt.javabean.metadata.ComboBoxCellEditorMetaclass;
import org.eclipse.e4.xwt.javabean.metadata.ExpandItemHeightAction;
import org.eclipse.e4.xwt.javabean.metadata.TableEditorMetaclass;
import org.eclipse.e4.xwt.javabean.metadata.TableViewerColumnMetaClass;
import org.eclipse.e4.xwt.javabean.metadata.properties.AbstractProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.ColumnViewerColumnsProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.DataProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.DynamicBeanProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.DynamicProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.InputBeanProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.MultiSelectionBeanProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.SingleSelectionBeanProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.StyleProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.TableColumnEditorProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.TableEditorDynamicProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.TableItemEditorProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.TableItemProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.TableViewerColumnDynamicProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.TableViewerColumnImageProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.TableViewerColumnTextProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.TableViewerColumnWidthProperty;
import org.eclipse.e4.xwt.jface.ComboBoxCellEditor;
import org.eclipse.e4.xwt.jface.DefaultCellModifier;
import org.eclipse.e4.xwt.jface.JFaceInitializer;
import org.eclipse.e4.xwt.jface.JFacesHelper;
import org.eclipse.e4.xwt.jface.ObservableTreeContentProvider;
import org.eclipse.e4.xwt.jface.ViewerFilter;
import org.eclipse.e4.xwt.metadata.IMetaclass;
import org.eclipse.e4.xwt.metadata.IProperty;
import org.eclipse.e4.xwt.utils.ResourceManager;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableSetContentProvider;
import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CBanner;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.IME;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWTLoader
implements IXWTLoader {
    private Stack<Core> cores;
    public Display display = Display.getCurrent();
    public Realm realm;

    public XWTLoader() {
        if (this.display == null) {
            this.display = new Display();
        }
        if (this.realm == null) {
            this.realm = SWTObservables.getRealm((Display)this.display);
        }
        this.initialize();
    }

    @Override
    public Object createUIProfile() {
        Core core = new Core(new ResourceLoaderFactory(), this);
        this.cores.push(core);
        return core;
    }

    @Override
    public boolean applyProfile(Object profile) {
        if (profile instanceof Core) {
            if (this.cores.peek() == profile) {
                return false;
            }
            this.cores.push((Core)profile);
            return true;
        }
        throw new XWTException("Wrong UI Profile.");
    }

    @Override
    public Object restoreProfile() {
        if (this.cores.size() > 1) {
            return this.cores.pop();
        }
        throw new XWTException("No user-defined UI Profile.");
    }

    @Override
    public Realm getRealm() {
        return this.realm;
    }

    protected Core getCurrentCore() {
        return this.cores.peek();
    }

    @Override
    public ILogger getLogger() {
        return this.getCurrentCore().getLogger();
    }

    @Override
    public void setLogger(ILogger log) {
        this.getCurrentCore().setLogger(log);
    }

    @Override
    public Object getPropertyValue(Object uiElement, IProperty property) {
        return UserData.getLocalData(uiElement, property);
    }

    @Override
    public void setPropertyValue(Object uiElement, IProperty property, Object value) {
        UserData.setLocalData(uiElement, property, value);
    }

    @Override
    public void removePropertyValue(Object uiElement, IProperty property) {
        UserData.removeLocalData(uiElement, property);
    }

    @Override
    public boolean hasPropertyValue(Object uiElement, IProperty property) {
        return UserData.hasLocalData(uiElement, property);
    }

    @Override
    public boolean addObservableChangeListener(Object control, IChangeListener listener) {
        ScopeKeeper scope = UserData.findScopeKeeper(control);
        if (scope != null) {
            return scope.addChangeListener(listener);
        }
        return false;
    }

    @Override
    public void removeObservableChangeListener(Object control, IChangeListener listener) {
        ScopeKeeper scope = UserData.findScopeKeeper(control);
        if (scope != null) {
            scope.removeChangeListener(listener);
        }
    }

    @Override
    public IObservable observe(Object control, Object data, String fullPath, UpdateSourceTrigger updateSourceTrigger) {
        return ScopeManager.observe(control, data, new BindingExpressionPath(fullPath), updateSourceTrigger);
    }

    @Override
    public IObservableFactory observableFactory(Object control, String fullPath, UpdateSourceTrigger updateSourceTrigger) {
        return ScopeManager.observableFactory(control, new BindingExpressionPath(fullPath), updateSourceTrigger);
    }

    @Override
    public IObservableList findObservableList(Object context, Object data, String fullPath) {
        return ScopeManager.findObservableList(context, null, data, fullPath);
    }

    @Override
    public IObservableSet findObservableSet(Object context, Object data, String fullPath) {
        return ScopeManager.findObservableSet(context, null, data, fullPath);
    }

    @Override
    public IObservableValue observableValue(Object control, Object data, String fullPath, UpdateSourceTrigger updateSourceTrigger) {
        return ScopeManager.observableValue(control, data, fullPath, updateSourceTrigger);
    }

    @Override
    public IObservableValue findObservableValue(Object context, Object data, String fullPath) {
        return ScopeManager.findObservableValue(context, null, data, fullPath);
    }

    @Override
    public Object findResource(Object object, String key) {
        return UserData.findResource(object, key);
    }

    @Override
    public Map<String, Object> getResources(Object object) {
        return UserData.getLocalResources(object);
    }

    @Override
    public void registerNamespaceHandler(String nsmapace, INamespaceHandler handler) {
        this.getCurrentCore().registerNamespaceHandler(nsmapace, handler);
    }

    @Override
    public void unregisterNamespaceHandler(String nsmapace) {
        this.getCurrentCore().unregisterNamespaceHandler(nsmapace);
    }

    @Override
    public INamespaceHandler getNamespaceHandler(String nsmapace) {
        int i = this.cores.size() - 1;
        while (i >= 0) {
            Core core = (Core)this.cores.get(i);
            INamespaceHandler handler = core.getNamespaceHandler(nsmapace);
            if (handler != null) {
                return handler;
            }
            --i;
        }
        return null;
    }

    @Override
    public String getNamespace(Class<?> javaclass) {
        if (this.getMetaclass(javaclass) != null) {
            return "http://www.eclipse.org/xwt/presentation";
        }
        Package javaPackage = javaclass.getPackage();
        if (javaPackage == null) {
            return "clr-namespace:";
        }
        return "clr-namespace:" + javaclass.getPackage().getName();
    }

    @Override
    public String getElementName(Object object) {
        return UserData.getElementName(object);
    }

    @Override
    public Object findElementByName(Object context, String name) {
        return UserData.findElementByName(context, name);
    }

    @Override
    public IBindingContext getBindingContext(Object element) {
        IBindingContext dataBindingContext = UserData.getBindingContext(element);
        if (dataBindingContext == null) {
            dataBindingContext = UserData.createBindingContext(element);
        }
        return dataBindingContext;
    }

    @Override
    public Object getDataContext(Object element) {
        return UserData.getDataContext(element);
    }

    @Override
    public TriggerBase[] getTriggers(Object element) {
        return UserData.getTriggers(element);
    }

    @Override
    public void setDataBindingContext(Object widget, Object dataBindingContext) {
        UserData.setBindingContext(widget, dataBindingContext);
    }

    @Override
    public void setDataContext(Object widget, Object dataContext) {
        UserData.setDataContext(widget, dataContext);
    }

    @Override
    public void setTriggers(Object element, TriggerBase[] triggers) {
        UserData.setTriggers(element, triggers);
    }

    @Override
    public Object getCLR(Object widget) {
        return UserData.getCLR(widget);
    }

    @Override
    public Shell findShell(Object context) {
        return UserData.findShell(context);
    }

    @Override
    public Composite findCompositeParent(Object context) {
        return UserData.findCompositeParent(context);
    }

    @Override
    public IMetaclass getMetaclass(Object object) {
        int i = this.cores.size() - 1;
        while (i >= 0) {
            Core core = (Core)this.cores.get(i);
            IMetaclass metaclass = core.findMetaclass(object);
            if (metaclass != null) {
                return metaclass;
            }
            --i;
        }
        Class<?> javaClass = null;
        javaClass = object instanceof Class ? (Class<?>)object : object.getClass();
        Class<?> superclass = javaClass.getSuperclass();
        IMetaclass superMetaclass = null;
        if (superclass != null) {
            superMetaclass = this.getMetaclass(superclass);
        }
        return this.getCurrentCore().registerMetaclass(javaClass, "http://www.eclipse.org/xwt/presentation", superMetaclass);
    }

    @Override
    public synchronized Control load(URL file) throws Exception {
        return this.loadWithOptions(file, (Map<String, Object>)Collections.EMPTY_MAP);
    }

    @Override
    public synchronized Control load(URL file, Object dataContext) throws Exception {
        return this.load(null, file, dataContext);
    }

    @Override
    public synchronized Control load(Composite parent, URL file) throws Exception {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("XWT.Container", parent);
        return this.loadWithOptions(file, options);
    }

    @Override
    public synchronized Control load(Composite parent, URL file, Object dataContext) throws Exception {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("XWT.Container", parent);
        options.put("XWT.DataContext", dataContext);
        return this.loadWithOptions(file, options);
    }

    @Override
    public synchronized Control load(Composite parent, Class<?> viewType, Object dataContext) throws Exception {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("XWT.Container", parent);
        options.put("XWT.DataContext", dataContext);
        return this.loadWithOptions(viewType, options);
    }

    protected Map<String, Object> prepareOptions(Map<String, Object> options) {
        Boolean disabledStyle = (Boolean)options.get("XWT.DisabledStyles");
        if (!Boolean.TRUE.equals(disabledStyle)) {
            Collection<IStyle> defaultStyles = this.getDefaultStyles();
            Object styles = options.get("XWT.DefaultStyles");
            if (styles != null) {
                if (styles instanceof IStyle) {
                    defaultStyles.add((IStyle)styles);
                } else if (styles instanceof Collection) {
                    for (IStyle style : (Collection)styles) {
                        defaultStyles.add(style);
                    }
                } else if (styles instanceof Object[]) {
                    Object[] objectArray = (Object[])styles;
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        if (!(element instanceof IStyle)) {
                            throw new XWTException("IStyle is expected in [styles] paramters.");
                        }
                        defaultStyles.add((IStyle)element);
                        ++n2;
                    }
                }
                options.remove("XWT.DefaultStyles");
            }
            if (!defaultStyles.isEmpty()) {
                ResourceDictionary dictionary = (ResourceDictionary)options.get("XWT.Resources");
                if (dictionary == null) {
                    dictionary = new ResourceDictionary();
                    if (options == Collections.EMPTY_MAP) {
                        options = new HashMap<String, Object>();
                    }
                    options.put("XWT.Resources", dictionary);
                }
                dictionary.put("XWT.DefaultStyles", defaultStyles);
            }
        }
        return options;
    }

    @Override
    public synchronized Control loadWithOptions(Class<?> viewType, Map<String, Object> options) throws Exception {
        ILoadingContext context = this.getLoadingContext();
        try {
            this.setLoadingContext(new DefaultLoadingContext(viewType.getClassLoader()));
            options = this.prepareOptions(options);
            Control control = this.loadWithOptions(viewType.getResource(String.valueOf(viewType.getSimpleName()) + ".xwt"), options);
            return control;
        }
        finally {
            this.setLoadingContext(context);
        }
    }

    @Override
    public synchronized void open(Class<?> type) throws Exception {
        this.open(type.getResource(String.valueOf(type.getSimpleName()) + ".xwt"), Collections.EMPTY_MAP);
    }

    @Override
    public synchronized void open(URL url) throws Exception {
        this.open(url, Collections.EMPTY_MAP);
    }

    @Override
    public synchronized Control load(Composite parent, InputStream stream, URL file, Object dataContext) throws Exception {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("XWT.Container", parent);
        options.put("XWT.DataContext", dataContext);
        return this.loadWithOptions(stream, file, options);
    }

    @Override
    public synchronized void open(URL url, Object dataContext) throws Exception {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("XWT.DataContext", dataContext);
        this.open(url, options);
    }

    @Override
    public synchronized void open(Class<?> type, Object dataContext) throws Exception {
        this.open(type.getResource(String.valueOf(type.getSimpleName()) + ".xwt"), dataContext);
    }

    @Override
    public synchronized void open(final URL url, final Map<String, Object> options) throws Exception {
        Realm.runWithDefault((Realm)this.realm, (Runnable)new Runnable(){

            public void run() {
                try {
                    if (url == null) {
                        throw new XWTException("UI Resource is not found.");
                    }
                    Control control = XWTLoader.this.loadWithOptions(url, (Map<String, Object>)options);
                    Shell shell = control.getShell();
                    shell.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            ResourceManager.resources.dispose();
                        }
                    });
                    shell.open();
                    while (!shell.isDisposed()) {
                        if (shell.getDisplay().readAndDispatch()) continue;
                        shell.getDisplay().sleep();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public Object convertFrom(IMetaclass type, String string) {
        Class<?> targetType = type.getType();
        return this.convertFrom(targetType, string);
    }

    @Override
    public Object convertFrom(Class<?> targetType, String string) {
        if (targetType == String.class) {
            return string;
        }
        IConverter converter = this.findConvertor(String.class, targetType);
        if (converter != null) {
            return converter.convert((Object)string);
        }
        if (targetType == Object.class) {
            return string;
        }
        throw new XWTException("Converter is missing of type: " + targetType.getName() + " from String");
    }

    @Override
    public synchronized Control loadWithOptions(URL url, Map<String, Object> options) throws Exception {
        if (url == null) {
            throw new XWTException("UI Resource is not found.");
        }
        Composite object = (Composite)options.get("XWT.Container");
        ILoadingContext loadingContext = object != null ? this.getLoadingContext(object) : this.getLoadingContext();
        options = this.prepareOptions(options);
        Control visualObject = this.getCurrentCore().load(loadingContext, url, options);
        return visualObject;
    }

    @Override
    public synchronized Control load(InputStream stream, URL url) throws Exception {
        return this.loadWithOptions(stream, url, Collections.EMPTY_MAP);
    }

    @Override
    public synchronized Control loadWithOptions(InputStream stream, URL base, Map<String, Object> options) throws Exception {
        Composite object = (Composite)options.get("XWT.Container");
        ILoadingContext loadingContext = object != null ? this.getLoadingContext(object) : this.getLoadingContext();
        options = this.prepareOptions(options);
        Control visualObject = this.getCurrentCore().load(loadingContext, stream, base, options);
        return visualObject;
    }

    @Override
    public IMetaclass[] getAllMetaclasses() {
        ArrayList<IMetaclass> collector = new ArrayList<IMetaclass>();
        int i = this.cores.size() - 1;
        while (i >= 0) {
            Core core = (Core)this.cores.get(i);
            Collection<IMetaclass> metaclasses = core.getAllMetaclasses("http://www.eclipse.org/xwt/presentation");
            collector.addAll(metaclasses);
            --i;
        }
        return collector.toArray(new IMetaclass[collector.size()]);
    }

    @Override
    public IMetaclass getMetaclass(String tagName, String ns) {
        int i = this.cores.size() - 1;
        while (i >= 0) {
            Core core = (Core)this.cores.get(i);
            IMetaclass metaclass = core.getMetaclass(this.getLoadingContext(), tagName, ns);
            if (metaclass != null) {
                return metaclass;
            }
            --i;
        }
        throw new XWTException("Type " + tagName + " is not found.");
    }

    @Override
    public IMetaclass registerMetaclass(Class<?> type) {
        return this.getCurrentCore().registerMetaclass(type, "http://www.eclipse.org/xwt/presentation");
    }

    @Override
    public void registerMetaclass(IMetaclass type) {
        this.getCurrentCore().registerMetaclass(type, "http://www.eclipse.org/xwt/presentation");
    }

    @Override
    public void registerMetaclassFactory(IMetaclassFactory metaclassFactory) {
        this.getCurrentCore().registerMetaclassFactory(metaclassFactory);
    }

    @Override
    public IConverter findConvertor(Class<?> source, Class<?> target) {
        source = ObjectUtil.normalizedType(source);
        target = ObjectUtil.normalizedType(target);
        int i = this.cores.size() - 1;
        while (i >= 0) {
            Core core = (Core)this.cores.get(i);
            IConverter converter = core.findConvertor(source, target);
            if (converter != null) {
                return converter;
            }
            --i;
        }
        return null;
    }

    @Override
    public void registerConvertor(IConverter converter) {
        this.getCurrentCore().registerConvertor(converter);
    }

    protected void registerConvertor(Class<?> converter, String methodName) {
        this.getCurrentCore().registerConvertor(converter, methodName);
    }

    protected void registerConvertor(Class<?> converterType, String methodName, boolean value) {
        this.getCurrentCore().registerConvertor(converterType, methodName, value);
    }

    protected void registerConvertor(ValueConvertorRegister convertorRegister, Class<?> source, Class<?> target, Class<?> converterType, String methodName, boolean value) {
        this.getCurrentCore().registerConvertor(convertorRegister, source, target, converterType, methodName, value);
    }

    protected IConverter loadConvertor(Class<?> converter, String methodName, boolean value) {
        return this.getCurrentCore().loadConvertor(converter, methodName, value);
    }

    @Override
    public void addTracking(Tracking tracking) {
        this.getCurrentCore().addTracking(tracking);
    }

    @Override
    public boolean isTracking(Tracking tracking) {
        return this.getCurrentCore().isTracking(tracking);
    }

    @Override
    public Set<Tracking> getTrackings() {
        return this.getCurrentCore().getTrackings();
    }

    @Override
    public void removeTracking(Tracking tracking) {
        this.getCurrentCore().removeTracking(tracking);
    }

    @Override
    public void registerCommand(String name, ICommand command) {
        this.getCurrentCore().registerCommand(name, command);
    }

    @Override
    public ICommand getCommand(String name) {
        int i = this.cores.size() - 1;
        while (i >= 0) {
            Core core = (Core)this.cores.get(i);
            ICommand command = core.getCommand(name);
            if (command != null) {
                return command;
            }
            --i;
        }
        return null;
    }

    @Override
    public Map<String, ICommand> getCommands() {
        HashMap<String, ICommand> collector = new HashMap<String, ICommand>();
        int i = this.cores.size() - 1;
        while (i >= 0) {
            Core core = (Core)this.cores.get(i);
            Map<String, ICommand> map = core.getCommands();
            if (map != null) {
                collector.putAll(map);
            }
            --i;
        }
        return collector;
    }

    @Override
    public void unregisterCommand(String name) {
        this.getCurrentCore().unregisterCommand(name);
    }

    @Override
    public void registerEventGroup(Class<?> type, IEventGroup eventGroup) {
        IMetaclass metaclass = this.getMetaclass(type);
        metaclass.addEventGroup(eventGroup);
    }

    @Override
    public void addDefaultStyle(IStyle style) {
        this.getCurrentCore().addDefaultStyle(style);
    }

    @Override
    public void removeDefaultStyle(IStyle style) {
        this.getCurrentCore().removeDefaultStyle(style);
    }

    @Override
    public Collection<IStyle> getDefaultStyles() {
        return this.getCurrentCore().getDefaultStyles();
    }

    @Override
    public void addDataProviderFactory(String name, IDataProviderFactory dataProviderFactory) {
        this.getCurrentCore().addDataProviderFactory(name, dataProviderFactory);
        this.registerMetaclass(dataProviderFactory.getType());
    }

    @Override
    public void removeDataProviderFactory(String name) {
        this.getCurrentCore().removeDataProviderFactory(name);
    }

    @Override
    public void removeDataProviderFactory(IDataProviderFactory dataProviderFactory) {
        this.getCurrentCore().removeDataProviderFactory(dataProviderFactory);
    }

    @Override
    public Collection<IDataProviderFactory> getDataProviderFactories() {
        ArrayList<IDataProviderFactory> collector = new ArrayList<IDataProviderFactory>();
        int i = this.cores.size() - 1;
        while (i >= 0) {
            Core core = (Core)this.cores.get(i);
            Collection<IDataProviderFactory> factories = core.getDataProviderFactories();
            if (factories != null) {
                collector.addAll(factories);
            }
            --i;
        }
        return collector;
    }

    @Override
    public IDataProvider findDataProvider(Object dataContext) {
        int i = this.cores.size() - 1;
        while (i >= 0) {
            Core core = (Core)this.cores.get(i);
            IDataProvider provider = core.findDataProvider(dataContext);
            if (provider != null) {
                return provider;
            }
            --i;
        }
        return null;
    }

    private void initialize() {
        IProperty property;
        this.cores = new Stack();
        Core core = new Core(new ResourceLoaderFactory(), this);
        this.cores.push(core);
        core.registerService(ValueConvertorRegister.class, new ValueConvertorRegister());
        core.registerMetaclassManager("http://www.eclipse.org/xwt/presentation", new MetaclassManager(null, null, this));
        core.registerMetaclass(new BindingMetaclass(this), "http://www.eclipse.org/xwt/presentation");
        core.registerMetaclass(new BindingMetaclass(MultiBinding.class, this), "http://www.eclipse.org/xwt/presentation");
        core.registerMetaclass(new TableEditorMetaclass(core.getMetaclass(ControlEditor.class, "http://www.eclipse.org/xwt/presentation"), this), "http://www.eclipse.org/xwt/presentation");
        this.registerConvertor(ObjectToString.instance);
        this.registerConvertor(DateToString.instance);
        this.registerConvertor(EnumToString.instance);
        this.registerConvertor(StringToInteger.instance);
        this.registerConvertor(StringToNumberConverter.class, "toBigDecimal");
        this.registerConvertor(StringToNumberConverter.class, "toByte", false);
        this.registerConvertor((IConverter)StringToNumberConverter.toLong((boolean)false));
        this.registerConvertor(StringToNumberConverter.class, "toShort", false);
        this.registerConvertor((IConverter)StringToNumberConverter.toFloat((boolean)false));
        this.registerConvertor((IConverter)StringToNumberConverter.toDouble((boolean)false));
        this.registerConvertor((IConverter)NumberToStringConverter.fromInteger((boolean)false));
        this.registerConvertor(NumberToStringConverter.class, "fromBigDecimal");
        this.registerConvertor(NumberToStringConverter.class, "fromByte", false);
        this.registerConvertor((IConverter)NumberToStringConverter.fromLong((boolean)false));
        this.registerConvertor(NumberToStringConverter.class, "fromShort", false);
        this.registerConvertor((IConverter)NumberToStringConverter.fromFloat((boolean)false));
        this.registerConvertor((IConverter)NumberToStringConverter.fromDouble((boolean)false));
        this.registerConvertor(StringToBoolean.instance);
        this.registerConvertor(ObjectToBoolean.instance);
        this.registerConvertor(SelectionToBoolean.instance);
        this.registerConvertor(CollectionToBoolean.instance);
        this.registerConvertor(CollectionToInteger.instance);
        this.registerConvertor(StringToIntArray.instance);
        this.registerConvertor(StringToDoubleArray.instance);
        this.registerConvertor(BindingToObject.instance);
        this.registerConvertor(StringToColor.instance);
        this.registerConvertor(StringToFont.instance);
        this.registerConvertor(StringToImage.instance);
        this.registerConvertor(StringToPoint.instance);
        this.registerConvertor(StringToRectangle.instance);
        this.registerConvertor(StringToURL.instance);
        this.registerConvertor(StringToType.instance);
        this.registerConvertor(StringToFormAttachment.instance);
        this.registerConvertor(StringToIValidationRule.instance);
        this.registerConvertor(StringToIValueConverter.instance);
        this.registerConvertor(ListToIObservableCollection.instance);
        this.registerConvertor(SetToIObservableCollection.instance);
        this.registerConvertor(ObjectToISelection.instance);
        this.registerConvertor(ListToSet.instance);
        this.registerConvertor(IStatusToString.instance);
        this.registerConvertor(IStatusToBoolean.instance);
        ValueConvertorRegister convertorRegister = (ValueConvertorRegister)core.getService(ValueConvertorRegister.class);
        convertorRegister.register(String.class, Float.TYPE, (IConverter)StringToNumberConverter.toFloat((boolean)true));
        convertorRegister.register(String.class, Integer.TYPE, StringToInteger.instance);
        this.registerConvertor(convertorRegister, String.class, Short.TYPE, StringToNumberConverter.class, "toShort", true);
        convertorRegister.register(String.class, Long.TYPE, (IConverter)StringToNumberConverter.toLong((boolean)true));
        this.registerConvertor(convertorRegister, String.class, Byte.TYPE, StringToNumberConverter.class, "toByte", true);
        convertorRegister.register(String.class, Boolean.TYPE, StringToBoolean.instance);
        convertorRegister.register(String.class, Double.TYPE, (IConverter)StringToNumberConverter.toDouble((boolean)true));
        convertorRegister.register(Float.TYPE, String.class, (IConverter)NumberToStringConverter.fromFloat((boolean)true));
        convertorRegister.register(Integer.TYPE, String.class, (IConverter)NumberToStringConverter.fromInteger((boolean)true));
        this.registerConvertor(convertorRegister, Short.TYPE, String.class, NumberToStringConverter.class, "fromShort", true);
        convertorRegister.register(Long.TYPE, String.class, (IConverter)NumberToStringConverter.fromLong((boolean)true));
        this.registerConvertor(convertorRegister, Byte.TYPE, String.class, NumberToStringConverter.class, "fromByte", true);
        convertorRegister.register(Double.TYPE, String.class, (IConverter)NumberToStringConverter.fromDouble((boolean)true));
        Class<Browser> type = Browser.class;
        IMetaclass browserMetaclass = this.registerMetaclass(type);
        browserMetaclass.addProperty(new DynamicProperty(type, String.class, "url"));
        IMetaclass buttonMetaclass = this.registerMetaclass(Button.class);
        buttonMetaclass.addProperty(new DataProperty("Command", "Command", ICommand.class));
        this.registerMetaclass(Canvas.class);
        this.registerMetaclass(Caret.class);
        this.registerMetaclass(Combo.class);
        this.registerMetaclass(Composite.class);
        this.registerMetaclass(CoolBar.class);
        this.registerMetaclass(CoolItem.class);
        this.registerMetaclass(DateTime.class);
        this.registerMetaclass(Decorations.class);
        this.registerMetaclass(ExpandBar.class);
        IMetaclass expandItemMetaclass = this.registerMetaclass(ExpandItem.class);
        expandItemMetaclass.findProperty("control").addSetPostAction(new ExpandItemHeightAction());
        this.registerMetaclass(Group.class);
        this.registerMetaclass(IME.class);
        this.registerMetaclass(Label.class);
        this.registerMetaclass(Link.class);
        this.registerMetaclass(Listener.class);
        this.registerMetaclass(List.class);
        this.registerMetaclass(Menu.class);
        IMetaclass menuItemMetaclass = this.registerMetaclass(MenuItem.class);
        menuItemMetaclass.addProperty(new DataProperty("Command", "Command", ICommand.class));
        this.registerMetaclass(MessageBox.class);
        this.registerMetaclass(ProgressBar.class);
        this.registerMetaclass(Sash.class);
        this.registerMetaclass(Scale.class);
        this.registerMetaclass(ScrollBar.class);
        this.registerMetaclass(Shell.class);
        this.registerMetaclass(Slider.class);
        this.registerMetaclass(Spinner.class);
        this.registerMetaclass(TabFolder.class);
        this.registerMetaclass(TabItem.class);
        this.registerMetaclass(Table.class);
        type = TableItem.class;
        IMetaclass metaclass = this.registerMetaclass(type);
        metaclass.addProperty(new TableItemProperty());
        metaclass.addProperty(new TableItemEditorProperty());
        metaclass.addProperty(new DynamicBeanProperty(TableItem.class, String[].class, "texts", "text"));
        this.registerMetaclass(TableItemProperty.Cell.class);
        this.registerMetaclass(ControlEditor.class);
        this.registerMetaclass(TableEditor.class);
        IMetaclass TableEditorMetaclass2 = core.getMetaclass(TableEditor.class, "http://www.eclipse.org/xwt/presentation");
        TableEditorMetaclass2.addProperty(new TableEditorDynamicProperty());
        type = TableColumn.class;
        metaclass = this.registerMetaclass(type);
        metaclass.addProperty(new TableColumnEditorProperty());
        this.registerMetaclass(Text.class);
        this.registerMetaclass(ToolBar.class);
        this.registerMetaclass(ToolItem.class);
        this.registerMetaclass(ToolTip.class);
        this.registerMetaclass(Tracker.class);
        this.registerMetaclass(Tray.class);
        this.registerMetaclass(Tree.class);
        this.registerMetaclass(TreeColumn.class);
        this.registerMetaclass(TreeItem.class);
        type = TreeItem.class;
        metaclass = this.registerMetaclass(type);
        metaclass.addProperty(new DynamicBeanProperty(TreeItem.class, String[].class, "texts", "text"));
        this.registerMetaclass(FillLayout.class);
        this.registerMetaclass(FormAttachment.class);
        this.registerMetaclass(FormData.class);
        this.registerMetaclass(FormLayout.class);
        this.registerMetaclass(GridData.class);
        this.registerMetaclass(GridLayout.class);
        this.registerMetaclass(RowData.class);
        this.registerMetaclass(RowLayout.class);
        this.registerMetaclass(StackLayout.class);
        this.registerMetaclass(CLabel.class);
        this.registerMetaclass(CCombo.class);
        this.registerMetaclass(CTabFolder.class);
        this.registerMetaclass(CTabItem.class);
        this.registerMetaclass(SashForm.class);
        this.registerMetaclass(StyledText.class);
        this.registerMetaclass(ScrolledComposite.class);
        this.registerMetaclass(TableTree.class);
        this.registerMetaclass(ViewForm.class);
        this.registerMetaclass(CBanner.class);
        this.registerMetaclass(TableCursor.class);
        type = Widget.class;
        metaclass = this.registerMetaclass(type);
        metaclass.addProperty(new DataProperty("DataContext", "DataContext"));
        metaclass.addProperty(new DataProperty("BindingContext", "DefaultDataBindingContext"));
        metaclass.addProperty(new DataProperty("Triggers", "Triggers", TriggerBase[].class));
        metaclass.addProperty(new StyleProperty());
        this.registerEventGroup(type, new RadioEventGroup(IEventConstants.KEY_GROUP));
        this.registerEventGroup(type, new RadioEventGroup(IEventConstants.MOUSE_GROUP));
        this.registerEventGroup(type, new RadioEventGroup(IEventConstants.MOUSE_MOVING_GROUP));
        this.registerEventGroup(type, new RadioEventGroup(IEventConstants.FOCUS_GROUP));
        this.registerEventGroup(type, new RadioEventGroup(IEventConstants.EXPAND_GROUP));
        this.registerEventGroup(type, new RadioEventGroup(IEventConstants.WINDOW_GROUP));
        this.registerEventGroup(type, new RadioEventGroup(IEventConstants.ACTIVATION_GROUP));
        this.registerEventGroup(type, new RadioEventGroup(IEventConstants.HARD_KEY));
        type = Viewer.class;
        metaclass = core.getMetaclass(type, "http://www.eclipse.org/xwt/presentation");
        if (metaclass != null) {
            property = metaclass.findProperty("Input");
            metaclass.addProperty(new InputBeanProperty(property));
            metaclass.addProperty(new DataProperty("DataContext", "DataContext"));
            metaclass.removeProperty("selection");
            metaclass.addProperty(new DataProperty("bindingPath", "_XWT.TableViewerColumnDisplayPath", String.class));
            metaclass.addProperty(new DataProperty("itemText", "_XWT.TableViewerColumnItemText", IBinding.class));
            metaclass.addProperty(new DataProperty("itemImage", "_XWT.TableViewerColumnItemImage", IBinding.class));
            metaclass.addProperty(new SingleSelectionBeanProperty("singleSelection"));
            metaclass.addProperty(new MultiSelectionBeanProperty("multiSelection"));
        }
        if ((metaclass = core.getMetaclass(type = AbstractListViewer.class, "http://www.eclipse.org/xwt/presentation")) != null) {
            metaclass.addInitializer(new JFaceInitializer());
        }
        if ((metaclass = core.getMetaclass(type = ColumnViewer.class, "http://www.eclipse.org/xwt/presentation")) != null) {
            metaclass.addProperty(new DynamicBeanProperty(type, String[].class, "columnProperties"));
            metaclass.addProperty(new ColumnViewerColumnsProperty());
            metaclass.addInitializer(new JFaceInitializer());
        }
        Class<?>[] classArray = JFacesHelper.getSupportedElements();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> cls = classArray[n2];
            this.registerMetaclass(cls);
            ++n2;
        }
        type = TableViewer.class;
        metaclass = core.getMetaclass(type, "http://www.eclipse.org/xwt/presentation");
        property = metaclass.findProperty("table");
        if (property instanceof AbstractProperty) {
            AbstractProperty abstractProperty = (AbstractProperty)property;
            abstractProperty.setValueAsParent(true);
        }
        core.registerMetaclass(new ComboBoxCellEditorMetaclass(core.getMetaclass(ComboBoxCellEditor.class.getSuperclass(), "http://www.eclipse.org/xwt/presentation"), this), "http://www.eclipse.org/xwt/presentation");
        type = TableViewerColumn.class;
        core.registerMetaclass(new TableViewerColumnMetaClass(core.getMetaclass(type.getSuperclass(), "http://www.eclipse.org/xwt/presentation"), this), "http://www.eclipse.org/xwt/presentation");
        metaclass = core.getMetaclass(type, "http://www.eclipse.org/xwt/presentation");
        metaclass.addProperty(new TableViewerColumnWidthProperty());
        metaclass.addProperty(new TableViewerColumnTextProperty());
        metaclass.addProperty(new TableViewerColumnImageProperty());
        metaclass.addProperty(new TableViewerColumnDynamicProperty("bindingPath", "_XWT.TableViewerColumnDisplayPath", String.class));
        metaclass.addProperty(new TableViewerColumnDynamicProperty("itemText", "_XWT.TableViewerColumnItemText", IBinding.class));
        metaclass.addProperty(new TableViewerColumnDynamicProperty("itemImage", "_XWT.TableViewerColumnItemImage", IBinding.class));
        this.registerMetaclass(DefaultCellModifier.class);
        this.registerMetaclass(ViewerFilter.class);
        this.registerMetaclass(BindingContext.class);
        this.registerMetaclass(ObjectDataProvider.class);
        this.registerMetaclass(Style.class);
        this.registerMetaclass(Setter.class);
        this.registerMetaclass(Trigger.class);
        this.registerMetaclass(MultiTrigger.class);
        this.registerMetaclass(EventTrigger.class);
        this.registerMetaclass(DataTrigger.class);
        this.registerMetaclass(MultiDataTrigger.class);
        this.registerMetaclass(Condition.class);
        this.registerMetaclass(Storyboard.class);
        this.registerMetaclass(BeginStoryboard.class);
        this.registerMetaclass(StopStoryboard.class);
        this.registerMetaclass(PauseStoryboard.class);
        this.registerMetaclass(ResumeStoryboard.class);
        this.registerMetaclass(IntAnimation.class);
        this.registerMetaclass(DoubleAnimation.class);
        this.registerMetaclass(ColorAnimation.class);
        this.registerMetaclass(PointAnimation.class);
        this.registerMetaclass(RectangleAnimation.class);
        this.registerMetaclass(SizeAnimation.class);
        this.registerConvertor(StringToDuration.instance);
        this.registerConvertor(StringToRepeatBehavior.instance);
        this.registerMetaclass(CollectionViewSource.class);
        this.registerMetaclass(ObservableListContentProvider.class);
        this.registerMetaclass(ObservableSetContentProvider.class);
        this.registerMetaclass(ObservableTreeContentProvider.class);
    }

    @Override
    public ILoadingContext findLoadingContext(Object container) {
        int i = this.cores.size() - 1;
        while (i >= 0) {
            Core core = (Core)this.cores.get(i);
            ILoadingContext context = core.findLoadingContext(container);
            if (context != null) {
                return context;
            }
            --i;
        }
        return null;
    }

    @Override
    public ILoadingContext getLoadingContext(Composite object) {
        return this.findLoadingContext(object);
    }

    @Override
    public ILoadingContext getLoadingContext() {
        return this.getCurrentCore().getLoadingContext();
    }

    @Override
    public void setLoadingContext(ILoadingContext loadingContext) {
        this.getCurrentCore().setLoadingContext(loadingContext);
    }

    @Override
    public ILanguageSupport getLanguageSupport() {
        int i = this.cores.size() - 1;
        while (i >= 0) {
            Core core = (Core)this.cores.get(i);
            ILanguageSupport support = core.getLanguageSupport();
            if (support != null) {
                return support;
            }
            --i;
        }
        return null;
    }

    @Override
    public void setLanguageSupport(ILanguageSupport languageSupport) {
        this.getCurrentCore().setLanguageSupport(languageSupport);
    }
}

