/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.MoveFilesAndFoldersOperation;
import org.eclipse.ui.actions.ReadOnlyStateChecker;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.ide.dialogs.ImportTypeDialog;
import org.eclipse.ui.internal.views.navigator.ResourceNavigatorMessages;
import org.eclipse.ui.part.PluginDropAdapter;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class NavigatorDropAdapter
extends PluginDropAdapter
implements IOverwriteQuery {
    private boolean alwaysOverwrite = false;
    private int lastValidOperation = 0;
    static /* synthetic */ Class class$0;

    public NavigatorDropAdapter(StructuredViewer viewer) {
        super(viewer);
    }

    public void dragEnter(DropTargetEvent event) {
        if (FileTransfer.getInstance().isSupportedType(event.currentDataType) && event.detail == 16) {
            event.detail = 1;
        }
        super.dragEnter(event);
    }

    private IStatus error(String message) {
        return this.error(message, null);
    }

    private IStatus error(String message, Throwable exception) {
        return new Status(4, "org.eclipse.ui", 0, message, exception);
    }

    private IContainer getActualTarget(IResource mouseTarget) {
        if (this.getFeedbackEnabled() && (this.getCurrentLocation() == 1 || this.getCurrentLocation() == 2)) {
            return mouseTarget.getParent();
        }
        if (mouseTarget.getType() == 1) {
            return mouseTarget.getParent();
        }
        return (IContainer)mouseTarget;
    }

    private Display getDisplay() {
        return this.getViewer().getControl().getDisplay();
    }

    private IResource[] getSelectedResources() {
        ArrayList selectedResources = new ArrayList();
        ISelection selection = LocalSelectionTransfer.getInstance().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            Iterator i = ssel.iterator();
            while (i.hasNext()) {
                IResource r;
                Object o = i.next();
                if (o instanceof IResource) {
                    selectedResources.add(o);
                    continue;
                }
                if (!(o instanceof IAdaptable)) continue;
                IAdaptable a = (IAdaptable)o;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((r = (IResource)a.getAdapter((Class)clazz)) == null) continue;
                selectedResources.add(r);
            }
        }
        return selectedResources.toArray(new IResource[selectedResources.size()]);
    }

    private Shell getShell() {
        return this.getViewer().getControl().getShell();
    }

    private IStatus info(String message) {
        return new Status(1, "org.eclipse.ui", 0, message, null);
    }

    private void mergeStatus(MultiStatus status, IStatus toMerge) {
        if (!toMerge.isOK()) {
            status.merge(toMerge);
        }
    }

    private IStatus ok() {
        return new Status(0, "org.eclipse.ui", 0, ResourceNavigatorMessages.DropAdapter_ok, null);
    }

    private void openError(IStatus status) {
        if (status == null) {
            return;
        }
        String genericTitle = ResourceNavigatorMessages.DropAdapter_title;
        int codes = 6;
        if (!status.isMultiStatus()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)genericTitle, null, (IStatus)status, (int)codes);
            return;
        }
        IStatus[] children = status.getChildren();
        if (children.length == 1) {
            ErrorDialog.openError((Shell)this.getShell(), (String)status.getMessage(), null, (IStatus)children[0], (int)codes);
            return;
        }
        ErrorDialog.openError((Shell)this.getShell(), (String)genericTitle, null, (IStatus)status, (int)codes);
    }

    public boolean performDrop(Object data) {
        this.alwaysOverwrite = false;
        if (this.getCurrentTarget() == null || data == null) {
            return false;
        }
        boolean result = false;
        IStatus status = null;
        IResource[] resources = null;
        TransferData currentTransfer = this.getCurrentTransfer();
        if (LocalSelectionTransfer.getInstance().isSupportedType(currentTransfer)) {
            resources = this.getSelectedResources();
        } else if (ResourceTransfer.getInstance().isSupportedType(currentTransfer)) {
            resources = (IResource[])data;
        } else if (FileTransfer.getInstance().isSupportedType(currentTransfer)) {
            status = this.performFileDrop(data);
            result = status.isOK();
        } else {
            result = NavigatorDropAdapter.super.performDrop(data);
        }
        if (resources != null && resources.length > 0) {
            status = this.getCurrentOperation() == 1 || this.getCurrentOperation() == 4 ? this.performResourceCopy(this.getShell(), resources) : this.performResourceMove(resources);
        }
        this.openError(status);
        return result;
    }

    private IStatus performFileDrop(Object data) {
        MultiStatus problems = new MultiStatus("org.eclipse.ui", 0, ResourceNavigatorMessages.DropAdapter_problemImporting, null);
        this.mergeStatus(problems, this.validateTarget(this.getCurrentTarget(), this.getCurrentTransfer()));
        final IContainer target = this.getActualTarget((IResource)this.getCurrentTarget());
        final String[] names = (String[])data;
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                NavigatorDropAdapter.this.getShell().forceActive();
                CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(NavigatorDropAdapter.this.getShell());
                int mask = 6;
                if (!target.isGroup() && NavigatorDropAdapter.this.getCurrentOperation() != 4) {
                    mask |= 1;
                }
                ImportTypeDialog dialog = new ImportTypeDialog(NavigatorDropAdapter.this.getShell(), mask);
                dialog.setProject(target.getProject());
                int type = dialog.open() == 0 ? dialog.getSelection() : 0;
                switch (type) {
                    case 1: {
                        operation.copyFiles(names, target);
                        break;
                    }
                    case 2: {
                        if (dialog.getVariable() != null) {
                            operation.setRelativeVariable(dialog.getVariable());
                        }
                        operation.createGroupAndLinks(names, target);
                        break;
                    }
                    case 4: {
                        if (dialog.getVariable() != null) {
                            operation.setRelativeVariable(dialog.getVariable());
                        }
                        operation.linkFiles(names, target);
                        break;
                    }
                }
            }
        });
        return problems;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IStatus performResourceCopy(Shell shell, IResource[] sources) {
        MultiStatus problems = new MultiStatus("org.eclipse.ui", 1, ResourceNavigatorMessages.DropAdapter_problemsMoving, null);
        this.mergeStatus(problems, this.validateTarget(this.getCurrentTarget(), this.getCurrentTransfer()));
        IContainer target = this.getActualTarget((IResource)this.getCurrentTarget());
        boolean shouldLinkAutomatically = false;
        if (target.isGroup()) {
            shouldLinkAutomatically = true;
            int i = 0;
            while (i < sources.length) {
                if (sources[0].getType() != 1) {
                    shouldLinkAutomatically = false;
                    break;
                }
                ++i;
            }
        }
        CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(shell);
        if (shouldLinkAutomatically) {
            operation.setCreateLinks(true);
            operation.copyResources(sources, target);
            return problems;
        } else {
            boolean allSourceAreLinksOrGroups = true;
            int i = 0;
            while (i < sources.length) {
                if (!sources[0].isGroup() && !sources[0].isLinked()) {
                    allSourceAreLinksOrGroups = false;
                    break;
                }
                ++i;
            }
            if (!allSourceAreLinksOrGroups) {
                int mask = 6;
                if (!target.isGroup() && this.getCurrentOperation() != 4) {
                    mask |= 1;
                }
                ImportTypeDialog dialog = new ImportTypeDialog(this.getShell(), mask);
                dialog.setProject(target.getProject());
                if (dialog.open() != 0) return problems;
                if (dialog.getSelection() == 2) {
                    operation.setCreateGroups(true);
                }
                if (dialog.getSelection() == 4) {
                    operation.setCreateLinks(true);
                }
                if (dialog.getVariable() != null) {
                    operation.setRelativeVariable(dialog.getVariable());
                }
                operation.copyResources(sources, target);
                return problems;
            } else {
                operation.copyResources(sources, target);
            }
        }
        return problems;
    }

    private IStatus performResourceMove(IResource[] sources) {
        MultiStatus problems = new MultiStatus("org.eclipse.ui", 1, ResourceNavigatorMessages.DropAdapter_problemsMoving, null);
        this.mergeStatus(problems, this.validateTarget(this.getCurrentTarget(), this.getCurrentTransfer()));
        IContainer target = this.getActualTarget((IResource)this.getCurrentTarget());
        boolean shouldLinkAutomatically = false;
        if (target.isGroup()) {
            shouldLinkAutomatically = true;
            int i = 0;
            while (i < sources.length) {
                if (sources[0].isGroup() || sources[0].isLinked()) {
                    shouldLinkAutomatically = false;
                    break;
                }
                ++i;
            }
        }
        if (shouldLinkAutomatically) {
            CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(this.getShell());
            operation.setCreateLinks(true);
            operation.copyResources(sources, target);
        } else {
            ReadOnlyStateChecker checker = new ReadOnlyStateChecker(this.getShell(), ResourceNavigatorMessages.MoveResourceAction_title, ResourceNavigatorMessages.MoveResourceAction_checkMoveMessage);
            sources = checker.checkReadOnlyResources(sources);
            MoveFilesAndFoldersOperation operation = new MoveFilesAndFoldersOperation(this.getShell());
            operation.copyResources(sources, target);
        }
        return problems;
    }

    public String queryOverwrite(String pathString) {
        if (this.alwaysOverwrite) {
            return "ALL";
        }
        final String[] returnCode = new String[]{"CANCEL"};
        final String msg = NLS.bind((String)ResourceNavigatorMessages.DropAdapter_overwriteQuery, (Object)pathString);
        final String[] options = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
        this.getDisplay().syncExec(new Runnable(){

            public void run() {
                MessageDialog dialog = new MessageDialog(NavigatorDropAdapter.this.getShell(), ResourceNavigatorMessages.DropAdapter_question, null, msg, 3, options, 0);
                dialog.open();
                int returnVal = dialog.getReturnCode();
                String[] returnCodes = new String[]{"YES", "ALL", "NO", "CANCEL"};
                returnCode[0] = returnVal < 0 ? "CANCEL" : returnCodes[returnVal];
            }
        });
        if (returnCode[0] == "ALL") {
            this.alwaysOverwrite = true;
        }
        return returnCode[0];
    }

    public boolean validateDrop(Object target, int dragOperation, TransferData transferType) {
        if (dragOperation != 0) {
            this.lastValidOperation = dragOperation;
        }
        if (FileTransfer.getInstance().isSupportedType(transferType) && this.lastValidOperation != 1 && this.lastValidOperation != 4) {
            return false;
        }
        if (super.validateDrop(target, dragOperation, transferType)) {
            return true;
        }
        return this.validateTarget(target, transferType).isOK();
    }

    private IStatus validateTarget(Object target, TransferData transferType) {
        if (!(target instanceof IResource)) {
            return this.info(ResourceNavigatorMessages.DropAdapter_targetMustBeResource);
        }
        IResource resource = (IResource)target;
        if (!resource.isAccessible()) {
            return this.error(ResourceNavigatorMessages.DropAdapter_canNotDropIntoClosedProject);
        }
        IContainer destination = this.getActualTarget(resource);
        if (destination.getType() == 8) {
            return this.error(ResourceNavigatorMessages.DropAdapter_resourcesCanNotBeSiblings);
        }
        String message = null;
        if (LocalSelectionTransfer.getInstance().isSupportedType(transferType)) {
            IResource[] selectedResources = this.getSelectedResources();
            if (selectedResources.length == 0) {
                message = ResourceNavigatorMessages.DropAdapter_dropOperationErrorOther;
            } else if (this.lastValidOperation == 1 || this.lastValidOperation == 4) {
                CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(this.getShell());
                if (operation.validateDestination(destination, selectedResources) != null) {
                    operation.setCreateGroups(true);
                    message = operation.validateDestination(destination, selectedResources);
                }
            } else {
                MoveFilesAndFoldersOperation operation = new MoveFilesAndFoldersOperation(this.getShell());
                if (((CopyFilesAndFoldersOperation)operation).validateDestination(destination, selectedResources) != null) {
                    operation.setCreateGroups(true);
                    message = ((CopyFilesAndFoldersOperation)operation).validateDestination(destination, selectedResources);
                    if (message == null) {
                        this.lastValidOperation = 1;
                    }
                }
            }
        } else if (FileTransfer.getInstance().isSupportedType(transferType)) {
            String[] sourceNames = (String[])FileTransfer.getInstance().nativeToJava(transferType);
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            CopyFilesAndFoldersOperation copyOperation = new CopyFilesAndFoldersOperation(this.getShell());
            message = copyOperation.validateImportDestination(destination, sourceNames);
        }
        if (message != null) {
            return this.error(message);
        }
        return this.ok();
    }
}

