/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.Collections;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.OpenFileAction;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class OpenResourceDialog
extends FilteredResourcesSelectionDialog {
    private Button openWithButton;

    public OpenResourceDialog(Shell parentShell, IContainer container, int typesMask) {
        super(parentShell, true, container, typesMask);
        this.setTitle(IDEWorkbenchMessages.OpenResourceDialog_title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parentShell, "org.eclipse.ui.ide.open_resource_dialog");
    }

    protected void fillContextMenu(IMenuManager menuManager) {
        super.fillContextMenu(menuManager);
        StructuredSelection selectedItems = this.getSelectedItems();
        if (selectedItems.isEmpty()) {
            return;
        }
        IWorkbenchPage activePage = this.getActivePage();
        if (activePage == null) {
            return;
        }
        OpenFileAction openFileAction = new OpenFileAction(activePage){

            public void run() {
                OpenResourceDialog.this.okPressed();
            }
        };
        openFileAction.selectionChanged((IStructuredSelection)selectedItems);
        if (!openFileAction.isEnabled()) {
            return;
        }
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)openFileAction);
        IAdaptable selectedAdaptable = this.getSelectedAdaptable();
        if (selectedAdaptable == null) {
            return;
        }
        MenuManager subMenu = new MenuManager(IDEWorkbenchMessages.OpenResourceDialog_openWithMenu_label);
        OpenWithMenu openWithMenu = new OpenWithMenu(activePage, selectedAdaptable){

            protected void openEditor(IEditorDescriptor editorDescriptor, boolean openUsingDescriptor) {
                OpenResourceDialog.this.computeResult();
                OpenResourceDialog.this.setResult(Collections.EMPTY_LIST);
                OpenResourceDialog.this.close();
                super.openEditor(editorDescriptor, openUsingDescriptor);
            }
        };
        subMenu.add((IContributionItem)openWithMenu);
        menuManager.add((IContributionItem)subMenu);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        int buttonWidth;
        GridLayout parentLayout = (GridLayout)parent.getLayout();
        ++parentLayout.numColumns;
        parentLayout.makeColumnsEqualWidth = false;
        final Composite openComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        openComposite.setLayout((Layout)layout);
        Button okButton = this.createButton(openComposite, 0, IDEWorkbenchMessages.OpenResourceDialog_openButton_text, true);
        ++((GridLayout)openComposite.getLayout()).numColumns;
        this.openWithButton = new Button(openComposite, 8);
        this.openWithButton.setToolTipText(IDEWorkbenchMessages.OpenResourceDialog_openWithButton_toolTip);
        this.openWithButton.setImage(WorkbenchImages.getImage((String)"IMG_LCL_BUTTON_MENU"));
        GridData data = new GridData(0x1000000, 4, false, true);
        this.openWithButton.setLayoutData((Object)data);
        this.openWithButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                OpenResourceDialog.this.showOpenWithMenu(openComposite);
            }
        });
        this.openWithButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenResourceDialog.this.showOpenWithMenu(openComposite);
            }
        });
        Button cancelButton = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        GridData cancelLayoutData = (GridData)cancelButton.getLayoutData();
        GridData okLayoutData = (GridData)okButton.getLayoutData();
        cancelLayoutData.widthHint = buttonWidth = Math.max(cancelLayoutData.widthHint, okLayoutData.widthHint);
        okLayoutData.widthHint = buttonWidth;
        if (openComposite.getDisplay().getDismissalAlignment() == 131072) {
            openComposite.moveBelow(null);
            if (Util.isCarbon()) {
                okLayoutData.horizontalIndent = -10;
            }
        }
    }

    protected void initializeBounds() {
        super.initializeBounds();
        if (this.openWithButton.getDisplay().getDismissalAlignment() == 131072 && !Util.isMac()) {
            this.openWithButton.moveBelow(null);
            this.openWithButton.getParent().layout();
        }
    }

    protected void updateButtonsEnableState(IStatus status) {
        super.updateButtonsEnableState(status);
        if (this.openWithButton != null && !this.openWithButton.isDisposed()) {
            this.openWithButton.setEnabled(!status.matches(4) && this.getSelectedItems().size() == 1);
        }
    }

    private IAdaptable getSelectedAdaptable() {
        StructuredSelection s = this.getSelectedItems();
        if (s.size() != 1) {
            return null;
        }
        Object selectedElement = s.getFirstElement();
        if (selectedElement instanceof IAdaptable) {
            return (IAdaptable)selectedElement;
        }
        return null;
    }

    private IWorkbenchPage getActivePage() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        return activeWorkbenchWindow.getActivePage();
    }

    private void showOpenWithMenu(Composite openComposite) {
        IWorkbenchPage activePage = this.getActivePage();
        if (activePage == null) {
            return;
        }
        IAdaptable selectedAdaptable = this.getSelectedAdaptable();
        if (selectedAdaptable == null) {
            return;
        }
        OpenWithMenu openWithMenu = new OpenWithMenu(activePage, selectedAdaptable){

            protected void openEditor(IEditorDescriptor editorDescriptor, boolean openUsingDescriptor) {
                OpenResourceDialog.this.computeResult();
                OpenResourceDialog.this.setResult(Collections.EMPTY_LIST);
                OpenResourceDialog.this.close();
                super.openEditor(editorDescriptor, openUsingDescriptor);
            }
        };
        Menu menu = new Menu((Control)openComposite.getParent());
        Composite c = openComposite;
        Point p = c.getLocation();
        p.y += c.getSize().y;
        p = c.getParent().toDisplay(p);
        menu.setLocation(p);
        openWithMenu.fill(menu, -1);
        menu.setVisible(true);
    }
}

