/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.services.internal.context;

import junit.framework.TestCase;
import org.eclipse.e4.core.services.context.EclipseContextFactory;
import org.eclipse.e4.core.services.context.IContextFunction;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.context.spi.ContextFunction;
import org.eclipse.e4.core.services.internal.context.AddContextFunction;
import org.eclipse.e4.core.services.internal.context.EclipseContext;
import org.eclipse.e4.core.services.internal.context.TestHelper;

public class EclipseContextTest
extends TestCase {
    private IEclipseContext context;
    private IEclipseContext parentContext;
    private int runCounter;

    protected void setUp() throws Exception {
        super.setUp();
        this.parentContext = EclipseContextFactory.create();
        this.parentContext.set("debugString", (Object)(String.valueOf(this.getName()) + "-parent"));
        this.context = EclipseContextFactory.create((IEclipseContext)this.parentContext, null);
        this.context.set("debugString", (Object)this.getName());
        this.runCounter = 0;
    }

    public void testContainsKey() {
        EclipseContextTest.assertFalse((String)"1.0", (boolean)this.context.containsKey("function"));
        EclipseContextTest.assertFalse((String)"1.1", (boolean)this.context.containsKey("separator"));
        this.context.set("function", (Object)new ConcatFunction());
        this.context.set("separator", (Object)",");
        EclipseContextTest.assertTrue((String)"2.0", (boolean)this.context.containsKey("function"));
        EclipseContextTest.assertTrue((String)"2.1", (boolean)this.context.containsKey("separator"));
        this.context.set("separator", null);
        EclipseContextTest.assertTrue((String)"3.0", (boolean)this.context.containsKey("separator"));
        this.context.remove("separator");
        EclipseContextTest.assertFalse((String)"4.0", (boolean)this.context.containsKey("separator"));
    }

    public void testFunctions() {
        this.context.set("function", (Object)new ConcatFunction());
        this.context.set("separator", (Object)",");
        EclipseContextTest.assertEquals((Object)"x", (Object)this.context.get("function", (Object[])new String[]{"x"}));
        EclipseContextTest.assertEquals((Object)"x,y", (Object)this.context.get("function", (Object[])new String[]{"x", "y"}));
    }

    public void testGet() {
        EclipseContextTest.assertNull((Object)this.context.get("foo"));
        this.context.set("foo", (Object)"bar");
        EclipseContextTest.assertEquals((Object)"bar", (Object)this.context.get("foo"));
        EclipseContextTest.assertNull((Object)this.parentContext.get("foo"));
        this.context.remove("foo");
        EclipseContextTest.assertNull((Object)this.context.get("foo"));
        this.parentContext.set("foo", (Object)"bar");
        EclipseContextTest.assertEquals((Object)"bar", (Object)this.context.get("foo"));
        this.context.set("foo", (Object)new ComputedValueBar());
        EclipseContextTest.assertNull((Object)this.context.get("foo"));
        this.context.set("bar", (Object)"baz");
        EclipseContextTest.assertEquals((Object)"baz", (Object)this.context.get("foo"));
    }

    public void testGetLocal() {
        EclipseContextTest.assertNull((Object)this.context.getLocal("foo"));
        this.context.set("foo", (Object)"bar");
        EclipseContextTest.assertEquals((Object)"bar", (Object)this.context.getLocal("foo"));
        EclipseContextTest.assertNull((Object)this.parentContext.getLocal("foo"));
        this.context.remove("foo");
        EclipseContextTest.assertNull((Object)this.context.getLocal("foo"));
        this.parentContext.set("foo", (Object)"bar");
        EclipseContextTest.assertNull((Object)this.context.getLocal("foo"));
        this.context.set("foo", (Object)new ComputedValueBar());
        EclipseContextTest.assertNull((Object)this.context.getLocal("foo"));
        this.context.set("bar", (Object)"baz");
        EclipseContextTest.assertEquals((Object)"baz", (Object)this.context.getLocal("foo"));
    }

    public void testContextFunctionInParent() {
        IEclipseContext parent = EclipseContextFactory.create();
        IEclipseContext child = EclipseContextFactory.create((IEclipseContext)parent, null);
        parent.set("sum", (Object)new AddContextFunction());
        parent.set("x", (Object)3);
        parent.set("y", (Object)3);
        child.set("x", (Object)1);
        child.set("y", (Object)1);
        EclipseContextTest.assertEquals((int)6, (int)((Integer)parent.get("sum")));
        EclipseContextTest.assertEquals((int)2, (int)((Integer)child.get("sum")));
        child.set("x", (Object)5);
        EclipseContextTest.assertEquals((int)6, (int)((Integer)parent.get("sum")));
        EclipseContextTest.assertEquals((int)6, (int)((Integer)child.get("sum")));
        child.remove("x");
        EclipseContextTest.assertEquals((int)6, (int)((Integer)parent.get("sum")));
        EclipseContextTest.assertEquals((int)4, (int)((Integer)child.get("sum")));
        parent.set("x", (Object)10);
        EclipseContextTest.assertEquals((int)13, (int)((Integer)parent.get("sum")));
        EclipseContextTest.assertEquals((int)11, (int)((Integer)child.get("sum")));
    }

    public void testRunAndTrack() {
        final Object[] value = new Object[1];
        this.context.runAndTrack(new Runnable(){

            public void run() {
                EclipseContextTest eclipseContextTest = EclipseContextTest.this;
                eclipseContextTest.runCounter = eclipseContextTest.runCounter + 1;
                value[0] = EclipseContextTest.this.context.get("foo");
            }
        });
        EclipseContextTest.assertEquals((int)1, (int)this.runCounter);
        EclipseContextTest.assertEquals(null, (Object)value[0]);
        this.context.set("foo", (Object)"bar");
        EclipseContextTest.assertEquals((int)2, (int)this.runCounter);
        EclipseContextTest.assertEquals((Object)"bar", (Object)value[0]);
        this.context.remove("foo");
        EclipseContextTest.assertEquals((int)3, (int)this.runCounter);
        EclipseContextTest.assertEquals(null, (Object)value[0]);
        this.context.set("foo", (Object)new IContextFunction(){

            public Object compute(IEclipseContext context, Object[] arguments) {
                return context.get("bar");
            }
        });
        EclipseContextTest.assertEquals((int)4, (int)this.runCounter);
        EclipseContextTest.assertEquals(null, (Object)value[0]);
        this.context.set("bar", (Object)"baz");
        EclipseContextTest.assertEquals((int)5, (int)this.runCounter);
        EclipseContextTest.assertEquals((Object)"baz", (Object)value[0]);
        this.context.set("bar", (Object)"baf");
        EclipseContextTest.assertEquals((int)6, (int)this.runCounter);
        EclipseContextTest.assertEquals((Object)"baf", (Object)value[0]);
        this.context.remove("bar");
        EclipseContextTest.assertEquals((int)7, (int)this.runCounter);
        EclipseContextTest.assertEquals(null, (Object)value[0]);
        this.parentContext.set("bar", (Object)"bam");
        EclipseContextTest.assertEquals((int)8, (int)this.runCounter);
        EclipseContextTest.assertEquals((Object)"bam", (Object)value[0]);
    }

    public void testRunAndTrackMultipleValues() {
        IEclipseContext parent = EclipseContextFactory.create();
        final IEclipseContext child = EclipseContextFactory.create((IEclipseContext)parent, null);
        parent.set("parentValue", (Object)"x");
        parent.set("debugString", (Object)"ParentContext");
        child.set("childValue", (Object)"x");
        child.set("debugString", (Object)"ChildContext");
        Runnable runnable = new Runnable(){

            public void run() {
                EclipseContextTest eclipseContextTest = EclipseContextTest.this;
                eclipseContextTest.runCounter = eclipseContextTest.runCounter + 1;
                if (EclipseContextTest.this.runCounter < 2) {
                    child.get("childValue");
                }
                if (EclipseContextTest.this.runCounter < 3) {
                    child.get("parentValue");
                }
            }
        };
        child.runAndTrack(runnable);
        EclipseContextTest.assertEquals((int)1, (int)this.runCounter);
        child.set("childValue", (Object)"z");
        EclipseContextTest.assertEquals((int)2, (int)this.runCounter);
        parent.set("parentValue", (Object)"z");
        EclipseContextTest.assertEquals((int)3, (int)this.runCounter);
        child.set("childValue", (Object)"y");
        EclipseContextTest.assertEquals((int)3, (int)this.runCounter);
        parent.set("parentValue", (Object)"y");
        EclipseContextTest.assertEquals((int)3, (int)this.runCounter);
        ((EclipseContext)child).removeRunAndTrack(runnable);
        EclipseContextTest.assertTrue((boolean)TestHelper.getListeners((IEclipseContext)child).isEmpty());
        EclipseContextTest.assertTrue((boolean)TestHelper.getListeners((IEclipseContext)parent).isEmpty());
    }

    private static class ComputedValueBar
    extends ContextFunction {
        private ComputedValueBar() {
        }

        public Object compute(IEclipseContext context, Object[] arguments) {
            return context.get("bar");
        }
    }

    private static class ConcatFunction
    implements IContextFunction {
        private ConcatFunction() {
        }

        public Object compute(IEclipseContext context, Object[] arguments) {
            String separator = (String)context.get("separator");
            StringBuffer result = new StringBuffer();
            int i = 0;
            while (i < arguments.length) {
                if (i > 0) {
                    result.append(separator);
                }
                result.append(arguments[i]);
                ++i;
            }
            return result.toString();
        }
    }
}

