/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.services.internal.context;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.e4.core.services.IDisposable;
import org.eclipse.e4.core.services.annotations.In;
import org.eclipse.e4.core.services.annotations.PreDestroy;
import org.eclipse.e4.core.services.context.EclipseContextFactory;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.context.spi.ContextInjectionFactory;

public class ContextInjectionDisposeTest
extends TestCase {
    public static Test suite() {
        return new TestSuite(ContextInjectionDisposeTest.class);
    }

    public ContextInjectionDisposeTest() {
    }

    public ContextInjectionDisposeTest(String name) {
        super(name);
    }

    public void testContextDisposedOneArg() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set("field", (Object)"hello");
        class Injected {
            boolean contextDisposedInvoked = false;
            boolean disposeInvoked = false;
            @In
            private String field;

            Injected() {
            }

            public void contextDisposed(IEclipseContext context) {
                this.contextDisposedInvoked = true;
            }

            public void dispose() {
                this.disposeInvoked = true;
            }
        }
        Injected object = new Injected();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
        ((IDisposable)context).dispose();
        ContextInjectionDisposeTest.assertTrue((boolean)object.contextDisposedInvoked);
        ContextInjectionDisposeTest.assertFalse((boolean)object.disposeInvoked);
    }

    public void testContextDisposedTwoArgs() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set("field", (Object)"hello");
        class Injected {
            boolean contextDisposedInvoked = false;
            boolean disposeInvoked = false;
            @In
            private String field;

            Injected() {
            }

            public void contextDisposed(IEclipseContext context, String arg2) {
                this.contextDisposedInvoked = true;
            }

            public void dispose() {
                this.disposeInvoked = true;
            }
        }
        Injected object = new Injected();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
        ((IDisposable)context).dispose();
        ContextInjectionDisposeTest.assertFalse((boolean)object.contextDisposedInvoked);
        ContextInjectionDisposeTest.assertTrue((boolean)object.disposeInvoked);
    }

    public void testContextDisposedZeroArgs() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set("field", (Object)"hello");
        class Injected {
            boolean contextDisposedInvoked = false;
            boolean disposeInvoked = false;
            @In
            private String field;

            Injected() {
            }

            public void contextDisposed() {
                this.contextDisposedInvoked = true;
            }

            public void dispose() {
                this.disposeInvoked = true;
            }
        }
        Injected object = new Injected();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
        ((IDisposable)context).dispose();
        ContextInjectionDisposeTest.assertTrue((boolean)object.contextDisposedInvoked);
        ContextInjectionDisposeTest.assertFalse((boolean)object.disposeInvoked);
    }

    public void testDisposeContext() {
        IEclipseContext context = EclipseContextFactory.create();
        Object fieldValue = new Object();
        Object methodValue = new Object();
        context.set("injectedField", fieldValue);
        context.set("injectedMethod", methodValue);
        class Injected {
            boolean contextDisposedInvoked = false;
            boolean disposeInvoked = false;
            @In
            Object injectedField;
            Object methodValue;

            Injected() {
            }

            @PreDestroy
            public void destroy() {
                this.injectedField = null;
                this.methodValue = null;
            }

            public void dispose() {
                this.disposeInvoked = true;
            }

            public void contextDisposed(IEclipseContext context) {
                this.contextDisposedInvoked = true;
            }

            @In
            public void setInjectedMethod(Object arg) {
                this.methodValue = arg;
            }
        }
        Injected object = new Injected();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
        ((IDisposable)context).dispose();
        ContextInjectionDisposeTest.assertNull((Object)object.injectedField);
        ContextInjectionDisposeTest.assertNull((Object)object.methodValue);
        ContextInjectionDisposeTest.assertFalse((boolean)object.disposeInvoked);
        ContextInjectionDisposeTest.assertFalse((boolean)object.contextDisposedInvoked);
    }
}

