/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.policies.layout;

import java.util.List;
import org.eclipse.e4.xwt.tools.ui.designer.policies.layout.GridLayoutEditPolicy;
import org.eclipse.e4.xwt.tools.ui.designer.policies.layout.grid.GridSpanHandle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.ResizeTracker;

public class NonResizableSpannableEditPolicy
extends NonResizableEditPolicy {
    protected GridLayoutEditPolicy layoutEditPolicy;

    public NonResizableSpannableEditPolicy(GridLayoutEditPolicy layoutEditPolicy) {
        this.layoutEditPolicy = layoutEditPolicy;
    }

    protected List createSelectionHandles() {
        List nonResizeHandles = super.createSelectionHandles();
        if (this.getHost().getSelected() == 2) {
            if (!this.layoutEditPolicy.getHelper().isRightToLeft()) {
                nonResizeHandles.add(this.createHandle((GraphicalEditPart)this.getHost(), 16));
            } else {
                nonResizeHandles.add(this.createHandle((GraphicalEditPart)this.getHost(), 8));
            }
            nonResizeHandles.add(this.createHandle((GraphicalEditPart)this.getHost(), 4));
        }
        return nonResizeHandles;
    }

    private Handle createHandle(GraphicalEditPart owner, int direction) {
        GridSpanHandle handle = new GridSpanHandle(owner, direction, this.layoutEditPolicy);
        handle.setDragTracker((DragTracker)new ResizeTracker(owner, direction));
        return handle;
    }

    public Command getCommand(Request request) {
        if ("resize".equals(request.getType()) && request instanceof ChangeBoundsRequest) {
            return this.getSpanCommand((ChangeBoundsRequest)request);
        }
        return super.getCommand(request);
    }

    private Command getSpanCommand(ChangeBoundsRequest request) {
        List editParts = request.getEditParts();
        if (editParts.isEmpty() || editParts.size() > 1) {
            return UnexecutableCommand.INSTANCE;
        }
        ChangeBoundsRequest req = this.createSpanRequest(request);
        return this.getHost().getParent().getCommand((Request)req);
    }

    private ChangeBoundsRequest createSpanRequest(ChangeBoundsRequest request) {
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"GridLayout span cells");
        req.setEditParts(this.getHost());
        req.setMoveDelta(request.getMoveDelta());
        req.setSizeDelta(request.getSizeDelta());
        req.setLocation(request.getLocation());
        req.setResizeDirection(request.getResizeDirection());
        return req;
    }

    public void eraseSourceFeedback(Request request) {
        if ("resize".equals(request.getType())) {
            this.layoutEditPolicy.eraseTargetFeedback(request);
        } else {
            super.eraseSourceFeedback(request);
        }
    }

    public void showSourceFeedback(Request request) {
        if ("resize".equals(request.getType())) {
            if (request instanceof ChangeBoundsRequest && ((ChangeBoundsRequest)request).getEditParts().size() == 1) {
                this.layoutEditPolicy.showSpanTargetFeedback(this.createSpanRequest((ChangeBoundsRequest)request));
            }
        } else {
            super.showSourceFeedback(request);
        }
    }

    public boolean understandsRequest(Request request) {
        if ("resize".equals(request.getType())) {
            return true;
        }
        return super.understandsRequest(request);
    }
}

