/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.policies.feedback;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.e4.xwt.tools.ui.designer.core.figures.OutlineBorder;
import org.eclipse.e4.xwt.tools.ui.designer.editor.palette.CreateReqHelper;
import org.eclipse.e4.xwt.tools.ui.designer.parts.ShellEditPart;
import org.eclipse.e4.xwt.tools.ui.designer.policies.feedback.FeedbackManager;
import org.eclipse.e4.xwt.tools.ui.designer.policies.feedback.FillFeedback;
import org.eclipse.e4.xwt.tools.ui.designer.utils.OffsetUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.CreateRequest;

public class FeedbackHelper {
    public static boolean showCreationFeedback(FeedbackManager fbm, CreateRequest createReq) {
        if (fbm.contains((Request)createReq)) {
            return true;
        }
        CreateReqHelper helper = new CreateReqHelper(createReq);
        if (helper.canCreate(fbm.getHost())) {
            Rectangle r = fbm.getHostFigure().getBounds().getCopy();
            if (helper.isCreate("layout") || helper.isCreate("menu")) {
                return FeedbackHelper.showFillFeedback(fbm, createReq);
            }
            if (helper.isCreate("menuBar")) {
                r = FeedbackHelper.getMenuFeedbackBounds(fbm);
                if (r != null) {
                    Label feedback = new Label("Menu bar would be placed here");
                    feedback.setBounds(r);
                    feedback.setBackgroundColor(ColorConstants.button);
                    feedback.setOpaque(true);
                    feedback.setBorder((Border)new OutlineBorder(ColorConstants.blue, ColorConstants.button));
                    fbm.addFeedback((Request)createReq, (IFigure)feedback);
                    return true;
                }
            } else {
                return false;
            }
        }
        return false;
    }

    public static Polygon createTargetFeedback() {
        Polygon polygon = new Polygon();
        polygon.addPoint(new Point());
        polygon.addPoint(new Point());
        polygon.addPoint(new Point());
        polygon.addPoint(new Point());
        polygon.setForegroundColor(ColorConstants.blue);
        return polygon;
    }

    public static void updateTargetFeedback(GraphicalEditPart editPart, Polygon polygon) {
        IFigure figure = editPart.getFigure();
        Rectangle rectangle = figure.getBounds().getCopy();
        figure.translateToAbsolute((Translatable)rectangle);
        Point p = rectangle.getBottomLeft();
        polygon.translateToRelative((Translatable)p);
        polygon.setPoint(p, 0);
        p = rectangle.getBottomRight();
        polygon.translateToRelative((Translatable)p);
        polygon.setPoint(p, 1);
        p = rectangle.getTopRight();
        polygon.translateToRelative((Translatable)p);
        polygon.setPoint(p, 2);
        p = rectangle.getTopLeft();
        polygon.translateToRelative((Translatable)p);
        polygon.setPoint(p, 3);
    }

    public static boolean showFillFeedback(FeedbackManager fbm, CreateRequest createReq) {
        if (fbm.contains((Request)createReq)) {
            return true;
        }
        CreateReqHelper helper = new CreateReqHelper(createReq);
        if (helper.canCreate(fbm.getHost())) {
            Rectangle r = fbm.getHostFigure().getBounds().getCopy();
            FillFeedback feedback = new FillFeedback(new Rectangle(r.x, r.y, r.width, r.height));
            fbm.addFeedback((Request)createReq, (IFigure)feedback);
            return true;
        }
        return false;
    }

    private static Rectangle getMenuFeedbackBounds(FeedbackManager fbm) {
        EditPart host = fbm.getHost();
        if (host instanceof ShellEditPart) {
            int yOffset = OffsetUtil.getYOffset(host);
            Rectangle r = fbm.getHostFigure().getBounds().getCopy();
            return new Rectangle(r.x + 2, r.y + yOffset - 3, r.width - 4, 22);
        }
        return null;
    }
}

