/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.core.ceditor;

import java.util.EventObject;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.xwt.tools.ui.designer.core.ceditor.MultiSourceEditor;
import org.eclipse.e4.xwt.tools.ui.designer.core.component.CustomSashForm;
import org.eclipse.e4.xwt.tools.ui.designer.core.editor.IVisualRenderer;
import org.eclipse.e4.xwt.tools.ui.designer.core.editor.LoadingFigureController;
import org.eclipse.e4.xwt.tools.ui.designer.core.editor.Refresher;
import org.eclipse.e4.xwt.tools.ui.designer.core.model.IModelBuilder;
import org.eclipse.e4.xwt.tools.ui.designer.core.model.ModelChangeListener;
import org.eclipse.e4.xwt.tools.ui.designer.core.parts.RefreshContext;
import org.eclipse.e4.xwt.tools.ui.designer.core.problems.ProblemHandler;
import org.eclipse.e4.xwt.tools.ui.designer.core.util.DisplayUtil;
import org.eclipse.e4.xwt.tools.ui.palette.page.ContributePalettePage;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.views.palette.PalettePage;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public abstract class ConfigureDesigner
extends GraphicalEditor {
    private PalettePage palettePage;
    private IPropertySheetPage propertySheetPage;
    private IContentOutlinePage contentOutlinePage;
    private ProblemHandler problemHandler;
    private MultiSourceEditor sourceEditor;
    private LoadingFigureController loadingFigure;
    private Display display;
    private Refresher refresher;
    private Object diagram;
    private IModelBuilder modelBuilder;
    private ModelChangeListener modelBuilderListener;
    private IVisualRenderer visualsRender;
    private boolean isCreatingVisuals = false;
    private boolean isModelChanged;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setEditDomain(this.createEditDomain());
        super.init(site, input);
        this.display = site.getShell().getDisplay();
        this.loadingFigure = new LoadingFigureController();
        this.refresher = new Refresher(this.display);
    }

    protected org.eclipse.e4.xwt.tools.ui.designer.core.editor.EditDomain createEditDomain() {
        org.eclipse.e4.xwt.tools.ui.designer.core.editor.EditDomain ed = new org.eclipse.e4.xwt.tools.ui.designer.core.editor.EditDomain((IEditorPart)this);
        ed.setCommandStack(new CommandStack());
        return ed;
    }

    public Refresher getRefresher() {
        return this.refresher;
    }

    public void createPartControl(Composite parent) {
        ViewForm diagramPart = new ViewForm(parent, 0x800000);
        ToolBar toolBar = this.createToolBar((Composite)diagramPart);
        if (toolBar != null && !toolBar.isDisposed()) {
            diagramPart.setTopLeft((Control)toolBar);
        }
        this.sourceEditor = new MultiSourceEditor((IEditorPart)this);
        if (this.sourceEditor.testValid()) {
            CustomSashForm sashForm = new CustomSashForm((Composite)diagramPart, 512);
            super.createPartControl((Composite)sashForm);
            boolean createSourcePage = this.createSourcePage((Composite)sashForm);
            if (createSourcePage) {
                sashForm.setWeights(new int[]{1, 1});
                diagramPart.setContent((Control)sashForm);
            } else {
                sashForm.dispose();
                this.sourceEditor = null;
                Composite content = new Composite((Composite)diagramPart, 0);
                content.setLayout((Layout)new FillLayout());
                super.createPartControl(content);
                diagramPart.setContent((Control)content);
            }
        } else {
            this.sourceEditor = null;
            Composite content = new Composite((Composite)diagramPart, 0);
            content.setLayout((Layout)new FillLayout());
            super.createPartControl(content);
            diagramPart.setContent((Control)content);
        }
        this.configureDesigner();
    }

    protected void configureDesigner() {
        this.loadDiagram();
    }

    public void commandStackChanged(EventObject event) {
        super.commandStackChanged(event);
        this.firePropertyChange(257);
    }

    private void loadDiagram() {
        final IModelBuilder builder = this.getModelBuilder();
        if (builder == null) {
            return;
        }
        this.loadingFigure.showLoadingFigure(true);
        this.loadingFigure.startListener(this.getGraphicalViewer());
        UIJob loadingJob = new UIJob(this.display, "Setup"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                boolean built = builder.doLoad((IEditorPart)ConfigureDesigner.this, monitor);
                if (built) {
                    ConfigureDesigner.this.setupDiagram(builder.getDiagram());
                }
                return Status.OK_STATUS;
            }
        };
        loadingJob.setPriority(20);
        loadingJob.schedule();
    }

    protected IModelBuilder getModelBuilder() {
        if (this.modelBuilder == null) {
            this.modelBuilder = this.createModelBuilder();
        }
        if (this.modelBuilderListener == null) {
            this.modelBuilderListener = new ModelChangeListener(){

                public void notifyChanged(Notification event) {
                    ConfigureDesigner.this.dispatchModelEvent(event);
                }
            };
        }
        if (!this.modelBuilder.hasListener(this.modelBuilderListener)) {
            this.modelBuilder.addModelListener(this.modelBuilderListener);
        }
        return this.modelBuilder;
    }

    private void dispatchModelEvent(final Notification event) {
        if (event.isTouch() || this.isCreatingVisuals) {
            return;
        }
        if (this.display != null && this.display.getThread() == Thread.currentThread()) {
            this.updateVisuals(event);
        } else if (this.display != null) {
            DisplayUtil.asyncExec(this.display, new Runnable(){

                public void run() {
                    ConfigureDesigner.this.updateVisuals(event);
                }
            });
        }
    }

    protected void updateVisuals(Notification event) {
        IVisualRenderer.Result result;
        if (this.visualsRender == null || event.isTouch()) {
            return;
        }
        this.isCreatingVisuals = true;
        try {
            try {
                result = this.getVisualsRender().refreshVisuals(event);
            }
            catch (RuntimeException runtimeException) {
                this.isCreatingVisuals = false;
                return;
            }
        }
        finally {
            this.isCreatingVisuals = false;
        }
        if (result == null || !result.refreshed) {
            return;
        }
        List<EditPartViewer> viewers = this.getEditDomain().getViewers();
        for (EditPartViewer viewer : viewers) {
            this.updateViewer(viewer, result.visuals);
        }
        this.isModelChanged = true;
        this.firePropertyChange(257);
    }

    protected void updateViewer(EditPartViewer viewer, Object model) {
        if (viewer == null) {
            return;
        }
        EditPart editPart = (EditPart)viewer.getEditPartRegistry().get(model);
        if (editPart != null) {
            this.refresher.refreshInJob(editPart);
            if (editPart.isSelectable()) {
                viewer.select(editPart);
            }
        }
    }

    private void setupDiagram(final Object diagram) {
        if (diagram == null) {
            return;
        }
        this.diagram = diagram;
        IVisualRenderer vr = this.getVisualsRender();
        if (vr == null) {
            return;
        }
        this.isCreatingVisuals = true;
        vr.createVisuals();
        this.isCreatingVisuals = false;
        DisplayUtil.asyncExec(this.display, new Runnable(){

            public void run() {
                ConfigureDesigner.this.setupViewers(diagram);
            }
        });
        this.loadingFigure.showLoadingFigure(false);
    }

    protected void setupViewers(Object diagram) {
        List<EditPartViewer> viewers = this.getEditDomain().getViewers();
        for (EditPartViewer editPartViewer : viewers) {
            editPartViewer.setContents(diagram);
            RootEditPart rootEditPart = editPartViewer.getRootEditPart();
            this.refresher.refresh((EditPart)rootEditPart, RefreshContext.ALL());
        }
    }

    public Object getDiagram() {
        return this.diagram;
    }

    public IVisualRenderer getVisualsRender() {
        if (this.visualsRender == null) {
            this.visualsRender = this.createVisualsRender(this.getFile(), this.diagram);
            Assert.isNotNull((Object)this.visualsRender);
        }
        return this.visualsRender;
    }

    protected ToolBar createToolBar(Composite parent) {
        return null;
    }

    private boolean createSourcePage(Composite parent) {
        if (this.sourceEditor == null) {
            return false;
        }
        try {
            this.sourceEditor.init(this.getEditorSite(), this.getEditorInput());
            this.sourceEditor.createPartControl(parent);
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public org.eclipse.e4.xwt.tools.ui.designer.core.editor.EditDomain getEditDomain() {
        return (org.eclipse.e4.xwt.tools.ui.designer.core.editor.EditDomain)super.getEditDomain();
    }

    public void doSave(IProgressMonitor monitor) {
        this.saveGraphicalEditor(monitor);
        if (this.sourceEditor != null && this.sourceEditor.isDirty()) {
            this.sourceEditor.doSave(monitor);
        }
        this.firePropertyChange(257);
    }

    protected void saveGraphicalEditor(IProgressMonitor monitor) {
        this.isModelChanged = false;
        this.getCommandStack().markSaveLocation();
    }

    public boolean isDirty() {
        if (this.isModelChanged) {
            return true;
        }
        if (super.isDirty()) {
            return true;
        }
        if (this.sourceEditor != null) {
            return this.sourceEditor.isDirty();
        }
        return super.isDirty();
    }

    public void dispose() {
        if (this.sourceEditor != null) {
            this.sourceEditor.dispose();
        }
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        if (PalettePage.class.isAssignableFrom(adapter)) {
            return this.getPalettePage();
        }
        if (CommandStack.class == adapter) {
            return this.getCommandStack();
        }
        if (adapter == IPropertySheetPage.class) {
            return this.getPropertySheetPage();
        }
        if (adapter == IContentOutlinePage.class) {
            return this.getContentOutlinePage();
        }
        if (adapter == ProblemHandler.class) {
            return this.getProblemHandler();
        }
        if (adapter == IProject.class) {
            return this.getProject();
        }
        if (adapter == IFile.class) {
            return this.getFile();
        }
        return super.getAdapter(adapter);
    }

    public PalettePage getPalettePage() {
        if (this.palettePage == null) {
            this.palettePage = this.createPalettePage();
        }
        return this.palettePage;
    }

    public IPropertySheetPage getPropertySheetPage() {
        boolean recreate = true;
        if (this.propertySheetPage != null) {
            Control control = this.propertySheetPage.getControl();
            boolean bl = recreate = control == null || control.isDisposed();
        }
        if (recreate) {
            this.propertySheetPage = this.createPropertySheetPage();
        }
        return this.propertySheetPage;
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            this.contentOutlinePage = this.createContentOutlinePage();
        }
        return this.contentOutlinePage;
    }

    public ProblemHandler getProblemHandler() {
        if (this.problemHandler == null) {
            this.problemHandler = this.createProblemHandler();
        }
        return this.problemHandler;
    }

    public IProject getProject() {
        IFile file = this.getFile();
        if (file != null) {
            return file.getProject();
        }
        return null;
    }

    public IFile getFile() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput == null || !(editorInput instanceof IFileEditorInput)) {
            return null;
        }
        return ((IFileEditorInput)editorInput).getFile();
    }

    protected ProblemHandler createProblemHandler() {
        return null;
    }

    protected IContentOutlinePage createContentOutlinePage() {
        return null;
    }

    protected IPropertySheetPage createPropertySheetPage() {
        return null;
    }

    protected PalettePage createPalettePage() {
        return new ContributePalettePage((IEditorPart)this, (EditDomain)this.getEditDomain());
    }

    protected abstract IModelBuilder createModelBuilder();

    protected abstract IVisualRenderer createVisualsRender(IFile var1, Object var2);
}

