/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench.addons;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.model.LocalizationHelper;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.commands.MBindingContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ContextProcessingAddon {
    @Inject
    private MApplication application;
    @Inject
    private IEventBroker broker;
    @Inject
    private ContextManager contextManager;
    private EventHandler additionHandler;

    @PostConstruct
    public void init() {
        this.defineContexts();
        this.registerModelListeners();
    }

    private void defineContexts() {
        Activator.trace("/trace/commands", "Initialize contexts and parents from model", null);
        for (MBindingContext root : this.application.getRootContext()) {
            this.defineContexts(null, root);
        }
    }

    private void defineContexts(MBindingContext parent, MBindingContext current) {
        Context context = this.contextManager.getContext(current.getElementId());
        if (!context.isDefined()) {
            String localizedName = LocalizationHelper.getLocalized((String)current.getName(), (MApplicationElement)current, (IEclipseContext)this.application.getContext());
            String localizedDescriptor = LocalizationHelper.getLocalized((String)current.getDescription(), (MApplicationElement)current, (IEclipseContext)this.application.getContext());
            context.define(localizedName, localizedDescriptor, parent == null ? null : parent.getElementId());
        }
        for (MBindingContext child : current.getChildren()) {
            this.defineContexts(current, child);
        }
    }

    private void undefineContext(MBindingContext current) {
        Context context = this.contextManager.getContext(current.getElementId());
        context.undefine();
    }

    @PreDestroy
    public void dispose() {
        this.unregsiterModelListeners();
    }

    private void registerModelListeners() {
        this.additionHandler = new EventHandler(){

            public void handleEvent(Event event) {
                Object elementObj = event.getProperty("ChangedElement");
                if (elementObj instanceof MBindingContext) {
                    Object newObj = event.getProperty("NewValue");
                    Object oldObj = event.getProperty("OldValue");
                    if ("ADD".equals(event.getProperty("EventType")) && newObj instanceof MBindingContext) {
                        MBindingContext newCtx = (MBindingContext)newObj;
                        ContextProcessingAddon.this.defineContexts((MBindingContext)elementObj, newCtx);
                    } else if ("REMOVE".equals(event.getProperty("EventType")) && oldObj instanceof MBindingContext) {
                        MBindingContext oldCtx = (MBindingContext)oldObj;
                        ContextProcessingAddon.this.undefineContext(oldCtx);
                    }
                }
            }
        };
        this.broker.subscribe("org/eclipse/e4/ui/model/commands/BindingContext/children/*", this.additionHandler);
    }

    private void unregsiterModelListeners() {
        this.broker.unsubscribe(this.additionHandler);
    }
}

