/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.core.parser;

import junit.framework.TestCase;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.impl.dom.Measure;
import org.eclipse.e4.ui.tests.css.core.util.ParserTestUtil;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public class ValueTest
extends TestCase {
    private CSSEngine engine;

    protected void setUp() throws Exception {
        this.engine = ParserTestUtil.createEngine();
    }

    public void testFloat() throws Exception {
        CSSValue value = this.engine.parsePropertyValue("2.0");
        ValueTest.assertTrue((boolean)(value instanceof Measure));
        ValueTest.assertEquals((String)"2.0", (String)value.getCssText());
    }

    public void testInt() throws Exception {
        CSSValue value = this.engine.parsePropertyValue("34");
        ValueTest.assertTrue((boolean)(value instanceof Measure));
        ValueTest.assertEquals((short)((Measure)value).getPrimitiveType(), (short)1);
        ValueTest.assertEquals((String)"34", (String)value.getCssText());
    }

    public void testIdentifier() throws Exception {
        CSSValue value = this.engine.parsePropertyValue("SomeWord");
        ValueTest.assertTrue((boolean)(value instanceof Measure));
        ValueTest.assertEquals((short)((Measure)value).getPrimitiveType(), (short)21);
        ValueTest.assertEquals((String)"SomeWord", (String)value.getCssText());
    }

    public void testPercent() throws Exception {
        CSSValue value = this.engine.parsePropertyValue("30%");
        ValueTest.assertTrue((boolean)(value instanceof Measure));
        ValueTest.assertEquals((short)((Measure)value).getPrimitiveType(), (short)2);
        ValueTest.assertEquals((String)"30.0%", (String)value.getCssText());
    }

    public void testPixel() throws Exception {
        CSSValue value = this.engine.parsePropertyValue("26px");
        ValueTest.assertTrue((boolean)(value instanceof Measure));
        ValueTest.assertEquals((short)((Measure)value).getPrimitiveType(), (short)5);
        ValueTest.assertEquals((String)"26.0px", (String)value.getCssText());
    }

    public void testInch() throws Exception {
        CSSValue value = this.engine.parsePropertyValue("88in");
        ValueTest.assertTrue((boolean)(value instanceof Measure));
        ValueTest.assertEquals((short)((Measure)value).getPrimitiveType(), (short)8);
        ValueTest.assertEquals((String)"88.0in", (String)value.getCssText());
    }

    public void testEm() throws Exception {
        CSSValue value = this.engine.parsePropertyValue("75em");
        ValueTest.assertTrue((boolean)(value instanceof Measure));
        ValueTest.assertEquals((short)((Measure)value).getPrimitiveType(), (short)3);
        ValueTest.assertEquals((String)"75.0em", (String)value.getCssText());
    }

    public void testURI() throws Exception {
        CSSValue value = this.engine.parsePropertyValue("url(./somepath/picture.gif)");
        ValueTest.assertTrue((boolean)(value instanceof Measure));
        ValueTest.assertEquals((short)((Measure)value).getPrimitiveType(), (short)20);
        ValueTest.assertEquals((String)"url(./somepath/picture.gif)", (String)value.getCssText());
    }

    public void testList() throws Exception {
        CSSValue value = this.engine.parsePropertyValue("34 34 34");
        ValueTest.assertTrue((boolean)(value instanceof CSSValueList));
        ValueTest.assertEquals((short)((CSSValueList)value).getCssValueType(), (short)2);
        ValueTest.assertEquals((int)3, (int)((CSSValueList)value).getLength());
        ValueTest.assertTrue((boolean)(((CSSValueList)value).item(0) instanceof Measure));
        ValueTest.assertEquals((short)1, (short)((Measure)((CSSValueList)value).item(0)).getPrimitiveType());
        ValueTest.assertTrue((boolean)(((CSSValueList)value).item(1) instanceof Measure));
        ValueTest.assertEquals((short)1, (short)((Measure)((CSSValueList)value).item(1)).getPrimitiveType());
        ValueTest.assertTrue((boolean)(((CSSValueList)value).item(2) instanceof Measure));
        ValueTest.assertEquals((short)1, (short)((Measure)((CSSValueList)value).item(2)).getPrimitiveType());
        ValueTest.assertEquals((String)"34 34 34", (String)value.getCssText());
    }

    public void testCommaSeparatedList() throws Exception {
        CSSValue value = this.engine.parsePropertyValue("34, 34, 34");
        ValueTest.assertTrue((boolean)(value instanceof CSSValueList));
        CSSValueList list = (CSSValueList)value;
        ValueTest.assertEquals((short)list.getCssValueType(), (short)2);
        ValueTest.assertEquals((int)5, (int)list.getLength());
        int i = 0;
        while (i < list.getLength()) {
            ValueTest.assertTrue((boolean)(list.item(i) instanceof Measure));
            ++i;
        }
        ValueTest.assertEquals((short)1, (short)((Measure)list.item(0)).getPrimitiveType());
        ValueTest.assertEquals((short)3, (short)((Measure)list.item(1)).getPrimitiveType());
        ValueTest.assertEquals((short)1, (short)((Measure)list.item(2)).getPrimitiveType());
        ValueTest.assertEquals((short)3, (short)((Measure)list.item(3)).getPrimitiveType());
        ValueTest.assertEquals((short)1, (short)((Measure)list.item(4)).getPrimitiveType());
        ValueTest.assertTrue((boolean)value.getCssText().matches("34\\s*,\\s*34\\s*,\\s*34"));
    }
}

