/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.examples.css.editor;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.ui.css.core.css2.CSS2FontPropertiesHelpers;
import org.eclipse.e4.ui.css.core.dom.IElementProvider;
import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2FontProperties;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.serializers.CSSSerializerConfiguration;
import org.eclipse.e4.ui.css.core.util.impl.resources.FileResourcesLocatorImpl;
import org.eclipse.e4.ui.css.core.util.resources.IResourceLocator;
import org.eclipse.e4.ui.css.swt.dom.SWTElementProvider;
import org.eclipse.e4.ui.css.swt.dom.html.SWTHTMLElementProvider;
import org.eclipse.e4.ui.css.swt.engine.CSSSWTEngineImpl;
import org.eclipse.e4.ui.css.swt.serializers.CSSSWTSerializerConfiguration;
import org.eclipse.e4.ui.examples.css.editor.AbstractCSSEditor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.css.CSSValue;

public abstract class AbstractCSSSWTEditor
extends AbstractCSSEditor {
    protected static final String[] CSS_FILE_EXTENSION = new String[]{"*.css"};
    private Display display;
    private StyledText textArea;
    private Button cacheResourcesCheckbox;
    private Button htmlCheckbox;
    private Label statusLabel;
    private Button applyStyleWhenTextAreaChangeCheckbox;
    private Button applyStyleToShellCheckbox;
    protected Shell shell;
    private Composite leftPanel;
    private org.eclipse.swt.widgets.List cssFilesWidget;
    private List cssFiles = new ArrayList();
    private Text selectedCSSPropertyNameText = null;
    private Text selectedCSSPropertyValueText = null;
    protected int currentLine = -1;

    protected AbstractCSSSWTEditor(String nativeWidgetDir, String[] styleFileExtension) {
        super(nativeWidgetDir);
    }

    protected AbstractCSSSWTEditor() {
        super("swt");
    }

    public void display() {
        this.display = new Display();
        this.shell = new Shell(this.display, 1264);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 3;
        this.shell.setLayout((Layout)layout);
        this.createMenus(this.shell);
        SashForm form = new SashForm((Composite)this.shell, 0);
        form.setLayoutData((Object)new GridData(1808));
        this.createLeftPanel((Composite)form);
        this.createRightPanel((Composite)form);
        form.setWeights(new int[]{30, 80});
        this.shell.setSize(new Point(800, 600));
        this.shell.open();
        this.shell.setText("CSS Editors");
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.display.dispose();
    }

    protected void createMenus(Shell shell) {
        Menu menu = new Menu((Decorations)shell, 2);
        shell.setMenuBar(menu);
        this.createMenuItemFile(menu, shell);
    }

    protected void createMenuItemFile(Menu menu, final Shell shell) {
        MenuItem menuFileHeader = new MenuItem(menu, 64);
        menuFileHeader.setText("&File");
        Menu menuFile = new Menu((Decorations)shell, 4);
        menuFileHeader.setMenu(menuFile);
        MenuItem itemNew = new MenuItem(menuFile, 8);
        itemNew.setText("&New...");
        itemNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractCSSSWTEditor.this.fillTextareaWithDefaultStyleSheetContent();
            }
        });
        MenuItem itemOpen = new MenuItem(menuFile, 8);
        itemOpen.setText("&Open...");
        itemOpen.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(shell, 0);
                dialog.setFilterExtensions(CSS_FILE_EXTENSION);
                dialog.setText("Select CSS style file");
                dialog.setFilterPath(AbstractCSSSWTEditor.this.getBaseStyleDir().getAbsolutePath());
                String path = dialog.open();
                if (path != null) {
                    File file = new File(path);
                    AbstractCSSSWTEditor.this.fillTextareaWithStyleSheetContent(file);
                }
            }
        });
    }

    protected void createMenuItemOptions(Menu menu) {
        MenuItem menuOptionsHeader = new MenuItem(menu, 64);
        menuOptionsHeader.setText("&Options");
        Menu menuOptions = new Menu((Decorations)this.shell, 4);
        menuOptionsHeader.setMenu(menuOptions);
        MenuItem itemNew = new MenuItem(menuOptions, 32);
        itemNew.setText("&Cache Resource...");
    }

    protected void createLeftPanel(Composite parent) {
        this.leftPanel = new Composite(parent, 0);
        this.leftPanel.setLayout((Layout)new FillLayout());
        this.createContent(this.leftPanel);
    }

    protected void createRightPanel(Composite parent) {
        SashForm form = new SashForm(parent, 0);
        form.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 3;
        Composite composite = new Composite((Composite)form, 0);
        composite.setLayout((Layout)layout);
        this.statusLabel = new Label(composite, 0);
        this.statusLabel.setLayoutData((Object)new GridData(768));
        this.textArea = new StyledText(composite, 2562);
        this.textArea.setLayoutData((Object)new GridData(1808));
        this.textArea.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AbstractCSSSWTEditor.this.applyStyleWhenTextAreaChangeCheckbox.getSelection()) {
                    AbstractCSSSWTEditor.this.applyStyles();
                }
            }
        });
        this.textArea.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                AbstractCSSSWTEditor.this.displaySelectedCSSProperty();
            }
        });
        this.textArea.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                AbstractCSSSWTEditor.this.displaySelectedCSSProperty();
            }
        });
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 3;
        composite = new Composite((Composite)form, 0);
        composite.setLayout((Layout)layout);
        Group group = new Group(composite, 0);
        group.setText("Selected CSS Property");
        layout = new GridLayout(2, true);
        layout.verticalSpacing = 3;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)group, 0);
        label.setText("CSS Property name");
        this.selectedCSSPropertyNameText = new Text((Composite)group, 2056);
        this.selectedCSSPropertyNameText.setLayoutData((Object)new GridData(768));
        label = new Label((Composite)group, 0);
        label.setText("CSS Property value");
        this.selectedCSSPropertyValueText = new Text((Composite)group, 2048);
        this.selectedCSSPropertyValueText.setLayoutData((Object)new GridData(768));
        this.selectedCSSPropertyValueText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                String property = AbstractCSSSWTEditor.this.selectedCSSPropertyNameText.getText();
                property = String.valueOf(property) + ":";
                property = String.valueOf(property) + AbstractCSSSWTEditor.this.selectedCSSPropertyValueText.getText();
                AbstractCSSSWTEditor.this.updateSelectedCSSPropertyValue(property);
            }
        });
        Button b = new Button((Composite)group, 2056);
        b.setText("Change Color");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RGB newColor;
                ColorDialog colorDialog = new ColorDialog(AbstractCSSSWTEditor.this.shell);
                colorDialog.setText("ColorDialog Demo");
                String cssValue = AbstractCSSSWTEditor.this.selectedCSSPropertyValueText.getText();
                if (cssValue != null && cssValue.length() > 0) {
                    try {
                        CSSValue value = AbstractCSSSWTEditor.this.engine.parsePropertyValue(cssValue);
                        RGB rgb = (RGB)AbstractCSSSWTEditor.this.engine.convert(value, RGB.class, null);
                        if (rgb != null) {
                            colorDialog.setRGB(rgb);
                        }
                    }
                    catch (Exception ex) {
                        AbstractCSSSWTEditor.this.handleExceptions(ex);
                    }
                }
                if ((newColor = colorDialog.open()) != null) {
                    try {
                        cssValue = AbstractCSSSWTEditor.this.engine.convert((Object)newColor, RGB.class, (Object)AbstractCSSSWTEditor.this.selectedCSSPropertyNameText.getText());
                        if (cssValue == null) {
                            return;
                        }
                        AbstractCSSSWTEditor.this.selectedCSSPropertyValueText.setText(cssValue);
                        String property = AbstractCSSSWTEditor.this.selectedCSSPropertyNameText.getText();
                        property = String.valueOf(property) + ":";
                        property = String.valueOf(property) + AbstractCSSSWTEditor.this.selectedCSSPropertyValueText.getText();
                        AbstractCSSSWTEditor.this.updateSelectedCSSPropertyValue(property);
                    }
                    catch (Exception ex) {
                        AbstractCSSSWTEditor.this.handleExceptions(ex);
                    }
                }
            }
        });
        Button b2 = new Button((Composite)group, 2056);
        b2.setText("Change Font");
        b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FontData newFontData;
                Object cssValue;
                FontDialog fontDialog = new FontDialog(AbstractCSSSWTEditor.this.shell);
                fontDialog.setText("Choose the font");
                String value = AbstractCSSSWTEditor.this.selectedCSSPropertyValueText.getText();
                try {
                    String propertyName = AbstractCSSSWTEditor.this.selectedCSSPropertyNameText.getText();
                    cssValue = AbstractCSSSWTEditor.this.engine.parsePropertyValue(value);
                    CSS2FontProperties fontProperties = CSS2FontPropertiesHelpers.createCSS2FontProperties((CSSValue)cssValue, (String)propertyName);
                    FontData fontData = (FontData)AbstractCSSSWTEditor.this.engine.convert((CSSValue)fontProperties, FontData.class, (Object)AbstractCSSSWTEditor.this.display);
                    if (fontData != null) {
                        FontData[] fontDatas = new FontData[]{fontData};
                        fontDialog.setFontList(fontDatas);
                    }
                }
                catch (Exception ex) {
                    AbstractCSSSWTEditor.this.handleExceptions(ex);
                }
                if ((newFontData = fontDialog.open()) != null) {
                    try {
                        cssValue = AbstractCSSSWTEditor.this.engine.convert((Object)newFontData, FontData.class, (Object)AbstractCSSSWTEditor.this.selectedCSSPropertyNameText.getText());
                        if (cssValue == null) {
                            return;
                        }
                        AbstractCSSSWTEditor.this.selectedCSSPropertyValueText.setText((String)cssValue);
                        String property = AbstractCSSSWTEditor.this.selectedCSSPropertyNameText.getText();
                        property = String.valueOf(property) + ":";
                        property = String.valueOf(property) + AbstractCSSSWTEditor.this.selectedCSSPropertyValueText.getText();
                        AbstractCSSSWTEditor.this.updateSelectedCSSPropertyValue(property);
                    }
                    catch (Exception ex) {
                        AbstractCSSSWTEditor.this.handleExceptions(ex);
                    }
                }
            }
        });
        group = new Group(composite, 0);
        group.setText("CSS Engine options");
        layout = new GridLayout();
        layout.verticalSpacing = 3;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(1808));
        this.cacheResourcesCheckbox = new Button((Composite)group, 32);
        this.cacheResourcesCheckbox.setText("Cache Color, Font and Cursor");
        this.cacheResourcesCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!AbstractCSSSWTEditor.this.cacheResourcesCheckbox.getSelection()) {
                    AbstractCSSSWTEditor.this.engine.getResourcesRegistry().dispose();
                }
            }
        });
        this.cacheResourcesCheckbox.setSelection(true);
        this.applyStyleWhenTextAreaChangeCheckbox = new Button((Composite)group, 32);
        this.applyStyleWhenTextAreaChangeCheckbox.setText("Apply style when textarea change");
        this.applyStyleWhenTextAreaChangeCheckbox.setSelection(true);
        this.htmlCheckbox = new Button((Composite)group, 32);
        this.htmlCheckbox.setText("is HTML Selector? (otherwise it's SWT Selector)");
        this.htmlCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractCSSSWTEditor.this.populateCSSFiles();
                AbstractCSSSWTEditor.this.applyStylesFromSelectedFile();
            }
        });
        this.cssFilesWidget = new org.eclipse.swt.widgets.List((Composite)group, 0);
        this.cssFilesWidget.setLayoutData((Object)new GridData(768));
        this.cssFilesWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractCSSSWTEditor.this.applyStylesFromSelectedFile();
            }
        });
        this.populateCSSFiles();
        this.applyStyleToShellCheckbox = new Button((Composite)group, 32);
        this.applyStyleToShellCheckbox.setText("Apply style to Shell?");
        this.applyStyleToShellCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractCSSSWTEditor.this.applyStyleToShellCheckbox.getSelection()) {
                    AbstractCSSSWTEditor.this.applyStyles();
                } else {
                    AbstractCSSSWTEditor.this.engine = AbstractCSSSWTEditor.this.getCSSEngine();
                    AbstractCSSSWTEditor.this.engine.applyStyles((Object)AbstractCSSSWTEditor.this.shell, true);
                    AbstractCSSSWTEditor.this.applyStyles();
                }
            }
        });
        Button applyStyleButton = new Button((Composite)group, 2048);
        applyStyleButton.setText("Apply style");
        applyStyleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractCSSSWTEditor.this.applyStyles();
            }
        });
        form.setWeights(new int[]{120, 90});
        this.applyStylesFromSelectedFile();
    }

    public abstract void createContent(Composite var1);

    protected void displaySelectedCSSProperty() {
        this.selectedCSSPropertyNameText.setText("");
        this.selectedCSSPropertyValueText.setText("");
        int start = -1;
        int end = -1;
        this.currentLine = this.textArea.getLineAtOffset(this.textArea.getCaretOffset());
        if (this.currentLine + 1 >= this.textArea.getLineCount()) {
            return;
        }
        start = this.textArea.getOffsetAtLine(this.currentLine);
        if (start <= (end = this.textArea.getOffsetAtLine(this.currentLine + 1) - 2)) {
            String lineText = this.textArea.getText(start, end);
            int index = (lineText = lineText.trim()).indexOf(":");
            if (index > 0) {
                if (lineText.indexOf("{") != -1) {
                    return;
                }
                String property = lineText.substring(0, index);
                String value = lineText.substring(index + 1, lineText.length());
                int commentIndex = (value = value.replaceAll(";", "")).indexOf("/*");
                if (commentIndex > 0) {
                    value = value.substring(0, commentIndex);
                }
                this.selectedCSSPropertyNameText.setText(property);
                this.selectedCSSPropertyValueText.setText(value);
            }
        }
    }

    protected void updateSelectedCSSPropertyValue(String text) {
        if (this.currentLine != -1 && this.currentLine + 1 >= this.textArea.getLineCount()) {
            return;
        }
        int start = this.textArea.getOffsetAtLine(this.currentLine);
        int end = this.textArea.getOffsetAtLine(this.currentLine + 1) - 2;
        String startLineText = this.textArea.getText(0, start);
        String endLineText = this.textArea.getText(end, this.textArea.getCharCount() - 1);
        if (!text.endsWith(";") && !endLineText.startsWith(";")) {
            text = String.valueOf(text) + ";";
        }
        if (endLineText.startsWith(":")) {
            endLineText.substring(1, endLineText.length());
        }
        String newContent = String.valueOf(startLineText) + text + endLineText;
        this.textArea.setText(newContent);
    }

    protected CSSEngine createCSSEngine() {
        CSSSWTEngineImpl engine = new CSSSWTEngineImpl(this.shell.getDisplay());
        engine.getResourcesLocatorManager().registerResourceLocator((IResourceLocator)new FileResourcesLocatorImpl());
        return engine;
    }

    protected IElementProvider getHTMLElementProvider() {
        return SWTHTMLElementProvider.INSTANCE;
    }

    protected IElementProvider getNativeWidgetElementProvider() {
        return SWTElementProvider.INSTANCE;
    }

    protected boolean isHTMLSelector() {
        return this.htmlCheckbox.getSelection();
    }

    protected String getStyleSheetContent() {
        return this.textArea.getText();
    }

    protected void setStyleSheetContent(String content) {
        this.textArea.setText(content);
    }

    protected void setCSSEngineStatuts(String status) {
        this.statusLabel.setText(status);
    }

    protected boolean mustApplyStylesToWindow() {
        return this.applyStyleToShellCheckbox.getSelection();
    }

    protected Object getLeftPanelNativeWidget() {
        return this.leftPanel;
    }

    protected Object getWindowNativeWidget() {
        return this.shell;
    }

    protected CSSSerializerConfiguration getCSSNativeWidgetSerializerConfiguration() {
        return CSSSWTSerializerConfiguration.INSTANCE;
    }

    protected int getCSSFilesWidgetItemCount() {
        return this.cssFilesWidget.getItemCount();
    }

    protected int getCSSFilesWidgetSelectionIndex() {
        return this.cssFilesWidget.getSelectionIndex();
    }

    protected void selectCSSFilesWidget(int index) {
        this.cssFilesWidget.select(index);
    }

    protected void addItemCSSFilesWidget(String item) {
        this.cssFilesWidget.add(item);
    }

    protected void removeAllCSSFilesWidget() {
        this.cssFilesWidget.removeAll();
    }
}

