/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.di;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;

public class RecursiveObjectCreationTest
extends TestCase {
    public void testSelfInject() {
        IEclipseContext context = EclipseContextFactory.create();
        boolean exceptionReceived = false;
        try {
            CheckSelfInject testInstance = (CheckSelfInject)ContextInjectionFactory.make(CheckSelfInject.class, (IEclipseContext)context);
            RecursiveObjectCreationTest.assertNotNull((Object)testInstance);
        }
        catch (InjectionException injectionException) {
            exceptionReceived = true;
        }
        RecursiveObjectCreationTest.assertTrue((boolean)exceptionReceived);
    }

    public void testNested() {
        IEclipseContext context = EclipseContextFactory.create();
        boolean exceptionReceived = false;
        try {
            TestOuterClass outer = (TestOuterClass)ContextInjectionFactory.make(TestOuterClass.class, (IEclipseContext)context);
            RecursiveObjectCreationTest.assertNotNull((Object)outer);
        }
        catch (InjectionException injectionException) {
            exceptionReceived = true;
        }
        RecursiveObjectCreationTest.assertTrue((boolean)exceptionReceived);
    }

    public static class CheckSelfInject {
        public CheckSelfInject other;

        @Inject
        public CheckSelfInject(CheckSelfInject other) {
            this.other = other;
        }
    }

    public static class TestOuterClass {
        public TestInnerClassInject innerInject;

        @Inject
        public TestOuterClass() {
        }

        @PostConstruct
        public void init(IEclipseContext context) {
            this.innerInject = (TestInnerClassInject)ContextInjectionFactory.make(TestInnerClassInject.class, (IEclipseContext)context);
        }

        public class TestInnerClassInject {
            @Inject
            public TestInnerClassInject() {
            }
        }
    }
}

