/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.internal.resources.semantic.SemanticFileAdapterImpl;
import org.eclipse.core.internal.resources.semantic.SemanticFolderAdapterImpl;
import org.eclipse.core.internal.resources.semantic.SemanticProjectAdapterImpl;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.semantic.ISemanticFile;
import org.eclipse.core.resources.semantic.ISemanticFileSystem;
import org.eclipse.core.resources.semantic.ISemanticFolder;
import org.eclipse.core.resources.semantic.ISemanticProject;
import org.eclipse.core.resources.semantic.ISemanticResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;

public class SemanticFileSystemAdapterFactory
implements IAdapterFactory {
    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof IResource && this.isSemanticStoreScheme((IResource)adaptableObject)) {
            ISemanticFileSystem sfs;
            try {
                sfs = (ISemanticFileSystem)EFS.getFileSystem((String)"semanticfs");
            }
            catch (CoreException coreException) {
                return null;
            }
            if (adaptableObject instanceof IFile) {
                if (adapterType == ISemanticFile.class || adapterType == ISemanticResource.class) {
                    return new SemanticFileAdapterImpl((IFile)adaptableObject, sfs);
                }
            } else if (adaptableObject instanceof IFolder) {
                if (adapterType == ISemanticFolder.class || adapterType == ISemanticResource.class) {
                    return new SemanticFolderAdapterImpl((IContainer)adaptableObject, sfs);
                }
            } else if (adaptableObject instanceof IProject && (adapterType == ISemanticProject.class || adapterType == ISemanticFolder.class || adapterType == ISemanticResource.class)) {
                return new SemanticProjectAdapterImpl((IProject)adaptableObject, sfs);
            }
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{ISemanticFolder.class, ISemanticFile.class, ISemanticResource.class, ISemanticProject.class};
    }

    private boolean isSemanticStoreScheme(IResource resource) {
        URI uri = resource.getLocationURI();
        return uri != null && "semanticfs".equals(uri.getScheme());
    }
}

