/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.commands.internal;

import java.util.Map;
import javax.inject.Inject;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;

public class HandlerServiceImpl
implements EHandlerService {
    private static final String TMP_STATIC_CONTEXT = "tmp-staticContext";
    public static final String H_ID = "handler::";
    public static final String PARM_MAP = "parmMap::";
    private IEclipseContext context;

    public static Object lookUpHandler(IEclipseContext context, String commandId) {
        return context.getActiveLeaf().get(H_ID + commandId);
    }

    public void activateHandler(String commandId, Object handler) {
        String handlerId = H_ID + commandId;
        this.context.set(handlerId, handler);
    }

    private void addParms(ParameterizedCommand command, IEclipseContext staticContext) {
        Map parms = command.getParameterMap();
        for (Map.Entry entry : parms.entrySet()) {
            staticContext.set((String)entry.getKey(), entry.getValue());
        }
        staticContext.set(PARM_MAP, (Object)parms);
    }

    public boolean canExecute(ParameterizedCommand command) {
        IEclipseContext staticContext = EclipseContextFactory.create((String)TMP_STATIC_CONTEXT);
        try {
            boolean bl = this.canExecute(command, staticContext);
            return bl;
        }
        finally {
            staticContext.dispose();
        }
    }

    public boolean canExecute(ParameterizedCommand command, IEclipseContext staticContext) {
        String commandId = command.getId();
        Object handler = HandlerServiceImpl.lookUpHandler(this.context, commandId);
        if (handler == null) {
            return false;
        }
        IEclipseContext executionContext = this.getExecutionContext();
        this.addParms(command, staticContext);
        Boolean result = (Boolean)ContextInjectionFactory.invoke((Object)handler, CanExecute.class, (IEclipseContext)executionContext, (IEclipseContext)staticContext, (Object)Boolean.TRUE);
        return result;
    }

    public void deactivateHandler(String commandId, Object handler) {
        this.context.remove(H_ID + commandId);
    }

    public Object executeHandler(ParameterizedCommand command) {
        IEclipseContext staticContext = EclipseContextFactory.create((String)TMP_STATIC_CONTEXT);
        try {
            Object object = this.executeHandler(command, staticContext);
            return object;
        }
        finally {
            staticContext.dispose();
        }
    }

    public Object executeHandler(ParameterizedCommand command, IEclipseContext staticContext) {
        String commandId = command.getId();
        Object handler = HandlerServiceImpl.lookUpHandler(this.context, commandId);
        if (handler == null) {
            return null;
        }
        IEclipseContext executionContext = this.getExecutionContext();
        this.addParms(command, staticContext);
        Object rc = ContextInjectionFactory.invoke((Object)handler, CanExecute.class, (IEclipseContext)executionContext, (IEclipseContext)staticContext, (Object)Boolean.TRUE);
        if (Boolean.FALSE.equals(rc)) {
            return null;
        }
        return ContextInjectionFactory.invoke((Object)handler, Execute.class, (IEclipseContext)executionContext, (IEclipseContext)staticContext, null);
    }

    @Inject
    public void setContext(IEclipseContext c) {
        this.context = c;
    }

    public IEclipseContext getContext() {
        return this.context;
    }

    public IEclipseContext getExecutionContext() {
        return this.context.getActiveLeaf();
    }
}

