/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.HashMap;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.UpdateMarkersOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.part.CellEditorActionHandler;
import org.eclipse.ui.views.markers.internal.ActionAddGlobalTask;
import org.eclipse.ui.views.markers.internal.ActionDeleteCompleted;
import org.eclipse.ui.views.markers.internal.ActionMarkCompleted;
import org.eclipse.ui.views.markers.internal.ActionTaskProperties;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.DialogMarkerFilter;
import org.eclipse.ui.views.markers.internal.DialogTaskFilter;
import org.eclipse.ui.views.markers.internal.FieldCreationTime;
import org.eclipse.ui.views.markers.internal.FieldDone;
import org.eclipse.ui.views.markers.internal.FieldFolder;
import org.eclipse.ui.views.markers.internal.FieldLineNumber;
import org.eclipse.ui.views.markers.internal.FieldMessage;
import org.eclipse.ui.views.markers.internal.FieldPriority;
import org.eclipse.ui.views.markers.internal.FieldResource;
import org.eclipse.ui.views.markers.internal.IField;
import org.eclipse.ui.views.markers.internal.MarkerFilter;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerView;
import org.eclipse.ui.views.markers.internal.TaskFilter;
import org.eclipse.ui.views.markers.internal.Util;

public class TaskView
extends MarkerView {
    private static final String COMPLETION = "completion";
    private final IField[] HIDDEN_FIELDS = new IField[]{new FieldCreationTime()};
    private static final String[] ROOT_TYPES = new String[]{"org.eclipse.core.resources.taskmarker"};
    private static final String[] TABLE_COLUMN_PROPERTIES = new String[]{"completion", "priority", "message", Util.EMPTY_STRING, Util.EMPTY_STRING, Util.EMPTY_STRING};
    private static final String TAG_DIALOG_SECTION = "org.eclipse.ui.views.task";
    private final IField[] VISIBLE_FIELDS = new IField[]{new FieldDone(), new FieldPriority(), new FieldMessage(), new FieldResource(), new FieldFolder(), new FieldLineNumber()};
    private ICellModifier cellModifier = new ICellModifier(){

        public Object getValue(Object element, String property) {
            if (element instanceof ConcreteMarker) {
                IMarker marker = ((ConcreteMarker)element).getMarker();
                if (TaskView.COMPLETION.equals(property)) {
                    return marker.getAttribute("done", false) ? Boolean.TRUE : Boolean.FALSE;
                }
                if ("priority".equals(property)) {
                    return new Integer(2 - marker.getAttribute("priority", 1));
                }
                if ("message".equals(property)) {
                    return marker.getAttribute("message", "");
                }
            }
            return null;
        }

        public boolean canModify(Object element, String property) {
            return Util.isEditable(((ConcreteMarker)element).getMarker());
        }

        public void modify(Object element, String property, Object value) {
            Item item;
            Object data;
            if (element instanceof Item && (data = (item = (Item)element).getData()) instanceof ConcreteMarker) {
                ConcreteMarker concreteMarker = (ConcreteMarker)data;
                IMarker marker = concreteMarker.getMarker();
                try {
                    Object oldValue = this.getValue(data, property);
                    if (oldValue != null && !oldValue.equals(value)) {
                        HashMap<String, Object> attrs = new HashMap<String, Object>();
                        if (TaskView.COMPLETION.equals(property)) {
                            attrs.put("done", value);
                        } else if ("priority".equals(property)) {
                            attrs.put("priority", new Integer(2 - (Integer)value));
                        } else if ("message".equals(property)) {
                            attrs.put("message", value);
                        }
                        if (!attrs.isEmpty()) {
                            UpdateMarkersOperation op = new UpdateMarkersOperation(marker, attrs, MarkerMessages.modifyTask_title, true);
                            PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)op, null, WorkspaceUndoUtil.getUIInfoAdapter(TaskView.this.getSite().getShell()));
                        }
                    }
                    concreteMarker.refresh();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof CoreException) {
                        ErrorDialog.openError((Shell)TaskView.this.getSite().getShell(), (String)MarkerMessages.errorModifyingTask, null, (IStatus)((CoreException)e.getCause()).getStatus());
                    }
                    IDEWorkbenchPlugin.log(MarkerMessages.errorModifyingTask, e);
                }
            }
        }
    };
    private CellEditorActionHandler cellEditorActionHandler;
    private ActionAddGlobalTask addGlobalTaskAction;
    private ActionDeleteCompleted deleteCompletedAction;
    private ActionMarkCompleted markCompletedAction;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        TreeViewer treeViewer = this.getViewer();
        CellEditor[] cellEditors = new CellEditor[treeViewer.getTree().getColumnCount()];
        cellEditors[0] = new CheckboxCellEditor((Composite)treeViewer.getTree());
        String[] priorities = new String[]{MarkerMessages.priority_high, MarkerMessages.priority_normal, MarkerMessages.priority_low};
        cellEditors[1] = new ComboBoxCellEditor((Composite)treeViewer.getTree(), priorities, 8);
        TextCellEditor descriptionCellEditor = new TextCellEditor((Composite)treeViewer.getTree());
        cellEditors[2] = descriptionCellEditor;
        treeViewer.setCellEditors(cellEditors);
        treeViewer.setCellModifier(this.cellModifier);
        treeViewer.setColumnProperties(TABLE_COLUMN_PROPERTIES);
        this.cellEditorActionHandler = new CellEditorActionHandler(this.getViewSite().getActionBars());
        this.cellEditorActionHandler.addCellEditor((CellEditor)descriptionCellEditor);
        this.cellEditorActionHandler.setCopyAction((IAction)this.copyAction);
        this.cellEditorActionHandler.setPasteAction((IAction)this.pasteAction);
        this.cellEditorActionHandler.setDeleteAction((IAction)this.deleteAction);
        this.cellEditorActionHandler.setSelectAllAction((IAction)this.selectAllAction);
        this.cellEditorActionHandler.setUndoAction((IAction)this.undoAction);
        this.cellEditorActionHandler.setRedoAction((IAction)this.redoAction);
    }

    public void dispose() {
        if (this.cellEditorActionHandler != null) {
            this.cellEditorActionHandler.dispose();
        }
        if (this.markCompletedAction != null) {
            this.markCompletedAction.dispose();
        }
        super.dispose();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings workbenchSettings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings settings = workbenchSettings.getSection(TAG_DIALOG_SECTION);
        if (settings == null) {
            settings = workbenchSettings.addNewSection(TAG_DIALOG_SECTION);
        }
        return settings;
    }

    protected void createActions() {
        super.createActions();
        this.addGlobalTaskAction = new ActionAddGlobalTask((IWorkbenchPart)this);
        this.deleteCompletedAction = new ActionDeleteCompleted(this, (ISelectionProvider)this.getViewer());
        this.markCompletedAction = new ActionMarkCompleted((ISelectionProvider)this.getViewer());
        this.propertiesAction = new ActionTaskProperties((IWorkbenchPart)this, (ISelectionProvider)this.getViewer());
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.addGlobalTaskAction);
        manager.add((IContributionItem)new Separator());
        super.fillContextMenu(manager);
    }

    protected void fillContextMenuAdditions(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.markCompletedAction);
        manager.add((IAction)this.deleteCompletedAction);
    }

    protected IField[] getSortingFields() {
        IField[] all = new IField[this.VISIBLE_FIELDS.length + this.HIDDEN_FIELDS.length];
        System.arraycopy(this.VISIBLE_FIELDS, 0, all, 0, this.VISIBLE_FIELDS.length);
        System.arraycopy(this.HIDDEN_FIELDS, 0, all, this.VISIBLE_FIELDS.length, this.HIDDEN_FIELDS.length);
        return all;
    }

    protected IField[] getAllFields() {
        return this.getSortingFields();
    }

    protected String[] getRootTypes() {
        return ROOT_TYPES;
    }

    protected void initToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IAction)this.addGlobalTaskAction);
        super.initToolBar(toolBarManager);
    }

    public void setSelection(IStructuredSelection structuredSelection, boolean reveal) {
        super.setSelection(structuredSelection, reveal);
    }

    protected String[] getMarkerTypes() {
        return new String[]{"org.eclipse.core.resources.taskmarker"};
    }

    protected String getStaticContextId() {
        return "org.eclipse.ui.task_list_view_context";
    }

    protected DialogMarkerFilter createFiltersDialog() {
        MarkerFilter[] filters = this.getUserFilters();
        TaskFilter[] taskFilters = new TaskFilter[filters.length];
        System.arraycopy(filters, 0, taskFilters, 0, filters.length);
        return new DialogTaskFilter(this.getSite().getShell(), taskFilters);
    }

    protected MarkerFilter createFilter(String name) {
        return new TaskFilter(name);
    }

    protected String getSectionTag() {
        return TAG_DIALOG_SECTION;
    }

    String getMarkerEnablementPreferenceName() {
        return "LIMIT_TASKS";
    }

    String getMarkerLimitPreferenceName() {
        return "TASKS_LIMIT";
    }

    String getFiltersPreferenceName() {
        return "TASKS_FILTERS";
    }

    void updateDirectionIndicator(TreeColumn column) {
    }

    protected String getMarkerName() {
        return MarkerMessages.task_title;
    }

    protected IUndoContext getUndoContext() {
        return WorkspaceUndoUtil.getTasksUndoContext();
    }
}

