/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.emf.internal.xpath;

import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.eclipse.e4.emf.internal.xpath.CollectionPointer;
import org.eclipse.e4.emf.internal.xpath.EStructuralFeaturePointer;
import org.eclipse.e4.emf.internal.xpath.NullEStructuralFeaturePointer;
import org.eclipse.e4.emf.internal.xpath.NullPointer;

public class NullElementPointer
extends CollectionPointer {
    private static final long serialVersionUID = 8714236818791036721L;

    public NullElementPointer(NodePointer parent, int index) {
        super(parent, (Object)null);
        this.index = index;
    }

    public QName getName() {
        return null;
    }

    public Object getBaseValue() {
        return null;
    }

    public Object getImmediateNode() {
        return null;
    }

    public boolean isLeaf() {
        return true;
    }

    public boolean isCollection() {
        return false;
    }

    public EStructuralFeaturePointer getPropertyPointer() {
        return new NullEStructuralFeaturePointer(this);
    }

    public NodePointer getValuePointer() {
        return new NullPointer((NodePointer)this, this.getName());
    }

    public void setValue(Object value) {
        throw new UnsupportedOperationException("Collection element does not exist: " + (Object)((Object)this));
    }

    public boolean isActual() {
        return false;
    }

    public boolean isContainer() {
        return true;
    }

    public NodePointer createPath(JXPathContext context) {
        return this.parent.createChild(context, null, this.index);
    }

    public NodePointer createPath(JXPathContext context, Object value) {
        return this.parent.createChild(context, null, this.index, value);
    }

    public int hashCode() {
        return this.getImmediateParentPointer().hashCode() + this.index;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NullElementPointer)) {
            return false;
        }
        NullElementPointer other = (NullElementPointer)((Object)object);
        return this.getImmediateParentPointer() == other.getImmediateParentPointer() && this.index == other.index;
    }

    public int getLength() {
        return 0;
    }

    public String asPath() {
        StringBuffer buffer = new StringBuffer();
        NodePointer parent = this.getImmediateParentPointer();
        if (parent != null) {
            buffer.append(parent.asPath());
        }
        if (this.index != Integer.MIN_VALUE) {
            if (parent != null && parent.getIndex() != Integer.MIN_VALUE) {
                buffer.append("/.");
            } else if (parent != null && parent.getImmediateParentPointer() != null && parent.getImmediateParentPointer().getIndex() != Integer.MIN_VALUE) {
                buffer.append("/.");
            }
            buffer.append("[").append(this.index + 1).append(']');
        }
        return buffer.toString();
    }
}

