/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.optional.net.FTPConfigurator;
import org.apache.tools.ant.taskdefs.optional.net.FTPTask;
import org.apache.tools.ant.taskdefs.optional.net.FTPTaskMirror;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.RetryHandler;
import org.apache.tools.ant.util.Retryable;
import org.apache.tools.ant.util.VectorSet;

public class FTPTaskMirrorImpl
implements FTPTaskMirror {
    private static final int CODE_521 = 521;
    private static final SimpleDateFormat TIMESTAMP_LOGGING_SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private final FTPTask task;
    private Set dirCache = new HashSet();
    private int transferred = 0;
    private int skipped = 0;

    public FTPTaskMirrorImpl(FTPTask task) {
        this.task = task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isFunctioningAsDirectory(FTPClient ftp, String dir, FTPFile file) {
        boolean result = false;
        String currentWorkingDir = null;
        if (file.isDirectory()) {
            return true;
        }
        if (file.isFile()) {
            return false;
        }
        try {
            currentWorkingDir = ftp.printWorkingDirectory();
        }
        catch (IOException ioe) {
            this.task.log("could not find current working directory " + dir + " while checking a symlink", 4);
        }
        if (currentWorkingDir == null) return result;
        try {
            result = ftp.changeWorkingDirectory(file.getLink());
        }
        catch (IOException ioe) {
            this.task.log("could not cd to " + file.getLink() + " while checking a symlink", 4);
        }
        if (!result) return result;
        boolean comeback = false;
        try {
            try {
                comeback = ftp.changeWorkingDirectory(currentWorkingDir);
            }
            catch (IOException ioe) {
                this.task.log("could not cd back to " + dir + " while checking a symlink", 0);
                Object var9_11 = null;
                if (comeback) return result;
                throw new BuildException("could not cd back to " + dir + " while checking a symlink");
            }
            Object var9_10 = null;
            if (comeback) return result;
            throw new BuildException("could not cd back to " + dir + " while checking a symlink");
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (comeback) throw throwable;
            throw new BuildException("could not cd back to " + dir + " while checking a symlink");
        }
    }

    private boolean isFunctioningAsFile(FTPClient ftp, String dir, FTPFile file) {
        if (file.isDirectory()) {
            return false;
        }
        if (file.isFile()) {
            return true;
        }
        return !this.isFunctioningAsDirectory(ftp, dir, file);
    }

    protected void executeRetryable(RetryHandler h, Retryable r, String descr) throws IOException {
        h.execute(r, descr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int transferFiles(final FTPClient ftp, FileSet fs) throws IOException, BuildException {
        DirectoryScanner ds;
        if (this.task.getAction() == 0) {
            ds = fs.getDirectoryScanner(this.task.getProject());
        } else {
            ds = new FTPDirectoryScanner(ftp);
            fs.setupDirectoryScanner((FileScanner)ds, this.task.getProject());
            ds.setFollowSymlinks(fs.isFollowSymlinks());
            ds.scan();
        }
        String[] dsfiles = null;
        dsfiles = this.task.getAction() == 6 ? ds.getIncludedDirectories() : ds.getIncludedFiles();
        String dir = null;
        if (ds.getBasedir() == null && (this.task.getAction() == 0 || this.task.getAction() == 1)) {
            throw new BuildException("the dir attribute must be set for send and get actions");
        }
        if (this.task.getAction() == 0 || this.task.getAction() == 1) {
            dir = ds.getBasedir().getAbsolutePath();
        }
        BufferedWriter bw = null;
        try {
            if (this.task.getAction() == 3) {
                File pd = this.task.getListing().getParentFile();
                if (!pd.exists()) {
                    pd.mkdirs();
                }
                bw = new BufferedWriter(new FileWriter(this.task.getListing()));
            }
            RetryHandler h = new RetryHandler(this.task.getRetriesAllowed(), (Task)this.task);
            if (this.task.getAction() == 6) {
                for (int i = dsfiles.length - 1; i >= 0; --i) {
                    final String dsfile = dsfiles[i];
                    this.executeRetryable(h, new Retryable(){

                        public void execute() throws IOException {
                            FTPTaskMirrorImpl.this.rmDir(ftp, dsfile);
                        }
                    }, dsfile);
                }
            } else {
                final BufferedWriter fbw = bw;
                final String fdir = dir;
                if (this.task.isNewer()) {
                    this.task.setGranularityMillis(this.task.getTimestampGranularity().getMilliseconds(this.task.getAction()));
                }
                for (int i = 0; i < dsfiles.length; ++i) {
                    final String dsfile = dsfiles[i];
                    this.executeRetryable(h, new Retryable(){

                        public void execute() throws IOException {
                            switch (FTPTaskMirrorImpl.this.task.getAction()) {
                                case 0: {
                                    FTPTaskMirrorImpl.this.sendFile(ftp, fdir, dsfile);
                                    break;
                                }
                                case 1: {
                                    FTPTaskMirrorImpl.this.getFile(ftp, fdir, dsfile);
                                    break;
                                }
                                case 2: {
                                    FTPTaskMirrorImpl.this.delFile(ftp, dsfile);
                                    break;
                                }
                                case 3: {
                                    FTPTaskMirrorImpl.this.listFile(ftp, fbw, dsfile);
                                    break;
                                }
                                case 5: {
                                    FTPTaskMirrorImpl.this.doSiteCommand(ftp, "chmod " + FTPTaskMirrorImpl.this.task.getChmod() + " " + FTPTaskMirrorImpl.this.resolveFile(dsfile));
                                    FTPTaskMirrorImpl.this.transferred++;
                                    break;
                                }
                                default: {
                                    throw new BuildException("unknown ftp action " + FTPTaskMirrorImpl.this.task.getAction());
                                }
                            }
                        }
                    }, dsfile);
                }
            }
        }
        finally {
            if (bw != null) {
                bw.close();
            }
        }
        return dsfiles.length;
    }

    protected void transferFiles(FTPClient ftp) throws IOException, BuildException {
        this.transferred = 0;
        this.skipped = 0;
        if (this.task.getFilesets().size() == 0) {
            throw new BuildException("at least one fileset must be specified.");
        }
        for (int i = 0; i < this.task.getFilesets().size(); ++i) {
            FileSet fs = (FileSet)this.task.getFilesets().elementAt(i);
            if (fs == null) continue;
            this.transferFiles(ftp, fs);
        }
        this.task.log(this.transferred + " " + FTPTask.ACTION_TARGET_STRS[this.task.getAction()] + " " + FTPTask.COMPLETED_ACTION_STRS[this.task.getAction()]);
        if (this.skipped != 0) {
            this.task.log(this.skipped + " " + FTPTask.ACTION_TARGET_STRS[this.task.getAction()] + " were not successfully " + FTPTask.COMPLETED_ACTION_STRS[this.task.getAction()]);
        }
    }

    protected String resolveFile(String file) {
        return file.replace(System.getProperty("file.separator").charAt(0), this.task.getSeparator().charAt(0));
    }

    protected void createParents(FTPClient ftp, String filename) throws IOException, BuildException {
        File checkDir;
        String dirname;
        File dir = new File(filename);
        if (this.dirCache.contains(dir)) {
            return;
        }
        Vector<File> parents = new Vector<File>();
        while ((dirname = dir.getParent()) != null && !this.dirCache.contains(checkDir = new File(dirname))) {
            dir = checkDir;
            parents.addElement(dir);
        }
        int i = parents.size() - 1;
        if (i >= 0) {
            String cwd = ftp.printWorkingDirectory();
            String parent = dir.getParent();
            if (parent != null && !ftp.changeWorkingDirectory(this.resolveFile(parent))) {
                throw new BuildException("could not change to directory: " + ftp.getReplyString());
            }
            while (i >= 0) {
                if (!ftp.changeWorkingDirectory((dir = (File)parents.elementAt(i--)).getName())) {
                    this.task.log("creating remote directory " + this.resolveFile(dir.getPath()), 3);
                    if (!ftp.makeDirectory(dir.getName())) {
                        this.handleMkDirFailure(ftp);
                    }
                    if (!ftp.changeWorkingDirectory(dir.getName())) {
                        throw new BuildException("could not change to directory: " + ftp.getReplyString());
                    }
                }
                this.dirCache.add(dir);
            }
            ftp.changeWorkingDirectory(cwd);
        }
    }

    private long getTimeDiff(FTPClient ftp) {
        long returnValue = 0L;
        File tempFile = this.findFileName(ftp);
        try {
            FILE_UTILS.createNewFile(tempFile);
            long localTimeStamp = tempFile.lastModified();
            BufferedInputStream instream = new BufferedInputStream(new FileInputStream(tempFile));
            ftp.storeFile(tempFile.getName(), (InputStream)instream);
            instream.close();
            boolean success = FTPReply.isPositiveCompletion((int)ftp.getReplyCode());
            if (success) {
                FTPFile[] ftpFiles = ftp.listFiles(tempFile.getName());
                if (ftpFiles.length == 1) {
                    long remoteTimeStamp = ftpFiles[0].getTimestamp().getTime().getTime();
                    returnValue = localTimeStamp - remoteTimeStamp;
                }
                ftp.deleteFile(ftpFiles[0].getName());
            }
            Delete mydelete = new Delete();
            mydelete.bindToOwner((Task)this.task);
            mydelete.setFile(tempFile.getCanonicalFile());
            mydelete.execute();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e, this.task.getLocation());
        }
        return returnValue;
    }

    private File findFileName(FTPClient ftp) {
        FTPFile[] theFiles = null;
        int maxIterations = 1000;
        for (int counter = 1; counter < 1000; ++counter) {
            File localFile = FILE_UTILS.createTempFile("ant" + Integer.toString(counter), ".tmp", null, false, false);
            String fileName = localFile.getName();
            boolean found = false;
            try {
                if (theFiles == null) {
                    theFiles = ftp.listFiles();
                }
                for (int counter2 = 0; counter2 < theFiles.length; ++counter2) {
                    if (theFiles[counter2] == null || !theFiles[counter2].getName().equals(fileName)) continue;
                    found = true;
                    break;
                }
            }
            catch (IOException ioe) {
                throw new BuildException((Throwable)ioe, this.task.getLocation());
            }
            if (found) continue;
            localFile.deleteOnExit();
            return localFile;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isUpToDate(FTPClient ftp, File localFile, String remoteFile) throws IOException, BuildException {
        StringBuffer msg;
        this.task.log("checking date for " + remoteFile, 3);
        FTPFile[] files = ftp.listFiles(remoteFile);
        if (files == null || files.length == 0) {
            if (this.task.getAction() == 0) {
                this.task.log("Could not date test remote file: " + remoteFile + "assuming out of date.", 3);
                return false;
            }
            throw new BuildException("could not date test remote file: " + ftp.getReplyString());
        }
        long remoteTimestamp = files[0].getTimestamp().getTime().getTime();
        long localTimestamp = localFile.lastModified();
        long adjustedRemoteTimestamp = remoteTimestamp + this.task.getTimeDiffMillis() + this.task.getGranularityMillis();
        SimpleDateFormat simpleDateFormat = TIMESTAMP_LOGGING_SDF;
        synchronized (simpleDateFormat) {
            msg = new StringBuffer("   [").append(TIMESTAMP_LOGGING_SDF.format(new Date(localTimestamp))).append("] local");
        }
        this.task.log(msg.toString(), 3);
        simpleDateFormat = TIMESTAMP_LOGGING_SDF;
        synchronized (simpleDateFormat) {
            msg = new StringBuffer("   [").append(TIMESTAMP_LOGGING_SDF.format(new Date(adjustedRemoteTimestamp))).append("] remote");
        }
        if (remoteTimestamp != adjustedRemoteTimestamp) {
            simpleDateFormat = TIMESTAMP_LOGGING_SDF;
            synchronized (simpleDateFormat) {
                msg.append(" - (raw: ").append(TIMESTAMP_LOGGING_SDF.format(new Date(remoteTimestamp))).append(")");
            }
        }
        this.task.log(msg.toString(), 3);
        if (this.task.getAction() == 0) {
            return adjustedRemoteTimestamp >= localTimestamp;
        }
        return localTimestamp >= adjustedRemoteTimestamp;
    }

    protected void doSiteCommand(FTPClient ftp, String theCMD) throws IOException, BuildException {
        String[] myReply = null;
        this.task.log("Doing Site Command: " + theCMD, 3);
        boolean rc = ftp.sendSiteCommand(theCMD);
        if (!rc) {
            this.task.log("Failed to issue Site Command: " + theCMD, 1);
        } else {
            myReply = ftp.getReplyStrings();
            for (int x = 0; x < myReply.length; ++x) {
                if (myReply[x].indexOf("200") != -1) continue;
                this.task.log(myReply[x], 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void sendFile(FTPClient ftp, String dir, String filename) throws IOException, BuildException {
        block13: {
            instream = null;
            try {
                file = this.task.getProject().resolveFile(new File(dir, filename).getPath());
                if (!this.task.isNewer() || !this.isUpToDate(ftp, file, this.resolveFile(filename))) break block14;
                var9_6 = null;
                ** if (instream == null) goto lbl-1000
            }
            catch (Throwable var8_14) {
                var9_8 = null;
                if (instream != null) {
                    try {
                        instream.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                throw var8_14;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    instream.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
lbl-1000:
            // 3 sources

            {
                block14: {
                    return;
                }
                if (this.task.isVerbose()) {
                    this.task.log("transferring " + file.getAbsolutePath());
                }
                instream = new BufferedInputStream(new FileInputStream(file));
                this.createParents(ftp, filename);
                ftp.storeFile(this.resolveFile(filename), instream);
                success = FTPReply.isPositiveCompletion((int)ftp.getReplyCode());
                if (!success) {
                    s = "could not put file: " + ftp.getReplyString();
                    if (this.task.isSkipFailedTransfers()) {
                        this.task.log(s, 1);
                        ++this.skipped;
                        break block13;
                    }
                    throw new BuildException(s);
                }
                if (this.task.getChmod() != null) {
                    this.doSiteCommand(ftp, "chmod " + this.task.getChmod() + " " + this.resolveFile(filename));
                }
                this.task.log("File " + file.getAbsolutePath() + " copied to " + this.task.getServer(), 3);
                ++this.transferred;
            }
        }
        var9_7 = null;
        if (instream != null) {
            try {
                instream.close();
            }
            catch (IOException ex) {}
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void delFile(FTPClient ftp, String filename) throws IOException, BuildException {
        if (this.task.isVerbose()) {
            this.task.log("deleting " + filename);
        }
        if (!ftp.deleteFile(this.resolveFile(filename))) {
            String s = "could not delete file: " + ftp.getReplyString();
            if (!this.task.isSkipFailedTransfers()) throw new BuildException(s);
            this.task.log(s, 1);
            ++this.skipped;
            return;
        } else {
            this.task.log("File " + filename + " deleted from " + this.task.getServer(), 3);
            ++this.transferred;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void rmDir(FTPClient ftp, String dirname) throws IOException, BuildException {
        if (this.task.isVerbose()) {
            this.task.log("removing " + dirname);
        }
        if (!ftp.removeDirectory(this.resolveFile(dirname))) {
            String s = "could not remove directory: " + ftp.getReplyString();
            if (!this.task.isSkipFailedTransfers()) throw new BuildException(s);
            this.task.log(s, 1);
            ++this.skipped;
            return;
        } else {
            this.task.log("Directory " + dirname + " removed from " + this.task.getServer(), 3);
            ++this.transferred;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void getFile(FTPClient ftp, String dir, String filename) throws IOException, BuildException {
        block13: {
            outstream = null;
            try {
                file = this.task.getProject().resolveFile(new File(dir, filename).getPath());
                if (!this.task.isNewer() || !this.isUpToDate(ftp, file, this.resolveFile(filename))) break block14;
                var9_6 = null;
                ** if (outstream == null) goto lbl-1000
            }
            catch (Throwable var8_15) {
                var9_8 = null;
                if (outstream != null) {
                    try {
                        outstream.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                throw var8_15;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    outstream.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
lbl-1000:
            // 3 sources

            {
                block14: {
                    return;
                }
                if (this.task.isVerbose()) {
                    this.task.log("transferring " + filename + " to " + file.getAbsolutePath());
                }
                if (!(pdir = file.getParentFile()).exists()) {
                    pdir.mkdirs();
                }
                outstream = new BufferedOutputStream(new FileOutputStream(file));
                ftp.retrieveFile(this.resolveFile(filename), outstream);
                if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                    s = "could not get file: " + ftp.getReplyString();
                    if (this.task.isSkipFailedTransfers()) {
                        this.task.log(s, 1);
                        ++this.skipped;
                        break block13;
                    }
                    throw new BuildException(s);
                }
                this.task.log("File " + file.getAbsolutePath() + " copied from " + this.task.getServer(), 3);
                ++this.transferred;
                if (!this.task.isPreserveLastModified()) break block13;
                outstream.close();
                outstream = null;
                remote = ftp.listFiles(this.resolveFile(filename));
                if (remote.length <= 0) break block13;
                FTPTaskMirrorImpl.FILE_UTILS.setFileLastModified(file, remote[0].getTimestamp().getTime().getTime());
            }
        }
        var9_7 = null;
        if (outstream != null) {
            try {
                outstream.close();
            }
            catch (IOException ex) {}
        }
    }

    protected void listFile(FTPClient ftp, BufferedWriter bw, String filename) throws IOException, BuildException {
        FTPFile[] ftpfiles;
        if (this.task.isVerbose()) {
            this.task.log("listing " + filename);
        }
        if ((ftpfiles = ftp.listFiles(this.resolveFile(filename))) != null && ftpfiles.length > 0) {
            bw.write(ftpfiles[0].toString());
            bw.newLine();
            ++this.transferred;
        }
    }

    protected void makeRemoteDir(FTPClient ftp, String dir) throws IOException, BuildException {
        String workingDirectory = ftp.printWorkingDirectory();
        if (this.task.isVerbose()) {
            if (dir.indexOf("/") == 0 || workingDirectory == null) {
                this.task.log("Creating directory: " + dir + " in /");
            } else {
                this.task.log("Creating directory: " + dir + " in " + workingDirectory);
            }
        }
        if (dir.indexOf("/") == 0) {
            ftp.changeWorkingDirectory("/");
        }
        String subdir = "";
        StringTokenizer st = new StringTokenizer(dir, "/");
        while (st.hasMoreTokens()) {
            subdir = st.nextToken();
            this.task.log("Checking " + subdir, 4);
            if (ftp.changeWorkingDirectory(subdir)) continue;
            if (!ftp.makeDirectory(subdir)) {
                int rc = ftp.getReplyCode();
                if (!this.task.isIgnoreNoncriticalErrors() || rc != 550 && rc != 553 && rc != 521) {
                    throw new BuildException("could not create directory: " + ftp.getReplyString());
                }
                if (!this.task.isVerbose()) continue;
                this.task.log("Directory already exists");
                continue;
            }
            if (this.task.isVerbose()) {
                this.task.log("Directory created OK");
            }
            ftp.changeWorkingDirectory(subdir);
        }
        if (workingDirectory != null) {
            ftp.changeWorkingDirectory(workingDirectory);
        }
    }

    private void handleMkDirFailure(FTPClient ftp) throws BuildException {
        int rc = ftp.getReplyCode();
        if (!this.task.isIgnoreNoncriticalErrors() || rc != 550 && rc != 553 && rc != 521) {
            throw new BuildException("could not create directory: " + ftp.getReplyString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFTP() throws BuildException {
        FTPClient ftp = null;
        try {
            block26: {
                try {
                    FTPClient lftp;
                    RetryHandler h;
                    this.task.log("Opening FTP connection to " + this.task.getServer(), 3);
                    ftp = new FTPClient();
                    if (this.task.isConfigurationSet()) {
                        ftp = FTPConfigurator.configure(ftp, this.task);
                    }
                    ftp.setRemoteVerificationEnabled(this.task.getEnableRemoteVerification());
                    ftp.connect(this.task.getServer(), this.task.getPort());
                    if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                        throw new BuildException("FTP connection failed: " + ftp.getReplyString());
                    }
                    this.task.log("connected", 3);
                    this.task.log("logging in to FTP server", 3);
                    if (this.task.getAccount() != null) {
                        if (!ftp.login(this.task.getUserid(), this.task.getPassword(), this.task.getAccount())) throw new BuildException("Could not login to FTP server");
                    }
                    if (this.task.getAccount() == null && !ftp.login(this.task.getUserid(), this.task.getPassword())) {
                        throw new BuildException("Could not login to FTP server");
                    }
                    this.task.log("login succeeded", 3);
                    if (this.task.isBinary()) {
                        ftp.setFileType(2);
                        if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                            throw new BuildException("could not set transfer type: " + ftp.getReplyString());
                        }
                    } else {
                        ftp.setFileType(0);
                        if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                            throw new BuildException("could not set transfer type: " + ftp.getReplyString());
                        }
                    }
                    if (this.task.isPassive()) {
                        this.task.log("entering passive mode", 3);
                        ftp.enterLocalPassiveMode();
                        if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                            throw new BuildException("could not enter into passive mode: " + ftp.getReplyString());
                        }
                    }
                    if (this.task.getInitialSiteCommand() != null) {
                        h = new RetryHandler(this.task.getRetriesAllowed(), (Task)this.task);
                        lftp = ftp;
                        this.executeRetryable(h, new Retryable(){

                            public void execute() throws IOException {
                                FTPTaskMirrorImpl.this.doSiteCommand(lftp, FTPTaskMirrorImpl.this.task.getInitialSiteCommand());
                            }
                        }, "initial site command: " + this.task.getInitialSiteCommand());
                    }
                    if (this.task.getUmask() != null) {
                        h = new RetryHandler(this.task.getRetriesAllowed(), (Task)this.task);
                        lftp = ftp;
                        this.executeRetryable(h, new Retryable(){

                            public void execute() throws IOException {
                                FTPTaskMirrorImpl.this.doSiteCommand(lftp, "umask " + FTPTaskMirrorImpl.this.task.getUmask());
                            }
                        }, "umask " + this.task.getUmask());
                    }
                    if (this.task.getAction() == 4) {
                        h = new RetryHandler(this.task.getRetriesAllowed(), (Task)this.task);
                        lftp = ftp;
                        this.executeRetryable(h, new Retryable(){

                            public void execute() throws IOException {
                                FTPTaskMirrorImpl.this.makeRemoteDir(lftp, FTPTaskMirrorImpl.this.task.getRemotedir());
                            }
                        }, this.task.getRemotedir());
                        break block26;
                    }
                    if (this.task.getAction() == 7) {
                        h = new RetryHandler(this.task.getRetriesAllowed(), (Task)this.task);
                        lftp = ftp;
                        this.executeRetryable(h, new Retryable(){

                            public void execute() throws IOException {
                                FTPTaskMirrorImpl.this.doSiteCommand(lftp, FTPTaskMirrorImpl.this.task.getSiteCommand());
                            }
                        }, "Site Command: " + this.task.getSiteCommand());
                    } else {
                        if (this.task.getRemotedir() != null) {
                            this.task.log("changing the remote directory", 3);
                            ftp.changeWorkingDirectory(this.task.getRemotedir());
                            if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                                throw new BuildException("could not change remote directory: " + ftp.getReplyString());
                            }
                        }
                        if (this.task.isNewer() && this.task.isTimeDiffAuto()) {
                            this.task.setTimeDiffMillis(this.getTimeDiff(ftp));
                        }
                        this.task.log(FTPTask.ACTION_STRS[this.task.getAction()] + " " + FTPTask.ACTION_TARGET_STRS[this.task.getAction()]);
                        this.transferFiles(ftp);
                    }
                }
                catch (IOException ex) {
                    throw new BuildException("error during FTP transfer: " + ex, (Throwable)ex);
                }
            }
            Object var5_5 = null;
            if (ftp == null) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (ftp == null) throw throwable;
            if (!ftp.isConnected()) throw throwable;
            try {
                this.task.log("disconnecting", 3);
                ftp.logout();
                ftp.disconnect();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        if (!ftp.isConnected()) return;
        try {}
        catch (IOException ex) {}
        this.task.log("disconnecting", 3);
        ftp.logout();
        ftp.disconnect();
        return;
    }

    protected class FTPDirectoryScanner
    extends DirectoryScanner {
        protected FTPClient ftp = null;
        private String rootPath = null;
        private boolean remoteSystemCaseSensitive = false;
        private boolean remoteSensitivityChecked = false;
        private Map fileListMap = new HashMap();
        private Map scannedDirs = new HashMap();

        public FTPDirectoryScanner(FTPClient ftp) {
            this.ftp = ftp;
            this.setFollowSymlinks(false);
        }

        public void scan() {
            if (this.includes == null) {
                this.includes = new String[1];
                this.includes[0] = "**";
            }
            if (this.excludes == null) {
                this.excludes = new String[0];
            }
            this.filesIncluded = new VectorSet();
            this.filesNotIncluded = new Vector();
            this.filesExcluded = new VectorSet();
            this.dirsIncluded = new VectorSet();
            this.dirsNotIncluded = new Vector();
            this.dirsExcluded = new VectorSet();
            try {
                String cwd = this.ftp.printWorkingDirectory();
                this.forceRemoteSensitivityCheck();
                this.checkIncludePatterns();
                this.clearCaches();
                this.ftp.changeWorkingDirectory(cwd);
            }
            catch (IOException e) {
                throw new BuildException("Unable to scan FTP server: ", (Throwable)e);
            }
        }

        private void checkIncludePatterns() {
            Hashtable<String, String> newroots = new Hashtable<String, String>();
            for (int icounter = 0; icounter < this.includes.length; ++icounter) {
                String newpattern = SelectorUtils.rtrimWildcardTokens((String)this.includes[icounter]);
                newroots.put(newpattern, this.includes[icounter]);
            }
            if (FTPTaskMirrorImpl.this.task.getRemotedir() == null) {
                try {
                    FTPTaskMirrorImpl.this.task.setRemotedir(this.ftp.printWorkingDirectory());
                }
                catch (IOException e) {
                    throw new BuildException("could not read current ftp directory", FTPTaskMirrorImpl.this.task.getLocation());
                }
            }
            AntFTPRootFile baseFTPFile = new AntFTPRootFile(this.ftp, FTPTaskMirrorImpl.this.task.getRemotedir());
            this.rootPath = ((AntFTPFile)baseFTPFile).getAbsolutePath();
            if (newroots.containsKey("")) {
                this.scandir(this.rootPath, "", true);
            } else {
                Enumeration enum2 = newroots.keys();
                while (enum2.hasMoreElements()) {
                    String currentelement = (String)enum2.nextElement();
                    String originalpattern = (String)newroots.get(currentelement);
                    AntFTPFile myfile = new AntFTPFile(baseFTPFile, currentelement);
                    boolean isOK = true;
                    boolean traversesSymlinks = false;
                    String path = null;
                    if (myfile.exists()) {
                        this.forceRemoteSensitivityCheck();
                        if (this.remoteSensitivityChecked && this.remoteSystemCaseSensitive && this.isFollowSymlinks()) {
                            path = myfile.getFastRelativePath();
                        } else {
                            try {
                                path = myfile.getRelativePath();
                                traversesSymlinks = myfile.isTraverseSymlinks();
                            }
                            catch (IOException be) {
                                throw new BuildException((Throwable)be, FTPTaskMirrorImpl.this.task.getLocation());
                            }
                            catch (BuildException be) {
                                isOK = false;
                            }
                        }
                    } else {
                        isOK = false;
                    }
                    if (!isOK) continue;
                    currentelement = path.replace(FTPTaskMirrorImpl.this.task.getSeparator().charAt(0), File.separatorChar);
                    if (!this.isFollowSymlinks() && traversesSymlinks) continue;
                    if (myfile.isDirectory()) {
                        if (this.isIncluded(currentelement) && currentelement.length() > 0) {
                            this.accountForIncludedDir(currentelement, myfile, true);
                            continue;
                        }
                        if (currentelement.length() > 0 && currentelement.charAt(currentelement.length() - 1) != File.separatorChar) {
                            currentelement = currentelement + File.separatorChar;
                        }
                        this.scandir(myfile.getAbsolutePath(), currentelement, true);
                        continue;
                    }
                    if (this.isCaseSensitive && originalpattern.equals(currentelement)) {
                        this.accountForIncludedFile(currentelement);
                        continue;
                    }
                    if (this.isCaseSensitive || !originalpattern.equalsIgnoreCase(currentelement)) continue;
                    this.accountForIncludedFile(currentelement);
                }
            }
        }

        protected void scandir(String dir, String vpath, boolean fast) {
            if (fast && this.hasBeenScanned(vpath)) {
                return;
            }
            try {
                if (!this.ftp.changeWorkingDirectory(dir)) {
                    return;
                }
                String completePath = null;
                completePath = !vpath.equals("") ? this.rootPath + FTPTaskMirrorImpl.this.task.getSeparator() + vpath.replace(File.separatorChar, FTPTaskMirrorImpl.this.task.getSeparator().charAt(0)) : this.rootPath;
                FTPFile[] newfiles = this.listFiles(completePath, false);
                if (newfiles == null) {
                    this.ftp.changeToParentDirectory();
                    return;
                }
                for (int i = 0; i < newfiles.length; ++i) {
                    FTPFile file = newfiles[i];
                    if (file == null || file.getName().equals(".") || file.getName().equals("..")) continue;
                    String name = vpath + file.getName();
                    this.scannedDirs.put(name, new FTPFileProxy(file));
                    if (FTPTaskMirrorImpl.this.isFunctioningAsDirectory(this.ftp, dir, file)) {
                        boolean slowScanAllowed = true;
                        if (!this.isFollowSymlinks() && file.isSymbolicLink()) {
                            this.dirsExcluded.addElement(name);
                            slowScanAllowed = false;
                        } else if (this.isIncluded(name)) {
                            this.accountForIncludedDir(name, new AntFTPFile(this.ftp, file, completePath), fast);
                        } else {
                            this.dirsNotIncluded.addElement(name);
                            if (fast && this.couldHoldIncluded(name)) {
                                this.scandir(file.getName(), name + File.separator, fast);
                            }
                        }
                        if (fast || !slowScanAllowed) continue;
                        this.scandir(file.getName(), name + File.separator, fast);
                        continue;
                    }
                    if (!this.isFollowSymlinks() && file.isSymbolicLink()) {
                        this.filesExcluded.addElement(name);
                        continue;
                    }
                    if (!FTPTaskMirrorImpl.this.isFunctioningAsFile(this.ftp, dir, file)) continue;
                    this.accountForIncludedFile(name);
                }
                this.ftp.changeToParentDirectory();
            }
            catch (IOException e) {
                throw new BuildException("Error while communicating with FTP server: ", (Throwable)e);
            }
        }

        private void accountForIncludedFile(String name) {
            if (!this.filesIncluded.contains(name) && !this.filesExcluded.contains(name)) {
                if (this.isIncluded(name)) {
                    if (!this.isExcluded(name) && this.isSelected(name, (File)this.scannedDirs.get(name))) {
                        this.filesIncluded.addElement(name);
                    } else {
                        this.filesExcluded.addElement(name);
                    }
                } else {
                    this.filesNotIncluded.addElement(name);
                }
            }
        }

        private void accountForIncludedDir(String name, AntFTPFile file, boolean fast) {
            if (!this.dirsIncluded.contains(name) && !this.dirsExcluded.contains(name)) {
                if (!this.isExcluded(name)) {
                    if (fast) {
                        if (file.isSymbolicLink()) {
                            try {
                                file.getClient().changeWorkingDirectory(file.curpwd);
                            }
                            catch (IOException ioe) {
                                throw new BuildException("could not change directory to curpwd");
                            }
                            this.scandir(file.getLink(), name + File.separator, fast);
                        } else {
                            try {
                                file.getClient().changeWorkingDirectory(file.curpwd);
                            }
                            catch (IOException ioe) {
                                throw new BuildException("could not change directory to curpwd");
                            }
                            this.scandir(file.getName(), name + File.separator, fast);
                        }
                    }
                    this.dirsIncluded.addElement(name);
                } else {
                    this.dirsExcluded.addElement(name);
                    if (fast && this.couldHoldIncluded(name)) {
                        try {
                            file.getClient().changeWorkingDirectory(file.curpwd);
                        }
                        catch (IOException ioe) {
                            throw new BuildException("could not change directory to curpwd");
                        }
                        this.scandir(file.getName(), name + File.separator, fast);
                    }
                }
            }
        }

        private boolean hasBeenScanned(String vpath) {
            return this.scannedDirs.containsKey(vpath);
        }

        private void clearCaches() {
            this.fileListMap.clear();
            this.scannedDirs.clear();
        }

        public FTPFile[] listFiles(String directory, boolean changedir) {
            String currentPath = directory;
            if (changedir) {
                try {
                    boolean result = this.ftp.changeWorkingDirectory(directory);
                    if (!result) {
                        return null;
                    }
                    currentPath = this.ftp.printWorkingDirectory();
                }
                catch (IOException ioe) {
                    throw new BuildException((Throwable)ioe, FTPTaskMirrorImpl.this.task.getLocation());
                }
            }
            if (this.fileListMap.containsKey(currentPath)) {
                FTPTaskMirrorImpl.this.task.log("filelist map used in listing files", 4);
                return (FTPFile[])this.fileListMap.get(currentPath);
            }
            FTPFile[] result = null;
            try {
                result = this.ftp.listFiles();
            }
            catch (IOException ioe) {
                throw new BuildException((Throwable)ioe, FTPTaskMirrorImpl.this.task.getLocation());
            }
            this.fileListMap.put(currentPath, result);
            if (!this.remoteSensitivityChecked) {
                this.checkRemoteSensitivity(result, directory);
            }
            return result;
        }

        private void forceRemoteSensitivityCheck() {
            if (!this.remoteSensitivityChecked) {
                try {
                    this.checkRemoteSensitivity(this.ftp.listFiles(), this.ftp.printWorkingDirectory());
                }
                catch (IOException ioe) {
                    throw new BuildException((Throwable)ioe, FTPTaskMirrorImpl.this.task.getLocation());
                }
            }
        }

        public FTPFile[] listFiles(String directory) {
            return this.listFiles(directory, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void checkRemoteSensitivity(FTPFile[] array, String directory) {
            if (array == null) {
                return;
            }
            boolean candidateFound = false;
            String target = null;
            for (int icounter = 0; icounter < array.length; ++icounter) {
                if (array[icounter] == null || !array[icounter].isDirectory() || array[icounter].getName().equals(".") || array[icounter].getName().equals("..")) continue;
                candidateFound = true;
                target = this.fiddleName(array[icounter].getName());
                FTPTaskMirrorImpl.this.task.log("will try to cd to " + target + " where a directory called " + array[icounter].getName() + " exists", 4);
                for (int pcounter = 0; pcounter < array.length; ++pcounter) {
                    if (array[pcounter] == null || pcounter == icounter || !target.equals(array[pcounter].getName())) continue;
                    candidateFound = false;
                }
                if (candidateFound) break;
            }
            if (!candidateFound) return;
            try {
                try {
                    FTPTaskMirrorImpl.this.task.log("testing case sensitivity, attempting to cd to " + target, 4);
                    this.remoteSystemCaseSensitive = !this.ftp.changeWorkingDirectory(target);
                }
                catch (IOException ioe) {
                    this.remoteSystemCaseSensitive = true;
                    Object var8_9 = null;
                    try {
                        this.ftp.changeWorkingDirectory(directory);
                    }
                    catch (IOException ioe2) {
                        throw new BuildException((Throwable)ioe2, FTPTaskMirrorImpl.this.task.getLocation());
                    }
                }
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {}
                catch (IOException ioe2) {
                    throw new BuildException((Throwable)ioe2, FTPTaskMirrorImpl.this.task.getLocation());
                }
                this.ftp.changeWorkingDirectory(directory);
                throw throwable;
            }
            try {}
            catch (IOException ioe2) {
                throw new BuildException((Throwable)ioe2, FTPTaskMirrorImpl.this.task.getLocation());
            }
            this.ftp.changeWorkingDirectory(directory);
            FTPTaskMirrorImpl.this.task.log("remote system is case sensitive : " + this.remoteSystemCaseSensitive, 3);
            this.remoteSensitivityChecked = true;
        }

        private String fiddleName(String origin) {
            StringBuffer result = new StringBuffer();
            for (int icounter = 0; icounter < origin.length(); ++icounter) {
                if (Character.isLowerCase(origin.charAt(icounter))) {
                    result.append(Character.toUpperCase(origin.charAt(icounter)));
                    continue;
                }
                if (Character.isUpperCase(origin.charAt(icounter))) {
                    result.append(Character.toLowerCase(origin.charAt(icounter)));
                    continue;
                }
                result.append(origin.charAt(icounter));
            }
            return result.toString();
        }

        protected class AntFTPFile {
            private FTPClient client;
            private String curpwd;
            private FTPFile ftpFile;
            private AntFTPFile parent = null;
            private boolean relativePathCalculated = false;
            private boolean traversesSymlinks = false;
            private String relativePath = "";

            public AntFTPFile(FTPClient client, FTPFile ftpFile, String curpwd) {
                this.client = client;
                this.ftpFile = ftpFile;
                this.curpwd = curpwd;
            }

            public AntFTPFile(AntFTPFile parent, String path) {
                this.parent = parent;
                this.client = parent.client;
                Vector pathElements = SelectorUtils.tokenizePath((String)path);
                try {
                    boolean result = this.client.changeWorkingDirectory(parent.getAbsolutePath());
                    if (!result) {
                        return;
                    }
                    this.curpwd = parent.getAbsolutePath();
                }
                catch (IOException ioe) {
                    throw new BuildException("could not change working dir to " + parent.curpwd);
                }
                for (int fcount = 0; fcount < pathElements.size() - 1; ++fcount) {
                    String currentPathElement = (String)pathElements.elementAt(fcount);
                    try {
                        boolean result = this.client.changeWorkingDirectory(currentPathElement);
                        if (!result && !FTPDirectoryScanner.this.isCaseSensitive() && (FTPDirectoryScanner.this.remoteSystemCaseSensitive || !FTPDirectoryScanner.this.remoteSensitivityChecked) ? (currentPathElement = this.findPathElementCaseUnsensitive(this.curpwd, currentPathElement)) == null : !result) {
                            return;
                        }
                        this.curpwd = this.getCurpwdPlusFileSep() + currentPathElement;
                        continue;
                    }
                    catch (IOException ioe) {
                        throw new BuildException("could not change working dir to " + (String)pathElements.elementAt(fcount) + " from " + this.curpwd);
                    }
                }
                String lastpathelement = (String)pathElements.elementAt(pathElements.size() - 1);
                FTPFile[] theFiles = FTPDirectoryScanner.this.listFiles(this.curpwd);
                this.ftpFile = this.getFile(theFiles, lastpathelement);
            }

            private String findPathElementCaseUnsensitive(String parentPath, String soughtPathElement) {
                FTPFile[] theFiles = FTPDirectoryScanner.this.listFiles(parentPath, false);
                if (theFiles == null) {
                    return null;
                }
                for (int icounter = 0; icounter < theFiles.length; ++icounter) {
                    if (theFiles[icounter] == null || !theFiles[icounter].getName().equalsIgnoreCase(soughtPathElement)) continue;
                    return theFiles[icounter].getName();
                }
                return null;
            }

            public boolean exists() {
                return this.ftpFile != null;
            }

            public String getLink() {
                return this.ftpFile.getLink();
            }

            public String getName() {
                return this.ftpFile.getName();
            }

            public String getAbsolutePath() {
                return this.getCurpwdPlusFileSep() + this.ftpFile.getName();
            }

            public String getFastRelativePath() {
                String absPath = this.getAbsolutePath();
                if (absPath.indexOf(FTPDirectoryScanner.this.rootPath + FTPTaskMirrorImpl.this.task.getSeparator()) == 0) {
                    return absPath.substring(FTPDirectoryScanner.this.rootPath.length() + FTPTaskMirrorImpl.this.task.getSeparator().length());
                }
                return null;
            }

            public String getRelativePath() throws IOException, BuildException {
                if (!this.relativePathCalculated) {
                    if (this.parent != null) {
                        this.traversesSymlinks = this.parent.isTraverseSymlinks();
                        this.relativePath = this.getRelativePath(this.parent.getAbsolutePath(), this.parent.getRelativePath());
                    } else {
                        this.relativePath = this.getRelativePath(FTPDirectoryScanner.this.rootPath, "");
                        this.relativePathCalculated = true;
                    }
                }
                return this.relativePath;
            }

            private String getRelativePath(String currentPath, String currentRelativePath) {
                Vector pathElements = SelectorUtils.tokenizePath((String)this.getAbsolutePath(), (String)FTPTaskMirrorImpl.this.task.getSeparator());
                Vector pathElements2 = SelectorUtils.tokenizePath((String)currentPath, (String)FTPTaskMirrorImpl.this.task.getSeparator());
                String relPath = currentRelativePath;
                for (int pcount = pathElements2.size(); pcount < pathElements.size(); ++pcount) {
                    String currentElement = (String)pathElements.elementAt(pcount);
                    FTPFile[] theFiles = FTPDirectoryScanner.this.listFiles(currentPath);
                    FTPFile theFile = null;
                    if (theFiles != null) {
                        theFile = this.getFile(theFiles, currentElement);
                    }
                    if (!relPath.equals("")) {
                        relPath = relPath + FTPTaskMirrorImpl.this.task.getSeparator();
                    }
                    if (theFile == null) {
                        relPath = relPath + currentElement;
                        currentPath = currentPath + FTPTaskMirrorImpl.this.task.getSeparator() + currentElement;
                        FTPTaskMirrorImpl.this.task.log("Hidden file " + relPath + " assumed to not be a symlink.", 3);
                        continue;
                    }
                    this.traversesSymlinks = this.traversesSymlinks || theFile.isSymbolicLink();
                    relPath = relPath + theFile.getName();
                    currentPath = currentPath + FTPTaskMirrorImpl.this.task.getSeparator() + theFile.getName();
                }
                return relPath;
            }

            public FTPFile getFile(FTPFile[] theFiles, String lastpathelement) {
                if (theFiles == null) {
                    return null;
                }
                for (int fcount = 0; fcount < theFiles.length; ++fcount) {
                    if (theFiles[fcount] == null) continue;
                    if (theFiles[fcount].getName().equals(lastpathelement)) {
                        return theFiles[fcount];
                    }
                    if (FTPDirectoryScanner.this.isCaseSensitive() || !theFiles[fcount].getName().equalsIgnoreCase(lastpathelement)) continue;
                    return theFiles[fcount];
                }
                return null;
            }

            public boolean isDirectory() {
                return this.ftpFile.isDirectory();
            }

            public boolean isSymbolicLink() {
                return this.ftpFile.isSymbolicLink();
            }

            protected FTPClient getClient() {
                return this.client;
            }

            protected void setCurpwd(String curpwd) {
                this.curpwd = curpwd;
            }

            public String getCurpwd() {
                return this.curpwd;
            }

            public String getCurpwdPlusFileSep() {
                String sep = FTPTaskMirrorImpl.this.task.getSeparator();
                return this.curpwd.endsWith(sep) ? this.curpwd : this.curpwd + sep;
            }

            public boolean isTraverseSymlinks() throws IOException, BuildException {
                if (!this.relativePathCalculated) {
                    this.getRelativePath();
                }
                return this.traversesSymlinks;
            }

            public String toString() {
                return "AntFtpFile: " + this.curpwd + "%" + this.ftpFile;
            }
        }

        protected class AntFTPRootFile
        extends AntFTPFile {
            private String remotedir;

            public AntFTPRootFile(FTPClient aclient, String remotedir) {
                super(aclient, null, remotedir);
                this.remotedir = remotedir;
                try {
                    this.getClient().changeWorkingDirectory(this.remotedir);
                    this.setCurpwd(this.getClient().printWorkingDirectory());
                }
                catch (IOException ioe) {
                    throw new BuildException((Throwable)ioe, FTPTaskMirrorImpl.this.task.getLocation());
                }
            }

            public String getAbsolutePath() {
                return this.getCurpwd();
            }

            public String getRelativePath() throws BuildException, IOException {
                return "";
            }
        }
    }

    protected static class FTPFileProxy
    extends File {
        private final FTPFile file;
        private final String[] parts;
        private final String name;

        public FTPFileProxy(FTPFile file) {
            super(file.getName());
            this.name = file.getName();
            this.file = file;
            this.parts = FileUtils.getPathStack((String)this.name);
        }

        public FTPFileProxy(String completePath) {
            super(completePath);
            this.file = null;
            this.name = completePath;
            this.parts = FileUtils.getPathStack((String)completePath);
        }

        public boolean exists() {
            return true;
        }

        public String getAbsolutePath() {
            return this.name;
        }

        public String getName() {
            return this.parts.length > 0 ? this.parts[this.parts.length - 1] : this.name;
        }

        public String getParent() {
            String result = "";
            for (int i = 0; i < this.parts.length - 1; ++i) {
                result = result + File.separatorChar + this.parts[i];
            }
            return result;
        }

        public String getPath() {
            return this.name;
        }

        public boolean isAbsolute() {
            return true;
        }

        public boolean isDirectory() {
            return this.file == null;
        }

        public boolean isFile() {
            return this.file != null;
        }

        public boolean isHidden() {
            return false;
        }

        public long lastModified() {
            if (this.file != null) {
                return this.file.getTimestamp().getTimeInMillis();
            }
            return 0L;
        }

        public long length() {
            if (this.file != null) {
                return this.file.getSize();
            }
            return 0L;
        }
    }
}

