/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.jmx.internal.server;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.equinox.jmx.internal.server.Activator;
import org.eclipse.equinox.jmx.internal.server.ServerMessages;
import org.eclipse.equinox.jmx.server.IJMXConnectorServerProvider;
import org.eclipse.osgi.util.NLS;

public class JMXServerFactory {
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_INITIALIZER_CLASS = "initializerClass";
    private static final String ATTRIBUTE_PROTOCOL = "protocol";
    private static Map jmxProviderCache;

    private JMXServerFactory() {
    }

    public static JMXConnectorServer createJMXServer(String host, int port, String protocol, String domain, Map environment) throws IOException {
        IJMXConnectorServerProvider provider = JMXServerFactory.getProvider(protocol);
        if (provider == null) {
            throw new IOException(NLS.bind((String)ServerMessages.protocol_not_available, (Object)protocol));
        }
        MBeanServer mbeanServer = MBeanServerFactory.createMBeanServer(domain);
        JMXServiceURL providerURL = provider.getJMXServiceURL(host, port, protocol, domain);
        if (providerURL == null) {
            providerURL = new JMXServiceURL(protocol, host, port);
        }
        return provider.newJMXConnectorServer(providerURL, environment, mbeanServer);
    }

    private static IJMXConnectorServerProvider getProvider(String protocol) {
        Class providerClass = (Class)JMXServerFactory.getJMXProviderCache().get(protocol);
        if (providerClass != null) {
            try {
                return (IJMXConnectorServerProvider)providerClass.newInstance();
            }
            catch (Exception e) {
                Activator.log(e);
            }
        }
        return null;
    }

    private static void loadProviderExtensions() {
        IExtensionPoint point = RegistryFactory.getRegistry().getExtensionPoint("org.eclipse.equinox.jmx.server", "provider");
        IExtension[] types = point.getExtensions();
        int i = 0;
        while (i < types.length) {
            JMXServerFactory.loadProviderConfigurationElements(types[i].getConfigurationElements());
            ++i;
        }
    }

    private static void loadProviderConfigurationElements(IConfigurationElement[] configElems) {
        int j = 0;
        while (j < configElems.length) {
            String protocol;
            String className;
            IConfigurationElement element = configElems[j];
            String elementName = element.getName();
            if (elementName.equals("provider") && (className = element.getAttribute(ATTRIBUTE_CLASS)) != null && (protocol = element.getAttribute(ATTRIBUTE_PROTOCOL)) != null) {
                try {
                    String initializer = element.getAttribute(ATTRIBUTE_INITIALIZER_CLASS);
                    if (initializer != null) {
                        element.createExecutableExtension(ATTRIBUTE_INITIALIZER_CLASS);
                    }
                    Object obj = element.createExecutableExtension(ATTRIBUTE_CLASS);
                    if (jmxProviderCache.containsKey(protocol)) {
                        Activator.log(NLS.bind((String)ServerMessages.duplicate_protocol_provider, (Object)className));
                    } else {
                        jmxProviderCache.put(protocol, obj.getClass());
                    }
                }
                catch (CoreException e) {
                    Activator.log(e);
                }
            }
            ++j;
        }
    }

    private static Map getJMXProviderCache() {
        if (jmxProviderCache == null) {
            jmxProviderCache = new HashMap();
            JMXServerFactory.loadProviderExtensions();
            RegistryFactory.getRegistry().addRegistryChangeListener((IRegistryChangeListener)new JMXProviderExtensionListener(), "org.eclipse.equinox.jmx.server.provider");
        }
        return jmxProviderCache;
    }

    private static class JMXProviderExtensionListener
    implements IRegistryChangeListener {
        private JMXProviderExtensionListener() {
        }

        public void registryChanged(IRegistryChangeEvent event) {
            IExtensionDelta[] deltas = event.getExtensionDeltas("org.eclipse.equinox.jmx.server", "provider");
            int i = 0;
            while (i < deltas.length) {
                IExtensionDelta delta = deltas[i];
                JMXServerFactory.loadProviderConfigurationElements(delta.getExtensionPoint().getConfigurationElements());
                ++i;
            }
        }
    }
}

