/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.jmx.internal.server;

import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.management.IntrospectionException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnectorServer;
import org.eclipse.equinox.jmx.common.ContributionProxy;
import org.eclipse.equinox.jmx.common.JMXConstants;
import org.eclipse.equinox.jmx.common.RootContribution;
import org.eclipse.equinox.jmx.internal.server.JMXServerFactory;
import org.eclipse.equinox.jmx.internal.server.ServerExtensionManager;
import org.eclipse.equinox.jmx.internal.server.ServerMessages;
import org.eclipse.equinox.jmx.server.ContributionProvider;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    static final String PLUGIN_ID = "org.eclipse.equinox.jmx.server";
    static final String PI_NAMESPACE = "org.eclipse.equinox.jmx.server";
    static final String PT_CONTRIBUTION = "contribution";
    static final String PT_PROVIDER = "provider";
    static final String PROTOCOL_PROPERTY_KEY = "org.eclipse.equinox.jmx.server.protocol";
    static final String PORT_PROPERTY_KEY = "org.eclipse.equinox.jmx.server.port";
    static final String DOMAIN_PROPERTY_KEY = "org.eclipse.equinox.jmx.server.domain";
    private static Activator instance;
    private static BundleContext bundleContext;
    private static JMXConnectorServer jmxServer;
    private static RootContribution rootContribution;
    private static ServiceTracker logService;
    static /* synthetic */ Class class$0;

    public Activator() {
        instance = this;
    }

    public void start(BundleContext context) throws Exception {
        bundleContext = context;
        if (jmxServer == null) {
            this.createServer();
        }
        jmxServer.start();
    }

    public void createServer() throws Exception {
        int port;
        String strPort;
        String protocol = System.getProperty(PROTOCOL_PROPERTY_KEY);
        if (protocol == null) {
            protocol = "rmi";
        }
        if ((strPort = System.getProperty(PORT_PROPERTY_KEY)) == null) {
            port = JMXConstants.DEFAULT_PORT_AS_INT;
        } else {
            try {
                port = Integer.parseInt(strPort);
            }
            catch (NumberFormatException nfe) {
                Activator.log(nfe);
                port = JMXConstants.DEFAULT_PORT_AS_INT;
            }
        }
        String domain = System.getProperty(DOMAIN_PROPERTY_KEY);
        if (domain == null) {
            domain = "jmxserver";
        }
        jmxServer = JMXServerFactory.createJMXServer("127.0.0.1", port, protocol, "jmxserver", null);
        this.registerContributions();
    }

    /*
     * Unable to fully structure code
     */
    private void registerContributions() throws IntrospectionException, ReflectionException, MBeanRegistrationException, NotCompliantMBeanException {
        block5: {
            mbeanServer = Activator.jmxServer.getMBeanServer();
            try {
                mbeanServer.getMBeanInfo(RootContribution.OBJECT_NAME);
                break block5;
            }
            catch (Exception v0) {
                providers = ServerExtensionManager.getInstance().getContributionExtensionDefinitions();
                iter = providers.iterator();
                proxiesToRegister = new ArrayList<ContributionProxy>();
                ** while (iter.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                defn = (ServerExtensionManager.ContributionExtensionDefinition)iter.next();
                provider = defn.getContributionProvider();
                provider.registerContribution(mbeanServer);
                if (!defn.isRootProvider()) continue;
                proxiesToRegister.add(provider.createProxy());
                continue;
            }
lbl18:
            // 1 sources

            Activator.rootContribution = new RootContribution(proxiesToRegister.toArray(new ContributionProxy[proxiesToRegister.size()]));
            try {
                mbeanServer.registerMBean(Activator.rootContribution, RootContribution.OBJECT_NAME);
            }
            catch (Exception v1) {}
            ServerExtensionManager.getInstance().addObserver(new Observer(){

                public void update(Observable o, Object arg) {
                    if (!(arg instanceof ServerExtensionManager.ContributionExtensionDefinition)) {
                        return;
                    }
                    ServerExtensionManager.ContributionExtensionDefinition defn = (ServerExtensionManager.ContributionExtensionDefinition)arg;
                    ContributionProvider rootProvider = defn.getContributionProvider();
                    if (ServerExtensionManager.getInstance().getContributionExtensionDefinition(defn.getProviderClassName()) == null) {
                        rootContribution.unregisterContributionProxy(rootProvider.createProxy());
                        rootProvider.sendNotification(new Notification("contribution.removed", rootProvider, 0L));
                    } else {
                        try {
                            rootProvider.registerContribution(mbeanServer);
                            rootContribution.registerContributionProxy(rootProvider.createProxy());
                            rootContribution.sendNotification(new Notification("contribution.updated", rootContribution, 0L));
                        }
                        catch (Exception e) {
                            Activator.log(e);
                        }
                    }
                }
            });
        }
    }

    public static RootContribution getRootContribution() {
        return rootContribution;
    }

    public void stop(BundleContext context) throws Exception {
        jmxServer.stop();
        if (logService != null) {
            logService.close();
            logService = null;
        }
        instance = null;
    }

    public BundleContext getBundleContext() {
        return bundleContext;
    }

    public static Activator getDefault() {
        return instance;
    }

    public MBeanServer getServer() {
        return jmxServer.getMBeanServer();
    }

    public static void log(String message, Throwable exception, int iStatusSeverity) {
        if (message == null && (message = exception.getMessage()) == null) {
            message = ServerMessages.exception_occurred;
        }
        if (logService == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.osgi.service.log.LogService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logService = new ServiceTracker(bundleContext, clazz.getName(), null);
            logService.open();
        }
        LogService log = (LogService)logService.getService();
        int severity = 3;
        switch (iStatusSeverity) {
            case 4: {
                severity = 1;
                break;
            }
            case 2: {
                severity = 2;
                break;
            }
            default: {
                severity = 3;
            }
        }
        if (log == null) {
            System.out.println("org.eclipse.equinox.jmx.server");
            System.out.println(severity);
            System.out.println(message);
            if (exception != null) {
                exception.printStackTrace(System.out);
            }
        } else {
            log.log(severity, message, exception);
        }
    }

    public static void logError(String message, Throwable exception) {
        Activator.log(message, exception, 4);
    }

    public static void logError(Throwable exception) {
        Activator.log(exception.getMessage(), exception, 4);
    }

    public static void log(String message) {
        Activator.log(message, null, 1);
    }

    public static void log(Throwable exception) {
        Activator.log(exception.getMessage(), exception, 1);
    }
}

