/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt.targetvm.win32;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;

public class ImageCapture
extends org.eclipse.e4.xwt.tools.ui.imagecapture.swt.ImageCapture {
    static Field Control_handler;
    static Field GC_handler;
    static Class<?> OleFrameClass;
    static Method GetParent;
    static Method SendMessage;

    static {
        try {
            OleFrameClass = Class.forName("org.eclipse.swt.ole.win32.OleFrame");
            Class<?> osClass = Class.forName("org.eclipse.swt.internal.win32.OS");
            GetParent = osClass.getDeclaredMethod("GetParent", Integer.TYPE);
            Control_handler = Control.class.getField("handle");
            GC_handler = GC.class.getField("handle");
            GC_handler.setAccessible(true);
            SendMessage = osClass.getDeclaredMethod("SendMessage", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Image getImage(Control control, int maxWidth, int maxHeight, boolean includeChildren) {
        Image myImage = this.getImage(control, maxWidth, maxHeight);
        if (myImage != null && includeChildren && control instanceof Composite) {
            Display display = control.getDisplay();
            Rectangle parentBounds = control.getParent() == null ? control.getBounds() : display.map((Control)control.getParent(), null, control.getBounds());
            Rectangle imgBounds = myImage.getBounds();
            parentBounds.width = imgBounds.width;
            parentBounds.height = imgBounds.height;
            int parentRight = parentBounds.width + parentBounds.x;
            int parentBottom = parentBounds.height + parentBounds.y;
            Control[] children = ((Composite)control).getChildren();
            GC myImageGC = new GC((Drawable)myImage);
            try {
                int i = children.length;
                while (--i >= 0) {
                    Image childImage;
                    Rectangle childBounds;
                    Control child = children[i];
                    if (!child.isVisible() || !parentBounds.intersects(childBounds = display.map(control, null, child.getBounds())) || (childImage = this.getImage(child, parentRight - childBounds.x, parentBottom - childBounds.y, true)) == null) continue;
                    try {
                        myImageGC.drawImage(childImage, childBounds.x - parentBounds.x, childBounds.y - parentBounds.y);
                    }
                    finally {
                        childImage.dispose();
                    }
                }
            }
            finally {
                myImageGC.dispose();
            }
        }
        return myImage;
    }

    protected Image getImage(Control aControl, int maxWidth, int maxHeight) {
        Rectangle rect = aControl.getBounds();
        if (rect.width <= 0 || rect.height <= 0) {
            return null;
        }
        Image image = new Image((Device)aControl.getDisplay(), Math.min(rect.width, maxWidth), Math.min(rect.height, maxHeight));
        int WM_PRINT = 791;
        int PRF_NONCLIENT = 2;
        int PRF_CLIENT = 4;
        int PRF_ERASEBKGND = 8;
        int PRF_CHILDREN = 16;
        int print_bits = PRF_NONCLIENT | PRF_CLIENT | PRF_ERASEBKGND;
        boolean specialClass = aControl instanceof Table || aControl instanceof Browser || OleFrameClass.isInstance(aControl) || aControl instanceof CCombo;
        try {
            specialClass |= aControl instanceof Spinner;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
        if (specialClass) {
            print_bits |= PRF_CHILDREN;
        }
        GC gc = new GC((Drawable)image);
        Font f = aControl.getFont();
        if (f != null) {
            gc.setFont(f);
        }
        try {
            int hwndParent;
            int hwnd = Control_handler.getInt(aControl);
            if (aControl instanceof Tree && (hwndParent = ((Integer)GetParent.invoke(null, hwnd)).intValue()) != Control_handler.getInt(aControl.getParent())) {
                hwnd = hwndParent;
                print_bits |= PRF_CHILDREN;
            }
            Object handle = GC_handler.get(gc);
            SendMessage.invoke(null, hwnd, WM_PRINT, handle, print_bits);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        gc.dispose();
        return image;
    }
}

