/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.compatibility.internal;

import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.runtime.ContributorFactoryOSGi;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.platform.discovery.compatibility.internal.contributors.ContributionFailedException;
import org.eclipse.platform.discovery.compatibility.internal.contributors.impl.DynamicObjectTypeContributor;
import org.eclipse.platform.discovery.compatibility.internal.readers.impl.SearchPageParser;
import org.eclipse.platform.discovery.util.internal.logging.ILogger;
import org.eclipse.platform.discovery.util.internal.logging.Logger;
import org.eclipse.ui.IStartup;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class DiscoveryCompatibilityPlugin
extends Plugin
implements IStartup {
    public static final String PLUGIN_ID = "org.eclipse.platform.discovery.compatibility";
    private static DiscoveryCompatibilityPlugin plugin;
    private final ILogger logger = new Logger();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.contributeDynamicObjectTypes();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static DiscoveryCompatibilityPlugin getDefault() {
        return plugin;
    }

    public ILogger logger() {
        return this.logger;
    }

    IContributor getContributor() {
        return ContributorFactoryOSGi.createContributor((Bundle)this.getBundle());
    }

    private IExtensionRegistry getRegistry() {
        return RegistryFactory.getRegistry();
    }

    private Object getUserToken() {
        return ((ExtensionRegistry)this.getRegistry()).getTemporaryUserToken();
    }

    private void contributeDynamicObjectTypes() {
        DynamicObjectTypeContributor objectsContributor = new DynamicObjectTypeContributor(new SearchPageParser(this.getRegistry()));
        try {
            objectsContributor.contribute(this.getRegistry(), this.getContributor(), this.getUserToken());
        }
        catch (ContributionFailedException ex) {
            this.logger().logError(ex.getMessage());
        }
    }

    public void earlyStartup() {
    }
}

