/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.spi;

import java.text.MessageFormat;
import org.eclipse.core.resources.semantic.spi.ISemanticSpiResourceInfo;
import org.eclipse.core.resources.semantic.spi.Messages;

public class SemanticSpiResourceInfo
implements ISemanticSpiResourceInfo {
    private final boolean isLocked;
    private final boolean isLockingSupported;
    private final boolean isReadOnly;
    private final boolean existsRemotely;
    private final String uriString;
    private final int options;
    private final String contentType;

    public static boolean isOptionRequested(int option, int options) {
        return options == 0 || (options & option) > 0;
    }

    public SemanticSpiResourceInfo(int options, boolean isLocked, boolean isLockingSupported, boolean isReadOnly, boolean existsRemotely, String uriString, String contentType) {
        this.options = options;
        this.isLocked = isLocked;
        this.isLockingSupported = isLockingSupported;
        this.isReadOnly = isReadOnly;
        this.existsRemotely = existsRemotely;
        this.uriString = uriString;
        this.contentType = contentType;
    }

    public boolean isLocked() {
        this.assertCorrectOption(2);
        return this.isLocked;
    }

    public boolean isLockingSupported() {
        this.assertCorrectOption(4);
        return this.isLockingSupported;
    }

    public boolean isReadOnly() {
        this.assertCorrectOption(16);
        return this.isReadOnly;
    }

    public String getRemoteUriString() {
        this.assertCorrectOption(64);
        return this.uriString;
    }

    public String getContentType() {
        this.assertCorrectOption(128);
        return this.contentType;
    }

    public boolean existsRemotely() {
        this.assertCorrectOption(32);
        return this.existsRemotely;
    }

    private void assertCorrectOption(int option) {
        if (!SemanticSpiResourceInfo.isOptionRequested(option, this.options)) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.SemanticSpiResourceInfo_OptionNotRequested_XMSG, option));
        }
    }
}

