/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.spi;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.ITag;

public abstract class SemanticFileRevision
implements IFileRevision {
    private final String myAuthor;
    private final String myComment;
    private final long myTimestamp;
    private URI myUri;
    private final String myName;

    public SemanticFileRevision(ISemanticFileStore semanticFileStore, long timestamp, String author, String comment) {
        this.myAuthor = author;
        this.myComment = comment;
        this.myTimestamp = timestamp;
        this.myName = semanticFileStore.getName();
        try {
            this.myUri = new URI(semanticFileStore.getPath().toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            this.myUri = null;
        }
    }

    public boolean exists() {
        return true;
    }

    public String getAuthor() {
        return this.myAuthor;
    }

    public String getComment() {
        return this.myComment;
    }

    public String getContentIdentifier() {
        return Long.toString(this.myTimestamp);
    }

    public String getName() {
        return this.myName;
    }

    public ITag[] getTags() {
        return new ITag[0];
    }

    public long getTimestamp() {
        return this.myTimestamp;
    }

    public URI getURI() {
        return this.myUri;
    }

    public boolean isPropertyMissing() {
        return false;
    }

    public IFileRevision withAllProperties(IProgressMonitor monitor) throws CoreException {
        return this;
    }
}

