/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.tomcat.util.buf.ByteBufferHolder;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.DispatchType;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SendfileDataBase;
import org.apache.tomcat.util.net.SendfileState;
import org.apache.tomcat.util.net.SocketBufferHandler;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.res.StringManager;

public abstract class SocketWrapperBase<E> {
    protected static final StringManager sm = StringManager.getManager(SocketWrapperBase.class);
    private final E socket;
    private final AbstractEndpoint<E> endpoint;
    private volatile long readTimeout = -1L;
    private volatile long writeTimeout = -1L;
    private volatile int keepAliveLeft = 100;
    private volatile boolean upgraded = false;
    private boolean secure = false;
    private String negotiatedProtocol = null;
    protected String localAddr = null;
    protected String localName = null;
    protected int localPort = -1;
    protected String remoteAddr = null;
    protected String remoteHost = null;
    protected int remotePort = -1;
    private volatile boolean blockingStatus = true;
    private final Lock blockingStatusReadLock;
    private final ReentrantReadWriteLock.WriteLock blockingStatusWriteLock;
    protected volatile SocketBufferHandler socketBufferHandler = null;
    protected final LinkedBlockingDeque<ByteBufferHolder> bufferedWrites = new LinkedBlockingDeque();
    protected int bufferedWriteSize = 65536;
    public static final CompletionCheck COMPLETE_WRITE = new CompletionCheck(){

        @Override
        public CompletionHandlerCall callHandler(CompletionState state, ByteBuffer[] buffers, int offset, int length) {
            for (int i = 0; i < offset; ++i) {
                if (buffers[i].remaining() <= 0) continue;
                return CompletionHandlerCall.CONTINUE;
            }
            return state == CompletionState.DONE ? CompletionHandlerCall.DONE : CompletionHandlerCall.NONE;
        }
    };
    public static final CompletionCheck READ_DATA = new CompletionCheck(){

        @Override
        public CompletionHandlerCall callHandler(CompletionState state, ByteBuffer[] buffers, int offset, int length) {
            return state == CompletionState.DONE ? CompletionHandlerCall.DONE : CompletionHandlerCall.NONE;
        }
    };

    public SocketWrapperBase(E socket, AbstractEndpoint<E> endpoint) {
        this.socket = socket;
        this.endpoint = endpoint;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.blockingStatusReadLock = lock.readLock();
        this.blockingStatusWriteLock = lock.writeLock();
    }

    public E getSocket() {
        return this.socket;
    }

    public AbstractEndpoint<E> getEndpoint() {
        return this.endpoint;
    }

    public boolean isUpgraded() {
        return this.upgraded;
    }

    public void setUpgraded(boolean upgraded) {
        this.upgraded = upgraded;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String getNegotiatedProtocol() {
        return this.negotiatedProtocol;
    }

    public void setNegotiatedProtocol(String negotiatedProtocol) {
        this.negotiatedProtocol = negotiatedProtocol;
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout > 0L ? readTimeout : -1L;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public void setWriteTimeout(long writeTimeout) {
        this.writeTimeout = writeTimeout > 0L ? writeTimeout : -1L;
    }

    public long getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setKeepAliveLeft(int keepAliveLeft) {
        this.keepAliveLeft = keepAliveLeft;
    }

    public int decrementKeepAlive() {
        return --this.keepAliveLeft;
    }

    public String getRemoteHost() {
        if (this.remoteHost == null) {
            this.populateRemoteHost();
        }
        return this.remoteHost;
    }

    protected abstract void populateRemoteHost();

    public String getRemoteAddr() {
        if (this.remoteAddr == null) {
            this.populateRemoteAddr();
        }
        return this.remoteAddr;
    }

    protected abstract void populateRemoteAddr();

    public int getRemotePort() {
        if (this.remotePort == -1) {
            this.populateRemotePort();
        }
        return this.remotePort;
    }

    protected abstract void populateRemotePort();

    public String getLocalName() {
        if (this.localName == null) {
            this.populateLocalName();
        }
        return this.localName;
    }

    protected abstract void populateLocalName();

    public String getLocalAddr() {
        if (this.localAddr == null) {
            this.populateLocalAddr();
        }
        return this.localAddr;
    }

    protected abstract void populateLocalAddr();

    public int getLocalPort() {
        if (this.localPort == -1) {
            this.populateLocalPort();
        }
        return this.localPort;
    }

    protected abstract void populateLocalPort();

    public boolean getBlockingStatus() {
        return this.blockingStatus;
    }

    public void setBlockingStatus(boolean blockingStatus) {
        this.blockingStatus = blockingStatus;
    }

    public Lock getBlockingStatusReadLock() {
        return this.blockingStatusReadLock;
    }

    public ReentrantReadWriteLock.WriteLock getBlockingStatusWriteLock() {
        return this.blockingStatusWriteLock;
    }

    public SocketBufferHandler getSocketBufferHandler() {
        return this.socketBufferHandler;
    }

    public boolean hasDataToWrite() {
        return !this.socketBufferHandler.isWriteBufferEmpty() || this.bufferedWrites.size() > 0;
    }

    public boolean isReadyForWrite() {
        boolean result = this.canWrite();
        if (!result) {
            this.registerWriteInterest();
        }
        return result;
    }

    public boolean canWrite() {
        if (this.socketBufferHandler == null) {
            throw new IllegalStateException(sm.getString("socket.closed"));
        }
        return this.socketBufferHandler.isWriteBufferWritable() && this.bufferedWrites.size() == 0;
    }

    public String toString() {
        return super.toString() + ":" + String.valueOf(this.socket);
    }

    public abstract int read(boolean var1, byte[] var2, int var3, int var4) throws IOException;

    public abstract boolean isReadyForRead() throws IOException;

    public void unRead(ByteBuffer returnedInput) {
        if (returnedInput != null) {
            this.socketBufferHandler.configureReadBufferForWrite();
            this.socketBufferHandler.getReadBuffer().put(returnedInput);
        }
    }

    public abstract void close() throws IOException;

    public final void write(boolean block, byte[] buf, int off, int len) throws IOException {
        if (len == 0 || buf == null || this.getSocket() == null) {
            return;
        }
        if (block) {
            this.writeBlocking(buf, off, len);
        } else {
            this.writeNonBlocking(buf, off, len);
        }
    }

    protected void writeBlocking(byte[] buf, int off, int len) throws IOException {
        this.socketBufferHandler.configureWriteBufferForWrite();
        int thisTime = SocketWrapperBase.transfer(buf, off, len, this.socketBufferHandler.getWriteBuffer());
        while (this.socketBufferHandler.getWriteBuffer().remaining() == 0) {
            this.doWrite(true);
            this.socketBufferHandler.configureWriteBufferForWrite();
            thisTime = SocketWrapperBase.transfer(buf, off += thisTime, len -= thisTime, this.socketBufferHandler.getWriteBuffer());
        }
    }

    protected void writeNonBlocking(byte[] buf, int off, int len) throws IOException {
        if (this.bufferedWrites.size() == 0 && this.socketBufferHandler.isWriteBufferWritable()) {
            this.socketBufferHandler.configureWriteBufferForWrite();
            int thisTime = SocketWrapperBase.transfer(buf, off, len, this.socketBufferHandler.getWriteBuffer());
            len -= thisTime;
            while (!this.socketBufferHandler.isWriteBufferWritable()) {
                off += thisTime;
                this.doWrite(false);
                if (len <= 0 || !this.socketBufferHandler.isWriteBufferWritable()) break;
                this.socketBufferHandler.configureWriteBufferForWrite();
                thisTime = SocketWrapperBase.transfer(buf, off, len, this.socketBufferHandler.getWriteBuffer());
                len -= thisTime;
            }
        }
        if (len > 0) {
            this.addToBuffers(buf, off, len);
        }
    }

    public boolean flush(boolean block) throws IOException {
        if (this.getSocket() == null) {
            return false;
        }
        boolean result = false;
        if (block) {
            this.flushBlocking();
        } else {
            result = this.flushNonBlocking();
        }
        return result;
    }

    protected void flushBlocking() throws IOException {
        this.doWrite(true);
        if (this.bufferedWrites.size() > 0) {
            Iterator<ByteBufferHolder> bufIter = this.bufferedWrites.iterator();
            while (this.socketBufferHandler.isWriteBufferEmpty() && bufIter.hasNext()) {
                ByteBufferHolder buffer = bufIter.next();
                buffer.flip();
                while (this.socketBufferHandler.isWriteBufferEmpty() && buffer.getBuf().remaining() > 0) {
                    this.socketBufferHandler.configureWriteBufferForWrite();
                    SocketWrapperBase.transfer(buffer.getBuf(), this.socketBufferHandler.getWriteBuffer());
                    if (buffer.getBuf().remaining() == 0) {
                        bufIter.remove();
                    }
                    this.doWrite(true);
                }
            }
        }
    }

    protected boolean flushNonBlocking() throws IOException {
        boolean dataLeft;
        boolean bl = dataLeft = !this.socketBufferHandler.isWriteBufferEmpty();
        if (dataLeft) {
            this.doWrite(false);
        }
        boolean bl2 = dataLeft = !this.socketBufferHandler.isWriteBufferEmpty();
        if (!dataLeft && this.bufferedWrites.size() > 0) {
            Iterator<ByteBufferHolder> bufIter = this.bufferedWrites.iterator();
            while (this.socketBufferHandler.isWriteBufferEmpty() && bufIter.hasNext()) {
                ByteBufferHolder buffer = bufIter.next();
                buffer.flip();
                while (this.socketBufferHandler.isWriteBufferEmpty() && buffer.getBuf().remaining() > 0) {
                    this.socketBufferHandler.configureWriteBufferForWrite();
                    SocketWrapperBase.transfer(buffer.getBuf(), this.socketBufferHandler.getWriteBuffer());
                    if (buffer.getBuf().remaining() == 0) {
                        bufIter.remove();
                    }
                    this.doWrite(false);
                }
            }
        }
        return !this.socketBufferHandler.isWriteBufferEmpty();
    }

    protected final void doWrite(boolean block) throws IOException {
        this.doWriteInternal(block);
    }

    protected abstract void doWriteInternal(boolean var1) throws IOException;

    protected void addToBuffers(byte[] buf, int offset, int length) {
        ByteBufferHolder holder = this.bufferedWrites.peekLast();
        if (holder == null || holder.isFlipped() || holder.getBuf().remaining() < length) {
            ByteBuffer buffer = ByteBuffer.allocate(Math.max(this.bufferedWriteSize, length));
            holder = new ByteBufferHolder(buffer, false);
            this.bufferedWrites.add(holder);
        }
        holder.getBuf().put(buf, offset, length);
    }

    public void processSocket(SocketEvent socketStatus, boolean dispatch) {
        this.endpoint.processSocket(this, socketStatus, dispatch);
    }

    public synchronized void executeNonBlockingDispatches(Iterator<DispatchType> dispatches) {
        while (dispatches != null && dispatches.hasNext()) {
            DispatchType dispatchType = dispatches.next();
            this.processSocket(dispatchType.getSocketStatus(), false);
        }
    }

    public abstract void registerReadInterest();

    public abstract void registerWriteInterest();

    public abstract SendfileDataBase createSendfileData(String var1, long var2, long var4);

    public abstract SendfileState processSendfile(SendfileDataBase var1);

    public abstract void doClientAuth(SSLSupport var1);

    public abstract SSLSupport getSslSupport(String var1);

    public boolean hasAsyncIO() {
        return false;
    }

    public boolean isReadPending() {
        return false;
    }

    public boolean isWritePending() {
        return false;
    }

    public boolean awaitReadComplete(long timeout, TimeUnit unit) {
        return true;
    }

    public boolean awaitWriteComplete(long timeout, TimeUnit unit) {
        return true;
    }

    public final <A> CompletionState read(boolean block, long timeout, TimeUnit unit, A attachment, CompletionCheck check, CompletionHandler<Long, ? super A> handler, ByteBuffer ... dsts) {
        if (dsts == null) {
            throw new IllegalArgumentException();
        }
        return this.read(dsts, 0, dsts.length, block, timeout, unit, attachment, check, handler);
    }

    public <A> CompletionState read(ByteBuffer[] dsts, int offset, int length, boolean block, long timeout, TimeUnit unit, A attachment, CompletionCheck check, CompletionHandler<Long, ? super A> handler) {
        throw new UnsupportedOperationException();
    }

    public final <A> CompletionState write(boolean block, long timeout, TimeUnit unit, A attachment, CompletionCheck check, CompletionHandler<Long, ? super A> handler, ByteBuffer ... srcs) {
        if (srcs == null) {
            throw new IllegalArgumentException();
        }
        return this.write(srcs, 0, srcs.length, block, timeout, unit, attachment, check, handler);
    }

    public <A> CompletionState write(ByteBuffer[] srcs, int offset, int length, boolean block, long timeout, TimeUnit unit, A attachment, CompletionCheck check, CompletionHandler<Long, ? super A> handler) {
        throw new UnsupportedOperationException();
    }

    protected static int transfer(byte[] from, int offset, int length, ByteBuffer to) {
        int max = Math.min(length, to.remaining());
        to.put(from, offset, max);
        return max;
    }

    protected static void transfer(ByteBuffer from, ByteBuffer to) {
        int max = Math.min(from.remaining(), to.remaining());
        int fromLimit = from.limit();
        from.limit(from.position() + max);
        to.put(from);
        from.limit(fromLimit);
    }

    public static interface CompletionCheck {
        public CompletionHandlerCall callHandler(CompletionState var1, ByteBuffer[] var2, int var3, int var4);
    }

    public static enum CompletionHandlerCall {
        CONTINUE,
        NONE,
        DONE;

    }

    public static enum CompletionState {
        PENDING,
        INLINE,
        ERROR,
        DONE;

    }
}

