/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.SSLUtil;
import org.apache.tomcat.util.res.StringManager;

public abstract class SSLUtilBase
implements SSLUtil {
    private static final StringManager sm = StringManager.getManager(SSLUtilBase.class);
    protected final SSLHostConfigCertificate certificate;
    private final String[] enabledProtocols;
    private final String[] enabledCiphers;

    protected SSLUtilBase(SSLHostConfigCertificate certificate) {
        this.certificate = certificate;
        SSLHostConfig sslHostConfig = certificate.getSSLHostConfig();
        Set<String> configuredProtocols = sslHostConfig.getProtocols();
        Set<String> implementedProtocols = this.getImplementedProtocols();
        List<String> enabledProtocols = SSLUtilBase.getEnabled("protocols", this.getLog(), true, configuredProtocols, implementedProtocols);
        this.enabledProtocols = enabledProtocols.toArray(new String[enabledProtocols.size()]);
        List<String> configuredCiphers = sslHostConfig.getJsseCipherNames();
        Set<String> implementedCiphers = this.getImplementedCiphers();
        List<String> enabledCiphers = SSLUtilBase.getEnabled("ciphers", this.getLog(), false, configuredCiphers, implementedCiphers);
        this.enabledCiphers = enabledCiphers.toArray(new String[enabledCiphers.size()]);
    }

    static <T> List<T> getEnabled(String name, Log log, boolean warnOnSkip, Collection<T> configured, Collection<T> implemented) {
        ArrayList<T> enabled = new ArrayList<T>();
        if (implemented.size() == 0) {
            enabled.addAll(configured);
        } else {
            enabled.addAll(configured);
            enabled.retainAll(implemented);
            if (enabled.isEmpty()) {
                throw new IllegalArgumentException(sm.getString("sslUtilBase.noneSupported", name, configured));
            }
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("sslUtilBase.active", name, enabled));
            }
            if ((log.isDebugEnabled() || warnOnSkip) && enabled.size() != configured.size()) {
                ArrayList<T> skipped = new ArrayList<T>();
                skipped.addAll(configured);
                skipped.removeAll(enabled);
                String msg = sm.getString("sslUtilBase.skipped", name, skipped);
                if (warnOnSkip) {
                    log.warn(msg);
                } else {
                    log.debug(msg);
                }
            }
        }
        return enabled;
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    @Override
    public String[] getEnabledCiphers() {
        return this.enabledCiphers;
    }

    protected abstract Set<String> getImplementedProtocols();

    protected abstract Set<String> getImplementedCiphers();

    protected abstract Log getLog();
}

