/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.wizard.project.getstarted;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dirigible.ide.common.CommonIDEParameters;
import org.eclipse.dirigible.ide.common.status.StatusLineManagerUtil;
import org.eclipse.dirigible.ide.workspace.wizard.project.create.Messages;
import org.eclipse.dirigible.ide.workspace.wizard.project.getstarted.GetStartedProjectWizardDBTablePage;
import org.eclipse.dirigible.ide.workspace.wizard.project.getstarted.GetStartedProjectWizardHTMLPage;
import org.eclipse.dirigible.ide.workspace.wizard.project.getstarted.GetStartedProjectWizardJSServicePage;
import org.eclipse.dirigible.ide.workspace.wizard.project.getstarted.GetStartedProjectWizardMainPage;
import org.eclipse.dirigible.ide.workspace.wizard.project.getstarted.GetStartedProjectWizardModel;
import org.eclipse.dirigible.ide.workspace.wizard.project.getstarted.GetStartedProjectWizardSummaryPage;
import org.eclipse.dirigible.ide.workspace.wizard.project.getstarted.GetStartedProjectWizardWelcomePage;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class GetStartedProjectWizard
extends Wizard {
    private static final Logger logger = Logger.getLogger(GetStartedProjectWizard.class);
    private static final String COULD_NOT_CREATE_PROJECT = Messages.NewProjectWizard_COULD_NOT_CREATE_PROJECT;
    private static final String OPERATION_FAILED = Messages.NewProjectWizard_OPERATION_FAILED;
    private static final String PROJECT_S_CREATED_SUCCESSFULLY = Messages.NewProjectWizard_PROJECT_S_CREATED_SUCCESSFULLY;
    private static final String WINDOW_TITLE = "Get Started Project Wizard";
    private final GetStartedProjectWizardModel model;
    private final GetStartedProjectWizardWelcomePage welcomePage;
    private final GetStartedProjectWizardMainPage mainPage;
    private final GetStartedProjectWizardDBTablePage dbTablePage;
    private final GetStartedProjectWizardJSServicePage jsServicePage;
    private final GetStartedProjectWizardHTMLPage htmlPage;
    private final GetStartedProjectWizardSummaryPage summaryPage;

    public GetStartedProjectWizard() {
        this.setWindowTitle(WINDOW_TITLE);
        this.model = new GetStartedProjectWizardModel();
        this.model.setProjectName(String.valueOf(CommonIDEParameters.getUserName()) + "_" + this.model.getProjectName());
        this.welcomePage = new GetStartedProjectWizardWelcomePage();
        this.mainPage = new GetStartedProjectWizardMainPage(this.model);
        this.dbTablePage = new GetStartedProjectWizardDBTablePage();
        this.jsServicePage = new GetStartedProjectWizardJSServicePage();
        this.htmlPage = new GetStartedProjectWizardHTMLPage();
        this.summaryPage = new GetStartedProjectWizardSummaryPage();
    }

    public void addPages() {
        this.addPage((IWizardPage)this.welcomePage);
        this.addPage((IWizardPage)this.mainPage);
        this.addPage((IWizardPage)this.dbTablePage);
        this.addPage((IWizardPage)this.jsServicePage);
        this.addPage((IWizardPage)this.htmlPage);
        this.addPage((IWizardPage)this.summaryPage);
    }

    public boolean performFinish() {
        logger.info(String.format(PROJECT_S_CREATED_SUCCESSFULLY, this.mainPage.getProjectName()));
        boolean result = this.onFinish();
        if (result) {
            StatusLineManagerUtil.setInfoMessage((String)String.format(StatusLineManagerUtil.ARTIFACT_HAS_BEEN_CREATED, this.mainPage.getProjectName()));
        }
        return result;
    }

    public void showErrorDialog(String title, String message) {
        logger.error(message);
        MessageDialog.openError(null, (String)title, (String)message);
    }

    public boolean onFinish() {
        try {
            this.model.execute();
            return true;
        }
        catch (CoreException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            this.showErrorDialog(OPERATION_FAILED, String.format(COULD_NOT_CREATE_PROJECT, ex.getMessage()));
            return false;
        }
    }
}

