/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.js.debug;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.dirigible.repository.ext.debug.BreakpointMetadata;
import org.eclipse.dirigible.repository.ext.debug.DebugModel;
import org.eclipse.dirigible.repository.ext.debug.DebugModelFacade;
import org.eclipse.dirigible.repository.ext.debug.DebugSessionModel;
import org.eclipse.dirigible.repository.ext.debug.IDebugController;
import org.eclipse.dirigible.repository.ext.debug.LinebreakMetadata;
import org.eclipse.dirigible.repository.logging.Logger;

public class WebSocketDebugController
implements IDebugController {
    private String user;
    private static final Logger LOGGER = Logger.getLogger(WebSocketDebugController.class);

    public WebSocketDebugController(String user) {
        this.user = user;
    }

    public void register(DebugSessionModel session) {
    }

    public void finish(DebugSessionModel session) {
    }

    public void onLineChange(LinebreakMetadata linebreak, DebugSessionModel session) {
    }

    public void refreshVariables() {
    }

    public void refreshBreakpoints() {
    }

    public void refresh() {
    }

    public void stepInto() {
        if (this.checkDebugExecutor()) {
            this.getDebugModel().getActiveSession().getDebugExecutor().stepInto();
        }
    }

    public void stepOver() {
        if (this.checkDebugExecutor()) {
            this.getDebugModel().getActiveSession().getDebugExecutor().stepOver();
        }
    }

    public void continueExecution() {
        if (this.checkDebugExecutor()) {
            this.getDebugModel().getActiveSession().getDebugExecutor().continueExecution();
        }
    }

    public void skipAllBreakpoints() {
        if (this.checkDebugExecutor()) {
            this.getDebugModel().getActiveSession().getDebugExecutor().skipAllBreakpoints();
        }
    }

    public void setBreakpoint(String path, int row) {
        BreakpointMetadata breakpoint = new BreakpointMetadata(path, Integer.valueOf(row));
        this.getDebugModel().getBreakpointsMetadata().getBreakpoints().add(breakpoint);
    }

    public void clearBreakpoint(String path, int row) {
        BreakpointMetadata breakpoint = new BreakpointMetadata(path, Integer.valueOf(row));
        Set breakpoints = this.getDebugModel().getBreakpointsMetadata().getBreakpoints();
        Iterator iterator = breakpoints.iterator();
        while (iterator.hasNext()) {
            BreakpointMetadata breakpointMetadata = (BreakpointMetadata)iterator.next();
            if (!breakpointMetadata.equals((Object)breakpoint)) continue;
            iterator.remove();
            break;
        }
    }

    public void clearAllBreakpoints() {
        this.getDebugModel().getBreakpointsMetadata().getBreakpoints().clear();
    }

    private DebugModel getDebugModel() {
        return DebugModelFacade.getDebugModel((String)this.user);
    }

    private boolean checkDebugExecutor() {
        if (this.getDebugModel().getActiveSession() == null) {
            LOGGER.error("No active debug session");
            return false;
        }
        if (this.getDebugModel().getActiveSession().getDebugExecutor() == null) {
            LOGGER.error("Active debug session exists, but there is no executor assigned");
            return false;
        }
        return true;
    }
}

