/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.js.debug;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.ext.debug.DebugModel;
import org.eclipse.dirigible.repository.ext.utils.RequestUtils;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.js.JavaScriptExecutor;
import org.eclipse.dirigible.runtime.js.debug.InvocationErrorReporter;
import org.eclipse.dirigible.runtime.js.debug.JavaScriptDebugger;
import org.eclipse.dirigible.runtime.js.debug.WebSocketDebugSessionServletInternal;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.debug.Debugger;

public class JavaScriptDebuggingExecutor
extends JavaScriptExecutor {
    private static final Logger logger = Logger.getLogger(JavaScriptDebuggingExecutor.class);
    private static final String JAVA_SCRIPT_DEBUGGER = "JavaScript Debugger";
    private DebugModel debugModel;

    private JavaScriptDebuggingExecutor(IRepository repository, String rootPath, String secondaryRootPath) {
        super(repository, rootPath, secondaryRootPath);
    }

    public JavaScriptDebuggingExecutor(IRepository repository, String rootPath, String secondaryRootPath, DebugModel debugModel) {
        super(repository, rootPath, secondaryRootPath);
        this.debugModel = debugModel;
    }

    @Override
    protected void beforeExecution(HttpServletRequest request, HttpServletResponse response, String module, Context context) {
        logger.debug("entering JavaScriptDebuggingExecutor.beforeExecution()");
        InvocationErrorReporter reporter = new InvocationErrorReporter();
        context.setErrorReporter((ErrorReporter)reporter);
        logger.debug("creating JavaScriptDebugger");
        JavaScriptDebugger debugger = new JavaScriptDebugger(this.debugModel, request);
        context.setDebugger((Debugger)debugger, (Object)JAVA_SCRIPT_DEBUGGER);
        logger.debug("created JavaScriptDebugger");
        String userId = RequestUtils.getUser((HttpServletRequest)request);
        WebSocketDebugSessionServletInternal.sendCurrentDebugModelSessionsToUser(userId, this.debugModel);
        context.setGeneratingDebug(true);
        context.setOptimizationLevel(-1);
        logger.debug("exiting JavaScriptDebuggingExecutor.beforeExecution()");
    }
}

