/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.js.debug;

import java.util.Set;
import org.eclipse.dirigible.repository.ext.debug.BreakpointMetadata;
import org.eclipse.dirigible.repository.ext.debug.DebugSessionModel;
import org.eclipse.dirigible.repository.ext.debug.IDebugExecutor;
import org.eclipse.dirigible.runtime.js.debug.JavaScriptDebugFrame;
import org.eclipse.dirigible.runtime.js.debug.JavaScriptDebugger;

public class DebuggerActionCommander
implements IDebugExecutor {
    private boolean executing = false;
    private IDebugExecutor.DebugCommand currentCommand;
    private JavaScriptDebugFrame debugFrame;
    private JavaScriptDebugger debugger;
    private String sessionId;
    private String executionId;
    private String userId;
    private DebugSessionModel session;

    public DebuggerActionCommander(DebugSessionModel session, String sessionId, String executionId, String userId) {
        this.session = session;
        this.sessionId = sessionId;
        this.executionId = executionId;
        this.userId = userId;
        this.init();
    }

    public void init() {
        this.currentCommand = null;
        this.executing = false;
    }

    public void continueExecution() {
        this.currentCommand = IDebugExecutor.DebugCommand.CONTINUE;
    }

    public void pauseExecution() {
        this.executing = false;
    }

    public boolean isExecuting() {
        return this.executing;
    }

    public void resumeExecution() {
        this.executing = true;
    }

    public void stepOver() {
        this.currentCommand = IDebugExecutor.DebugCommand.STEPOVER;
        this.resumeExecution();
    }

    public void stepInto() {
        this.currentCommand = IDebugExecutor.DebugCommand.STEPINTO;
        this.resumeExecution();
    }

    public Set<BreakpointMetadata> getBreakpoints() {
        return this.session.getModel().getBreakpointsMetadata().getBreakpoints();
    }

    public void skipAllBreakpoints() {
        this.currentCommand = IDebugExecutor.DebugCommand.SKIP_ALL_BREAKPOINTS;
        this.resumeExecution();
    }

    public IDebugExecutor.DebugCommand getCommand() {
        return this.currentCommand;
    }

    public JavaScriptDebugFrame getDebugFrame() {
        return this.debugFrame;
    }

    public void setDebugFrame(JavaScriptDebugFrame debugFrame) {
        this.debugFrame = debugFrame;
    }

    public JavaScriptDebugger getDebugger() {
        return this.debugger;
    }

    public void setDebugger(JavaScriptDebugger debugger) {
        this.debugger = debugger;
    }

    public void clean() {
        this.debugFrame = null;
        this.debugger = null;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getUserId() {
        return this.userId;
    }
}

